/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.png;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MeteredInputStream
extends FilterInputStream {
    int bytesLeft;
    int marked;

    public MeteredInputStream(InputStream inputStream, int n) {
        super(inputStream);
        this.bytesLeft = n;
    }

    public final int available() throws IOException {
        int n = this.in.available();
        return n > this.bytesLeft ? this.bytesLeft : n;
    }

    public final void close() throws IOException {
    }

    public final void mark(int n) {
        this.marked = this.bytesLeft;
        this.in.mark(n);
    }

    public final boolean markSupported() {
        return this.in.markSupported();
    }

    public final int read() throws IOException {
        if (this.bytesLeft > 0) {
            int n = this.in.read();
            if (n != -1) {
                --this.bytesLeft;
            }
            return n;
        }
        return -1;
    }

    public final int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public final int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.bytesLeft > 0) {
            int n3 = this.in.read(byArray, n, n2 = n2 > this.bytesLeft ? this.bytesLeft : n2);
            if (n3 > 0) {
                this.bytesLeft -= n3;
            }
            return n3;
        }
        return -1;
    }

    public final void reset() throws IOException {
        this.in.reset();
        this.bytesLeft = this.marked;
    }

    public final long skip(long l) throws IOException {
        long l2 = this.in.skip(l = l > (long)this.bytesLeft ? (long)this.bytesLeft : l);
        if (l2 > 0L) {
            this.bytesLeft = (int)((long)this.bytesLeft - l2);
        }
        return l2;
    }
}

