/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.tools.string;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public abstract class DateFormatter {
    public static final String Default = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String Numerical = "yyyyMMddHHmmss";
    public static final String NumericalMSecs = "yyyyMMddHHmmssSSS";
    public static final String Short = "yy-MM-dd HH:mm";
    public static final String Medium = "yyyy-MM-dd HH:mm:ss";
    public static final String Long = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String German = "dd.MM.yyyy HH:mm:ss";
    private static DateFormat DefaultDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    public static String getCurrentDateTimeString() {
        return DateFormatter.getDateTimeString(new Date());
    }

    public static String getDateTimeString(Calendar c) {
        return DateFormatter.getDateTimeString(c.getTime());
    }

    public static String getDateTimeString(Date d) {
        return DefaultDateFormat.format(d);
    }

    public static String getDateTimeString(long l) {
        return DefaultDateFormat.format(new Date(l));
    }

    public static Date parse(String s) {
        try {
            return DefaultDateFormat.parse(s);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String getCurrentDateTimeString(String format) {
        return DateFormatter.getDateTimeString(new Date(), format);
    }

    public static String getDateTimeString(Calendar c, String format) {
        return DateFormatter.getDateTimeString(c.getTime(), format);
    }

    public static String getDateTimeString(Date d, String format) {
        return new SimpleDateFormat(format).format(d);
    }

    public static String getDateTimeString(long l, String format) {
        return new SimpleDateFormat(format).format(new Date(l));
    }

    public static Date parse(String s, String format) {
        try {
            return new SimpleDateFormat(format).parse(s);
        }
        catch (ParseException e) {
            return null;
        }
    }
}

