/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.aiff;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.AiffModule;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import java.io.DataInputStream;
import java.io.IOException;

public class AudioRecChunk
extends Chunk {
    public AudioRecChunk(AiffModule module, ChunkHeader hdr, DataInputStream dstrm) {
        super(module, hdr, dstrm);
    }

    @Override
    public boolean readChunk(RepInfo info) throws IOException {
        AiffModule module = (AiffModule)this._module;
        if (this.bytesLeft != 24L) {
            info.setMessage((Message)new ErrorMessage("Audio Recording Chunk is incorrect size", module.getNByte()));
            info.setWellFormed(false);
            return false;
        }
        byte[] buf = new byte[24];
        ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])buf, (ModuleBase)module);
        module.addAiffProperty(new Property("AudioRecording", PropertyType.BYTE, PropertyArity.ARRAY, (Object)buf));
        return true;
    }
}

