/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.signature.compiler;

import java.util.ArrayList;
import java.util.List;
import net.byteseek.parser.ParseException;
import net.byteseek.parser.Parser;
import net.byteseek.parser.StringParseReader;
import net.byteseek.parser.tree.ParseTree;
import net.byteseek.parser.tree.ParseTreeType;
import net.byteseek.parser.tree.node.BaseNode;
import net.byteseek.parser.tree.node.ByteNode;
import net.byteseek.parser.tree.node.ChildrenNode;
import net.byteseek.parser.tree.node.IntNode;
import net.byteseek.parser.tree.node.StringNode;

public final class ByteSequenceParser
implements Parser<ParseTree> {
    public static final ByteSequenceParser PARSER = new ByteSequenceParser();
    private static final char SPACE = ' ';
    private static final char NEWLINE = '\n';
    private static final char CARRIAGE_RETURN = '\r';
    private static final char TAB = '\t';
    private static final char QUESTION_MARK = '?';
    private static final char OPEN_SQUARE_BRACKET = '[';
    private static final char OPEN_CURLY_BRACKET = '{';
    private static final char OPEN_ROUND_BRACKET = '(';
    private static final char SINGLE_QUOTE = '\'';
    private static final char CLOSE_ROUND_BRACKET = ')';
    private static final char VERTICAL_BAR = '|';
    private static final char EXCLAMATION_MARK = '!';
    private static final char COLON = ':';
    private static final char CLOSE_SQUARE_BRACKET = ']';
    private static final char CLOSE_CURLY_BRACKET = '}';
    private static final char ASTERISK = '*';
    private static final char HYPHEN = '-';
    private static final char BITWISE_AND = '&';
    private static final int MAX_BYTE_VALUE = 255;
    private static final ParseTree REPEAT_ANY = new ChildrenNode(ParseTreeType.ZERO_TO_MANY, BaseNode.ANY_NODE);

    public ParseTree parse(String droidExpression) throws ParseException {
        int currentChar;
        StringParseReader reader = new StringParseReader(droidExpression);
        ArrayList<Object> byteSequenceNodes = new ArrayList<Object>();
        block10: while ((currentChar = reader.read()) >= 0) {
            switch (currentChar) {
                case 42: {
                    byteSequenceNodes.add(REPEAT_ANY);
                    continue block10;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    continue block10;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: {
                    byteSequenceNodes.add(ByteNode.valueOf((byte)reader.readHexByte(currentChar)));
                    continue block10;
                }
                case 63: {
                    byteSequenceNodes.add(this.parseAnyNode(reader));
                    continue block10;
                }
                case 91: {
                    byteSequenceNodes.add(this.parseByteSet(reader));
                    continue block10;
                }
                case 123: {
                    byteSequenceNodes.add(this.parseGaps(reader));
                    continue block10;
                }
                case 40: {
                    byteSequenceNodes.add(this.parseAlternatives(reader));
                    continue block10;
                }
                case 39: {
                    byteSequenceNodes.add(this.parseString(reader));
                    continue block10;
                }
            }
            throw this.createParseException("Invalid character in droid expression", reader);
        }
        return new ChildrenNode(ParseTreeType.SEQUENCE, byteSequenceNodes);
    }

    private ParseTree parseGaps(StringParseReader reader) throws ParseException {
        int firstGapNumber = reader.readInt();
        int nextChar = reader.read();
        ChildrenNode node = null;
        switch (nextChar) {
            case 125: {
                node = new ChildrenNode(ParseTreeType.REPEAT, new ParseTree[]{new IntNode(firstGapNumber), BaseNode.ANY_NODE});
                break;
            }
            case 45: {
                if (reader.peekAhead() == 42) {
                    reader.read();
                    if (reader.read() != 125) break;
                    node = new ChildrenNode(ParseTreeType.REPEAT_MIN_TO_MANY, (ParseTree)new IntNode(firstGapNumber));
                    break;
                }
                int secondGapNumber = reader.readInt();
                if (reader.read() != 125) break;
                node = new ChildrenNode(ParseTreeType.REPEAT_MIN_TO_MAX, new ParseTree[]{new IntNode(firstGapNumber), new IntNode(secondGapNumber), BaseNode.ANY_NODE});
                break;
            }
            default: {
                throw this.createParseException("unexpected gap char: " + nextChar, reader);
            }
        }
        if (node == null) {
            throw this.createParseException("Invalid {n-m} syntax in", reader);
        }
        return node;
    }

    private ParseTree parseAlternatives(StringParseReader reader) throws ParseException {
        int currentChar;
        ArrayList<ParseTree> alternatives = new ArrayList<ParseTree>();
        ArrayList<Object> sequence = new ArrayList<ParseTree>();
        block9: while ((currentChar = reader.read()) >= 0) {
            switch (currentChar) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    continue block9;
                }
                case 41: {
                    if (sequence.size() == 0) {
                        throw this.createParseException("No sequence defined before closing bracket )", reader);
                    }
                    alternatives.add(this.createAlternativeNode(sequence));
                    break block9;
                }
                case 124: {
                    if (sequence.size() == 0) {
                        throw this.createParseException("No sequence defined before alternative |", reader);
                    }
                    alternatives.add(this.createAlternativeNode(sequence));
                    sequence = new ArrayList();
                    continue block9;
                }
                case 39: {
                    sequence.add(this.parseString(reader));
                    continue block9;
                }
                case 91: {
                    sequence.add(this.parseByteSet(reader));
                    continue block9;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: {
                    sequence.add((ParseTree)ByteNode.valueOf((byte)reader.readHexByte(currentChar)));
                    continue block9;
                }
                case 63: {
                    sequence.add(this.parseAnyNode(reader));
                    continue block9;
                }
                default: {
                    throw this.createParseException("Unknown character encountered in alternatives ( | ) sequence: " + (char)currentChar, reader);
                }
            }
        }
        if (currentChar == 41) {
            if (alternatives.size() == 1) {
                return (ParseTree)alternatives.get(0);
            }
            if (alternatives.size() > 1) {
                return new ChildrenNode(ParseTreeType.ALTERNATIVES, alternatives);
            }
        }
        throw this.createParseException("No closing ) for alternatives or empty alternatives ( | )", reader);
    }

    private ParseTree createAlternativeNode(List<ParseTree> values) {
        if (values.size() == 1) {
            return values.get(0);
        }
        return new ChildrenNode(ParseTreeType.SEQUENCE, values);
    }

    private ParseTree parseByteSet(StringParseReader reader) throws ParseException {
        int nextChar;
        boolean inverted = false;
        if (reader.peekAhead() == 33) {
            inverted = true;
            reader.read();
        }
        ArrayList<ParseTree> setNodes = new ArrayList<ParseTree>();
        block8: while ((nextChar = reader.read()) >= 0) {
            switch (nextChar) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    continue block8;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: {
                    setNodes.add((ParseTree)ByteNode.valueOf((byte)reader.readHexByte(nextChar)));
                    continue block8;
                }
                case 38: {
                    setNodes.add((ParseTree)new ByteNode(ParseTreeType.ALL_BITMASK, reader.readHexByte()));
                    continue block8;
                }
                case 39: {
                    setNodes.add((ParseTree)new StringNode(reader.readString('\'')));
                    continue block8;
                }
                case 45: 
                case 58: {
                    byte firstRangeValue = this.popLastByteValue(setNodes, reader);
                    byte secondRangeValue = this.readNextByteValue(reader);
                    setNodes.add((ParseTree)new ChildrenNode(ParseTreeType.RANGE, new ParseTree[]{ByteNode.valueOf((byte)firstRangeValue), ByteNode.valueOf((byte)secondRangeValue)}));
                    continue block8;
                }
                case 93: {
                    break block8;
                }
                default: {
                    throw this.createParseException("Unexpected character processing a set: " + (char)nextChar, reader);
                }
            }
        }
        if (nextChar != 93) {
            throw this.createParseException("The set was not closed by a square bracket.", reader);
        }
        if (setNodes.isEmpty()) {
            throw this.createParseException("There were no values defined in the [ ] set.", reader);
        }
        return new ChildrenNode(ParseTreeType.SET, setNodes, inverted);
    }

    private byte popLastByteValue(List<ParseTree> nodes, StringParseReader reader) throws ParseException {
        int index = nodes.size() - 1;
        if (index < 0) {
            throw this.createParseException("Expected a byte value or single quoted char.", reader);
        }
        return this.getByteValue(nodes.remove(index), reader);
    }

    private byte readNextByteValue(StringParseReader reader) throws ParseException {
        int nextChar = reader.read();
        switch (nextChar) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                return reader.readHexByte(nextChar);
            }
            case 39: {
                return this.getTextByteValue(reader.readString('\''), reader);
            }
        }
        throw this.createParseException("Could not find an expected byte value or a single quoted char.", reader);
    }

    private byte getTextByteValue(String text, StringParseReader reader) throws ParseException {
        if (text.length() != 1) {
            throw this.createParseException("Can only get a byte value from a single character.  The string was: " + text, reader);
        }
        char theChar = text.charAt(0);
        if (theChar > '\u00ff') {
            throw this.createParseException("Can only get a byte value from characters between 0 and 255.  The char value was: " + theChar, reader);
        }
        return (byte)theChar;
    }

    private byte getByteValue(ParseTree byteValue, StringParseReader reader) throws ParseException {
        if (byteValue.isValueInverted()) {
            throw this.createParseException("Can't get a single byte value when it is inverted", reader);
        }
        switch (byteValue.getParseTreeType()) {
            case STRING: {
                return this.getTextByteValue(byteValue.getTextValue(), reader);
            }
            case BYTE: {
                return byteValue.getByteValue();
            }
        }
        throw this.createParseException("Can't get a byte value from the type: " + byteValue.getParseTreeType(), reader);
    }

    private ParseTree parseString(StringParseReader reader) throws ParseException {
        return new StringNode(reader.readString('\''));
    }

    private ParseTree parseAnyNode(StringParseReader reader) throws ParseException {
        if (reader.read() == 63) {
            return BaseNode.ANY_NODE;
        }
        throw this.createParseException("? not followed by another ?", reader);
    }

    private ParseException createParseException(String message, StringParseReader reader) throws ParseException {
        return new ParseException(message + ". Position: " + reader.getPosition() + " in: " + reader.getString());
    }
}

