/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.png;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.zip.CRC32;

class PNGChunkUtil {
    protected CRC32 crcEngine = new CRC32();

    PNGChunkUtil() {
    }

    int getCRC() {
        return (int)this.crcEngine.getValue();
    }

    void resetCRC() {
        this.crcEngine.reset();
    }

    void updateCRC(byte by) {
        this.crcEngine.update(by);
    }

    void updateCRC(int n) {
        this.crcEngine.update((n & 0xFF000000) >> 24);
        this.crcEngine.update((n & 0xFF0000) >> 16);
        this.crcEngine.update((n & 0xFF00) >> 8);
        this.crcEngine.update(n & 0xFF);
    }

    void updateCRC(short s) {
        this.crcEngine.update((s & 0xFF00) >> 8);
        this.crcEngine.update(s & 0xFF);
    }

    void updateCRC(byte[] byArray) {
        this.crcEngine.update(byArray, 0, byArray.length);
    }

    void updateCRC(byte[] byArray, int n) {
        this.crcEngine.update(byArray, 0, n);
    }

    void write(DataOutputStream dataOutputStream, byte[] byArray, byte[] byArray2, int n) throws IOException {
        dataOutputStream.writeInt(n);
        dataOutputStream.write(byArray);
        dataOutputStream.write(byArray2, 0, n);
        this.resetCRC();
        this.updateCRC(byArray);
        this.updateCRC(byArray2, n);
        dataOutputStream.writeInt(this.getCRC());
    }
}

