/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.sax;

import com.exlibris.core.infra.common.sax.UnEscapeSequenceXMLFilter;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class SaxReplaceXsdVersions
extends DefaultHandler {
    private StringBuilder ieXml;
    private StringBuilder characters = new StringBuilder();
    private static final String INDENTATION_CHAR = " ";
    private static final int INDENTATION_DIFF = 2;
    private int currIndentation = -2;
    private static final String XML_START = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String DNX_QNAME = "dnx";
    private static final String VERSION_ATT = "version";
    private boolean currElementEmpty = false;
    private boolean hasSubElements = false;
    private boolean addIeText = true;
    private String xsdVersion = null;

    public SaxReplaceXsdVersions(String xsdVersion) throws Exception {
        this.ieXml = new StringBuilder(XML_START);
        this.currIndentation += 2;
        this.xsdVersion = xsdVersion;
    }

    public String getIeXml() {
        return this.ieXml.toString();
    }

    private void appendCurrentText() {
        if (this.addIeText) {
            this.ieXml.append(this.characters.toString().trim());
        }
        this.characters.setLength(0);
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        throw e;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.currElementEmpty = true;
        this.hasSubElements = false;
        this.addText(this.ieXml, qName);
        if (attributes != null && attributes.getLength() > 0) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (qName.equals(DNX_QNAME)) {
                    if (this.xsdVersion != null && i == 0) {
                        this.ieXml.append(' ').append(VERSION_ATT).append("=\"").append(this.xsdVersion).append('\"');
                    }
                    if (attributes.getQName(i).equals(VERSION_ATT)) continue;
                    this.ieXml.append(' ').append(attributes.getQName(i)).append("=\"").append(attributes.getValue(i)).append('\"');
                    continue;
                }
                this.ieXml.append(' ').append(attributes.getQName(i)).append("=\"").append(attributes.getValue(i)).append('\"');
            }
        }
        this.ieXml.append(">");
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.appendCurrentText();
        this.endElement(this.ieXml, qName);
    }

    private void addText(StringBuilder stringToWrite, String qName) {
        this.appendCurrentText();
        this.currIndentation += 2;
        stringToWrite.append('\n').append(StringUtils.repeat((String)INDENTATION_CHAR, (int)this.currIndentation)).append('<' + qName);
    }

    private void endElement(StringBuilder stringToWrite, String qName) {
        if (this.currElementEmpty) {
            stringToWrite.setLength(stringToWrite.length() - 1);
            stringToWrite.append("/>");
        } else {
            if (this.hasSubElements) {
                stringToWrite.append('\n').append(StringUtils.repeat((String)INDENTATION_CHAR, (int)this.currIndentation));
            }
            stringToWrite.append("</" + qName + '>');
        }
        this.currIndentation -= 2;
        this.currElementEmpty = false;
        this.hasSubElements = true;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.characters.append(ch, start, length);
        if (this.characters.toString().trim().length() > 0) {
            this.currElementEmpty = false;
        }
    }

    public void parse(InputSource is) throws SAXException, IOException {
        UnEscapeSequenceXMLFilter xmlFilter = new UnEscapeSequenceXMLFilter(XMLReaderFactory.createXMLReader());
        xmlFilter.setContentHandler(this);
        xmlFilter.parse(is);
    }
}

