/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.sax;

import com.exlibris.core.infra.common.sax.UnEscapeSequenceXMLFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class SaxXmlStringToLinesArray
extends DefaultHandler {
    private boolean currElementEmpty = false;
    private boolean hasSubElements = false;
    private boolean first = true;
    private String rootTag = "";
    private StringBuilder characters = new StringBuilder();
    private StringBuilder line = new StringBuilder();
    List<String> lines = new ArrayList<String>();

    public List<String> getLines() {
        return this.lines;
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        throw e;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        this.lines.add(this.line.toString());
        this.line.delete(0, this.line.length());
        if (this.first) {
            this.rootTag = qName;
            this.first = false;
        }
        this.line.append("<" + qName);
        if (attributes != null && attributes.getLength() > 0) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                this.line.append(' ').append(attributes.getQName(i)).append("=\"").append(attributes.getValue(i)).append('\"');
            }
        }
        this.line.append(">");
        this.currElementEmpty = true;
        this.hasSubElements = false;
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        this.appendCurrentText();
        if (this.currElementEmpty) {
            this.line.setLength(this.line.length() - 1);
            this.line.append("/>");
        } else {
            if (this.hasSubElements) {
                this.lines.add(this.line.toString());
                this.line.delete(0, this.line.length());
            }
            this.line.append("</" + qName + '>');
        }
        if (qName.equals(this.rootTag)) {
            this.lines.add(this.line.toString());
        }
        this.currElementEmpty = false;
        this.hasSubElements = true;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.characters.append(ch, start, length);
        if (this.characters.toString().trim().length() > 0) {
            this.currElementEmpty = false;
        }
    }

    private void appendCurrentText() {
        this.line.append(this.characters.toString().trim());
        this.characters.setLength(0);
    }

    public void parse(InputSource is) throws SAXException, IOException {
        UnEscapeSequenceXMLFilter xmlFilter = new UnEscapeSequenceXMLFilter(XMLReaderFactory.createXMLReader());
        xmlFilter.setContentHandler(this);
        xmlFilter.parse(is);
    }
}

