/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.model;

import com.exlibris.core.infra.model.HOwneredEntity;
import com.exlibris.core.infra.model.annotation.Searchable;
import java.util.Calendar;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

@NamedQueries(value={@NamedQuery(name="findSequences", query="from HFrSequence"), @NamedQuery(name="findSequenceByName", query="from HFrSequence seq where seq.name=:name"), @NamedQuery(name="findSequenceById", query="from HFrSequence seq where seq.id=:id"), @NamedQuery(name="findSequenceByOwner", query="from HFrSequence seq where seq.owner=:owner and active = 1"), @NamedQuery(name="findAllSequences", query="from HFrSequence seq where active = 1")})
@Table(name="HFrSequence", uniqueConstraints={@UniqueConstraint(columnNames={"NAME"})})
@Entity
public class HFrSequence
extends HOwneredEntity {
    public static final String FIND_SEQUENCES = "findSequences";
    public static final String FIND_SEQUENCE_BY_NAME = "findSequenceByName";
    public static final String FIND_SEQUENCE_BY_ID = "findSequenceById";
    public static final String FIND_SEQUENCES_BY_OWNER = "findSequenceByOwner";
    public static final String FIND_ALL_ACTIVE_SEQUENCES = "findAllSequences";
    private static final long serialVersionUID = 1L;
    private String name;
    private String description;
    private Boolean active = true;
    private String indexXml;
    private String prefix;
    private long begin;
    private long end;
    private int fixedLength;

    public HFrSequence() {
        this.begin = 1L;
        this.end = 100000L;
    }

    public HFrSequence(HFrSequence sequence) {
        this.setName(sequence.getName());
        this.setDescription(sequence.getDescription());
        this.setActive(sequence.getActive());
        this.setCreator(sequence.getCreator());
        this.setCreateDate(Calendar.getInstance());
        this.setModifiedBy(sequence.getModifiedBy());
        this.setModificationDate(Calendar.getInstance());
    }

    @Searchable
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Searchable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public long getBegin() {
        return this.begin;
    }

    public void setBegin(long begin) {
        this.begin = begin;
    }

    public long getEnd() {
        return this.end;
    }

    public void setEnd(long end) {
        this.end = end;
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    @Column(name="index_xml", length=4000)
    public String getIndexXml() {
        return this.indexXml;
    }

    public void setIndexXml(String indexXml) {
        this.indexXml = indexXml;
    }

    public int getFixedLength() {
        return this.fixedLength;
    }

    public void setFixedLength(int fixedLength) {
        this.fixedLength = fixedLength;
    }
}

