/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.aipcreatorETH.ingest;

import ch.docuteam.darc.exceptions.CantSetSubmitStatusNotAllowedException;
import ch.docuteam.darc.exceptions.MetadataElementIsNotAllowedException;
import ch.docuteam.darc.exceptions.MetadataElementIsNotDefinedException;
import ch.docuteam.darc.exceptions.MetadataElementSetterPostActionException;
import ch.docuteam.darc.ingest.AIPCreator;
import ch.docuteam.darc.mdconfig.LevelOfDescription;
import ch.docuteam.darc.mets.Document;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.darc.mets.structmap.NodeFile;
import ch.docuteam.darc.mets.structmap.NodeFolder;
import ch.docuteam.darc.premis.Object;
import ch.docuteam.tools.file.FileFilter;
import ch.docuteam.tools.file.Zipper;
import ch.docuteam.tools.file.exception.FileUtilExceptionListException;
import ch.docuteam.tools.file.ssh.SFTPChannel;
import ch.docuteam.tools.id.UniqueID;
import ch.docuteam.tools.os.OperatingSystem;
import ch.docuteam.tools.out.Logger;
import com.exlibris.core.sdk.consts.Enum;
import com.exlibris.core.sdk.formatting.DublinCore;
import com.exlibris.core.sdk.formatting.DublinCoreFactory;
import com.exlibris.core.sdk.utils.FileUtil;
import com.exlibris.digitool.common.dnx.DnxDocument;
import com.exlibris.digitool.common.dnx.DnxDocumentFactory;
import com.exlibris.digitool.common.dnx.DnxDocumentHelper;
import com.exlibris.dps.sdk.deposit.IEParser;
import com.exlibris.dps.sdk.deposit.IEParserFactory;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpException;
import de.schlichtherle.truezip.file.TFile;
import gov.loc.mets.FileType;
import gov.loc.mets.MdSecType;
import gov.loc.mets.MetsType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Vector;
import javax.swing.tree.TreePath;
import org.apache.xmlbeans.XmlObject;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;

public class AIPCreatorETH
implements AIPCreator {
    private static final String FeedbackRelativeFolderName = "/feedback";
    private static final String OSSuffix = OperatingSystem.isWindows() ? "Win" : (OperatingSystem.isMacOSX() ? "OSX" : (OperatingSystem.isLinux() ? "Linux" : ""));
    private static final Map<String, String> MetadataNamesMapToDC = new HashMap<String, String>();
    public static boolean IsTestRun;
    public static boolean IsWithoutDB;
    private String aipFolderPath;
    private String executionId;
    private String deeplinkPatternCollection;
    private String deeplinkPatternIE;
    private String ingestSubmitDir;
    private String sshHost;
    private String sshUser;
    private int sshPort;
    private String sshPathToPK;
    private String sshPathToKnownHosts;
    private String dbHost;
    private String dbPort;
    private String dbService;
    private String dbName;
    private String dbUserName;
    private String dbUserPassword;

    public void initialize(Properties properties) throws Exception {
        this.ingestSubmitDir = properties.getProperty("AIPCreator.ingestSubmitDir." + OSSuffix);
        this.sshHost = properties.getProperty("AIPCreator.sshHost");
        String sshPortString = properties.getProperty("AIPCreator.sshPort");
        this.sshPort = sshPortString == null ? 22 : Integer.parseInt(sshPortString);
        this.sshUser = properties.getProperty("AIPCreator.sshUser");
        if (this.sshUser == null) {
            this.sshUser = OperatingSystem.userName();
        }
        this.sshPathToPK = properties.getProperty("AIPCreator.sshPathToPK");
        if (this.sshPathToPK == null) {
            this.sshPathToPK = OperatingSystem.userHome() + "/.ssh/id_rsa";
        }
        this.sshPathToKnownHosts = properties.getProperty("AIPCreator.sshPathToKnownHosts");
        if (this.sshPathToKnownHosts == null) {
            this.sshPathToKnownHosts = OperatingSystem.userHome() + "/.ssh/known_hosts";
        }
        this.aipFolderPath = properties.getProperty("AIPCreator.aipFolderPath");
        this.executionId = properties.getProperty("AIPCreator.executionId");
        this.deeplinkPatternCollection = properties.getProperty("AIPCreator.deeplinkPatternCollection");
        this.deeplinkPatternIE = properties.getProperty("AIPCreator.deeplinkPatternIE");
        if (IsWithoutDB) {
            return;
        }
        this.dbHost = properties.getProperty("AIPCreator.dbHost");
        this.dbPort = properties.getProperty("AIPCreator.dbPort");
        this.dbService = properties.getProperty("AIPCreator.dbService");
        this.dbName = properties.getProperty("AIPCreator.dbName", properties.getProperty("AIPCreator.dbUserName"));
        this.dbUserName = properties.getProperty("AIPCreator.dbUserName");
        this.dbUserPassword = properties.getProperty("AIPCreator.dbUserPassword");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> checkSubmission(ch.docuteam.darc.mets.Document document) {
        this.checkPropertiesForSubmit();
        Vector<String> rejectMessages = new Vector<String>();
        String sipName = document.getSIPName();
        Logger.info((java.lang.Object)("Performing submit-check in SIP: '" + sipName + "'"));
        if (document.isReadOnly()) {
            Logger.debug((java.lang.Object)("Can't submit because SIP is read-only: '" + sipName + "'"));
            rejectMessages.add("MessageSubmitSIPIsReadOnly '" + sipName + "'");
        }
        if (document.isLocked()) {
            Logger.debug((java.lang.Object)("Can't submit because SIP is locked: '" + sipName + "'"));
            rejectMessages.add("MessageSubmitSIPIsLocked '" + sipName + "'");
        }
        boolean hasNodesThatCanBeSubmitted = false;
        for (NodeAbstract n : document.getStructureMap().getRoot().getWithDescendants()) {
            if (n.getSubmitStatus() != NodeAbstract.SubmitStatus.SubmitRequested) continue;
            hasNodesThatCanBeSubmitted = true;
            break;
        }
        if (!hasNodesThatCanBeSubmitted) {
            Logger.debug((java.lang.Object)("Can't submit because SIP has no submit requests: '" + sipName + "'"));
            rejectMessages.add("MessageSubmitSIPHasNoSubmitRequests '" + sipName + "'");
        }
        Logger.debug((java.lang.Object)("Checking all nodes in SIP: '" + sipName + "'"));
        for (String message : this.submitCheckRecursive(document.getStructureMap().getRoot())) {
            rejectMessages.add(message);
        }
        if (this.sshHost == null) {
            String submitSIPName = this.getSIPNameForSubmit(document);
            if (new File(this.ingestSubmitDir + File.separator + submitSIPName).exists()) {
                rejectMessages.add("MessageSubmitSIPExistsAlreadyInSubmitFolder '" + submitSIPName + "'");
            }
        } else {
            SFTPChannel channel = new SFTPChannel(this.sshUser, this.sshHost, this.sshPort, this.sshPathToPK, this.sshPathToKnownHosts);
            try {
                channel.readFile("doesnotexist", ".");
            }
            catch (JSchException | SftpException | FileNotFoundException e) {
                if (!(e instanceof SftpException) || !e.getMessage().equals("No such file")) {
                    rejectMessages.add("MessageSubmitSSHConnectionError " + this.sshUser + "@" + this.sshHost + ":" + this.sshPort + " with " + this.sshPathToPK + " and " + this.sshPathToKnownHosts);
                }
            }
            finally {
                channel.closeConnection();
            }
        }
        if (rejectMessages.isEmpty()) {
            Logger.debug((java.lang.Object)"SIP is OK");
        } else {
            Logger.debug((java.lang.Object)("Can't submit SIP because: " + rejectMessages));
        }
        return rejectMessages;
    }

    public List<String> submit(ch.docuteam.darc.mets.Document sip) throws Exception {
        this.checkPropertiesForSubmit();
        List<String> rejectMessages = this.checkSubmission(sip);
        if (!rejectMessages.isEmpty()) {
            return rejectMessages;
        }
        String sipName = sip.getSIPName();
        block2: for (NodeAbstract node : ((NodeFolder)sip.getStructureMap().getRoot()).getDescendants()) {
            if (!node.getSubmitStatus().equals((java.lang.Object)NodeAbstract.SubmitStatus.SubmitRequested)) continue;
            NodeFolder nodeParent = (NodeFolder)node.getParent();
            while (nodeParent.getSubmitStatus().equals((java.lang.Object)NodeAbstract.SubmitStatus.Submitted)) {
                nodeParent.setSubmitStatus_force(NodeAbstract.SubmitStatus.SubmitRequested);
                if (nodeParent.isRoot().booleanValue()) continue block2;
                nodeParent = (NodeFolder)nodeParent.getParent();
            }
        }
        Logger.debug((java.lang.Object)("Setting all 'SubmitRequested' status entries to 'SubmitRequestPending' in SIP: '" + sipName + "'"));
        sip.getStructureMap().getRoot().setSubmitStatusAllOrNone(NodeAbstract.SubmitStatus.SubmitRequested, NodeAbstract.SubmitStatus.SubmitRequestPending);
        sip.saveWithBackup();
        Document.Mode rememberedMode = sip.getMode();
        String rememberedFilePath = sip.getFilePath();
        String rememberedOriginalSIPFolder = sip.getOriginalSIPFolder();
        boolean rememberedIsWorkingCopy = sip.isWorkingCopy;
        Logger.debug((java.lang.Object)("Creating 'SubmitRequestPending' lock for SIP: '" + sipName + "'"));
        sip.lockAsSubmitRequestPending();
        if (!sip.isZIPFile()) {
            sip.cleanupWorkingCopy();
            sip.setFilePath(ch.docuteam.tools.file.FileUtil.asCanonicalFileName((String)(sip.getOriginalSIPFolder() + File.separator + "mets.xml")));
            sip.isWorkingCopy = false;
        }
        ArrayList<java.lang.Object> sourcePaths = new ArrayList<java.lang.Object>();
        sourcePaths.add(sip.getSIPFolder() + "/mets.xml");
        for (NodeAbstract node : sip.getStructureMap().getRoot().getWithDescendants()) {
            if (!node.getSubmitStatus().equals((java.lang.Object)NodeAbstract.SubmitStatus.SubmitRequestPending) || !node.isFile()) continue;
            sourcePaths.add(node.getAbsolutePathString());
        }
        try {
            Logger.debug((java.lang.Object)("Zipping to ingest-folder: '" + this.ingestSubmitDir + "' SIP: '" + sipName + "'"));
            if (this.sshHost == null) {
                Zipper.zip((String[])sourcePaths.toArray(new String[0]), (String)(this.ingestSubmitDir + File.separator + this.getSIPNameForSubmit(sip)));
                ch.docuteam.tools.file.FileUtil.copyToOverwriting((String)LevelOfDescription.getInitializationFileAbsolutePath(), (String)(new File(this.ingestSubmitDir).getParent() + "/config/levels.xml"));
            } else {
                File tempZIPFile = new File(ch.docuteam.tools.file.FileUtil.getTempFolder() + File.separator + UniqueID.getString() + File.separator + this.getSIPNameForSubmit(sip));
                tempZIPFile.getParentFile().mkdirs();
                ch.docuteam.tools.file.FileUtil.deleteOnExit((File)tempZIPFile.getParentFile());
                Zipper.zip((String[])sourcePaths.toArray(new String[0]), (String)tempZIPFile.getAbsolutePath());
                Logger.debug((java.lang.Object)("Using SFTP: " + this.sshUser + "@" + this.sshHost + ":" + this.sshPort + " with " + this.sshPathToPK + " and " + this.sshPathToKnownHosts));
                SFTPChannel channel = new SFTPChannel(this.sshUser, this.sshHost, this.sshPort, this.sshPathToPK, this.sshPathToKnownHosts);
                channel.transferFileLeaveSessionOpen(tempZIPFile.getAbsolutePath(), this.getSIPNameForSubmit(sip), this.ingestSubmitDir);
                channel.transferFileLeaveSessionOpen(LevelOfDescription.getInitializationFileAbsolutePath(), "levels.xml", "../config");
            }
        }
        catch (Exception e) {
            Logger.error((java.lang.Object)("Copying to submit folder failed, reverting to original SIP: '" + sipName + "'"), (Throwable)e);
            sip.unlock_dontCheck();
            sip.setMode(rememberedMode);
            sip.setFilePath(rememberedFilePath);
            sip.setOriginalSIPFolder(rememberedOriginalSIPFolder);
            sip.isWorkingCopy = rememberedIsWorkingCopy;
            sip.revertToLastBackup();
            throw new Exception("Copying to submit folder failed, reverting to original SIP: '" + sipName + "'", e);
        }
        return rejectMessages;
    }

    public List<String> checkIngestFeedback(String workspaceFolderPath) throws IOException, FileUtilExceptionListException {
        this.checkPropertiesForSubmit();
        String ingestFeedbackDir = null;
        Vector<String> ingestFeedbackFoundForSIPs = new Vector<String>();
        SFTPChannel channelSftp = null;
        ChannelSftp basicChannelSftp = null;
        Logger.debug((java.lang.Object)("Checking ingest feedback for workspace folder: '" + workspaceFolderPath + "'"));
        if (workspaceFolderPath == null) {
            return ingestFeedbackFoundForSIPs;
        }
        File workspaceFolder = new File(workspaceFolderPath);
        if (!workspaceFolder.exists()) {
            return ingestFeedbackFoundForSIPs;
        }
        if (!workspaceFolder.isDirectory()) {
            return ingestFeedbackFoundForSIPs;
        }
        if (workspaceFolder.list().length == 0) {
            return ingestFeedbackFoundForSIPs;
        }
        List<java.lang.Object> feedbackFilenames = new ArrayList();
        if (this.sshHost == null) {
            ingestFeedbackDir = new File(this.ingestSubmitDir).getParent() + FeedbackRelativeFolderName;
            File ingestFeedbackFolder = new File(ingestFeedbackDir);
            if (!ingestFeedbackFolder.exists()) {
                return ingestFeedbackFoundForSIPs;
            }
            if (!ingestFeedbackFolder.isDirectory()) {
                return ingestFeedbackFoundForSIPs;
            }
            feedbackFilenames = Arrays.asList(ingestFeedbackFolder.list((FilenameFilter)FileFilter.SIPs));
        } else {
            Vector feedbackEntries;
            ingestFeedbackDir = this.ingestSubmitDir + "/../feedback";
            Logger.debug((java.lang.Object)("Using SSH: " + this.sshUser + "@" + this.sshHost + ":" + this.sshPort + " with " + this.sshPathToPK + " and " + this.sshPathToKnownHosts));
            channelSftp = new SFTPChannel(this.sshUser, this.sshHost, this.sshPort, this.sshPathToPK, this.sshPathToKnownHosts);
            try {
                basicChannelSftp = channelSftp.getChannelSftp();
            }
            catch (JSchException | SftpException | FileNotFoundException e) {
                Logger.error((java.lang.Object)"Error opening SFTP channel", (Throwable)e);
                return ingestFeedbackFoundForSIPs;
            }
            try {
                feedbackEntries = basicChannelSftp.ls(ingestFeedbackDir);
            }
            catch (SftpException sftpException) {
                Logger.error((java.lang.Object)"Error listing the feedback folder content on the SFTP host", (Throwable)sftpException);
                return ingestFeedbackFoundForSIPs;
            }
            try {
                for (ChannelSftp.LsEntry entry : feedbackEntries) {
                    Vector subentries = basicChannelSftp.ls(ingestFeedbackDir + "/" + entry.getFilename());
                    for (ChannelSftp.LsEntry subentry : subentries) {
                        if (!subentry.getFilename().equalsIgnoreCase("mets.xml")) continue;
                        feedbackFilenames.add(entry.getFilename());
                    }
                }
            }
            catch (SftpException sftpException) {
                Logger.error((java.lang.Object)"Error listing individual feedback folders", (Throwable)sftpException);
                return ingestFeedbackFoundForSIPs;
            }
        }
        if (feedbackFilenames.size() == 0) {
            return ingestFeedbackFoundForSIPs;
        }
        for (String string : feedbackFilenames) {
            File feedbackMETSFile;
            String lockedBy;
            Logger.debug((java.lang.Object)("Found ingest feedback for SIP: '" + string + "'"));
            String sipName = null;
            String sipPath = null;
            String feedbackSIPPath = null;
            if (string.endsWith("_zip")) {
                sipName = string.substring(0, string.length() - 4) + ".zip";
                sipPath = workspaceFolder + "/" + sipName;
                if (!new File(sipPath).exists()) {
                    Logger.debug((java.lang.Object)("No SIP in Workspace: '" + sipName + "'"));
                    continue;
                }
                if (!new File(sipPath).isFile()) {
                    Logger.debug((java.lang.Object)("SIP is not a file: '" + sipName + "'"));
                    continue;
                }
                lockedBy = ch.docuteam.darc.mets.Document.lockedByWhom((String)sipPath);
                if (!ch.docuteam.darc.mets.Document.isLocked((String)sipPath) || !ch.docuteam.darc.mets.Document.lockedByWhom((String)sipPath).contains(NodeAbstract.SubmitStatus.SubmitRequestPending.toString())) {
                    Logger.debug((java.lang.Object)("No SubmitRequestPending lock: '" + lockedBy + "' for SIP: '" + sipName + "'"));
                    continue;
                }
                Logger.debug((java.lang.Object)("Replacing METS-file from ingest feedback for SIP: '" + sipName + "'"));
                feedbackSIPPath = ingestFeedbackDir + "/" + string;
                if (this.sshHost == null) {
                    feedbackMETSFile = new File((String)feedbackSIPPath + "/mets.xml");
                } else {
                    feedbackMETSFile = new File(ch.docuteam.tools.file.FileUtil.getTempFolder() + "mets" + UniqueID.getXML() + ".xml");
                    feedbackMETSFile.deleteOnExit();
                    try {
                        basicChannelSftp.get((String)feedbackSIPPath + "/mets.xml", feedbackMETSFile.getAbsolutePath());
                    }
                    catch (SftpException e) {
                        Logger.debug((java.lang.Object)("Could not fetch updated mets.xml for: '" + string + "'"), (Throwable)e);
                        continue;
                    }
                }
                TFile.cp((File)feedbackMETSFile, (File)new TFile(sipPath, "mets.xml"));
                TFile.umount();
            } else {
                sipPath = workspaceFolder + "/" + string;
                if (!new File(sipPath).exists()) {
                    Logger.debug((java.lang.Object)("No SIP in Workspace: '" + string + "'"));
                    continue;
                }
                if (!new File(sipPath).isDirectory()) {
                    Logger.debug((java.lang.Object)("SIP is not a directory: '" + string + "'"));
                    continue;
                }
                lockedBy = ch.docuteam.darc.mets.Document.lockedByWhom((String)sipPath);
                if (!ch.docuteam.darc.mets.Document.isLocked((String)sipPath) || !lockedBy.contains(NodeAbstract.SubmitStatus.SubmitRequestPending.toString())) {
                    Logger.debug((java.lang.Object)("No SubmitRequestPending lock: '" + lockedBy + "' for SIP: '" + string + "'"));
                    continue;
                }
                Logger.debug((java.lang.Object)("Replacing METS-file from ingest feedback for SIP: '" + string + "'"));
                feedbackSIPPath = ingestFeedbackDir + "/" + string;
                if (this.sshHost == null) {
                    feedbackMETSFile = new File(feedbackSIPPath + "/mets.xml");
                } else {
                    feedbackMETSFile = new File(ch.docuteam.tools.file.FileUtil.getTempFolder() + "/mets" + UniqueID.getXML() + ".xml");
                    feedbackMETSFile.deleteOnExit();
                    try {
                        basicChannelSftp.get(feedbackSIPPath + "/mets.xml", feedbackMETSFile.getAbsolutePath());
                    }
                    catch (SftpException e) {
                        Logger.debug((java.lang.Object)("Could not fetch updated mets.xml for: '" + string + "'"), (Throwable)e);
                        continue;
                    }
                }
                ch.docuteam.tools.file.FileUtil.copyToOverwriting((String)feedbackMETSFile.getAbsolutePath(), (String)(sipPath + "/mets.xml"));
            }
            ch.docuteam.tools.file.FileUtil.delete((String)(sipPath + ".lock"));
            String ingestSIPPath = this.ingestSubmitDir + "/" + string + ".zip";
            if (this.sshHost == null) {
                ch.docuteam.tools.file.FileUtil.delete((String)feedbackSIPPath);
                ch.docuteam.tools.file.FileUtil.delete((String)ingestSIPPath);
            } else {
                try {
                    basicChannelSftp.rm(feedbackSIPPath + "/mets.xml");
                    basicChannelSftp.rmdir(feedbackSIPPath);
                }
                catch (SftpException e) {
                    Logger.error((java.lang.Object)("Error cleaning feedback directory: '" + feedbackSIPPath + "'"), (Throwable)e);
                    continue;
                }
                try {
                    basicChannelSftp.rm(ingestSIPPath);
                }
                catch (SftpException e) {
                    Logger.error((java.lang.Object)("Error cleaning ingest directory: '" + ingestSIPPath + "'"), (Throwable)e);
                    continue;
                }
            }
            ingestFeedbackFoundForSIPs.add(string);
        }
        return ingestFeedbackFoundForSIPs;
    }

    public String getSIPNameForSubmit(ch.docuteam.darc.mets.Document sip) {
        return (String)(sip.isZIPFile() ? ch.docuteam.tools.file.FileUtil.asFileNameWithoutExtension((String)sip.getSIPName()) + "_zip" : sip.getSIPName()) + ".zip";
    }

    public String getSIPNameWithoutExtension(ch.docuteam.darc.mets.Document sip) {
        return sip.isZIPFile() ? ch.docuteam.tools.file.FileUtil.asFileNameWithoutExtension((String)sip.getSIPName()) : sip.getSIPName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> generateAIP(ch.docuteam.darc.mets.Document document) throws Exception {
        this.checkPropertiesForStorage();
        String sipName = this.getSIPNameWithoutExtension(document);
        Vector<String> rejectMessages = new Vector<String>();
        if (this.aipFolderPath == null) {
            Logger.debug((java.lang.Object)("Can't submit because AIPFolderPath is undefined: '" + sipName + "'"));
            rejectMessages.add("MessageSubmitAIPUndefinedSubmitFolderPath '" + sipName + "'");
            return rejectMessages;
        }
        String workspace = document.getStructureMap().getRoot().getDynamicMetadataValueForName("refCodeAdmin");
        String aipPath = this.aipFolderPath + File.separator + workspace + File.separator + sipName;
        if (IsTestRun) {
            this._prepareTestRun(aipPath);
        }
        if (new File(aipPath).exists()) {
            Logger.debug((java.lang.Object)("Can't submit because AIP: '" + aipPath + "' exists already."));
            rejectMessages.add("MessageSubmitAIPExistsAlreadyInSubmitFolder '" + aipPath + "'");
            return rejectMessages;
        }
        try {
            DB.initialize(this.dbHost, this.dbPort, this.dbService, this.dbName, this.dbUserName, this.dbUserPassword, this.executionId);
            for (NodeAbstract node : document.getStructureMap().getRoot().getWithDescendants()) {
                if (IsTestRun) {
                    DB._prepareTestRun(workspace, node.getPathString(), sipName);
                }
                if (!node.getSubmitStatus().equals((java.lang.Object)NodeAbstract.SubmitStatus.SubmitRequestPending) || !this.getAIPType(node).equals((java.lang.Object)AIPType.IE) || !DB.wasAlreadyIngested(workspace, sipName, node)) continue;
                Logger.debug((java.lang.Object)("Can't submit because AIP: '" + aipPath + "/" + node.getPathString() + "' was already ingested."));
                rejectMessages.add("MessageSubmitAIPWasAlreadyIngested '" + aipPath + "/" + node.getPathString() + "'");
            }
            if (!rejectMessages.isEmpty()) {
                Vector<String> vector = rejectMessages;
                return vector;
            }
            ch.docuteam.tools.file.FileUtil.createFolderOverwriting((String)aipPath);
            String submitTimestamp = document.getHeader().getLastModificationDate().replace("T", " ");
            rejectMessages.addAll(this.generateAIP(document.getStructureMap().getRoot(), workspace, sipName, submitTimestamp));
            if (rejectMessages.isEmpty()) {
                DB.logAIPCreationFinalizeOK(workspace, sipName);
            }
        }
        finally {
            DB.close();
        }
        return rejectMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void confirmStorage(ch.docuteam.darc.mets.Document document) throws SQLException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, MetadataElementIsNotDefinedException, MetadataElementIsNotAllowedException {
        this.checkPropertiesForStorage();
        String sipName = this.getSIPNameWithoutExtension(document);
        String workspace = document.getStructureMap().getRoot().getDynamicMetadataValueForName("refCodeAdmin");
        Logger.debug((java.lang.Object)("Checking storage status of SIP: '" + sipName + "'"));
        Map<java.lang.Object, java.lang.Object> mapIngestStatus = new HashMap();
        Map<java.lang.Object, java.lang.Object> mapEntityIDs = new HashMap();
        try {
            DB.initialize(this.dbHost, this.dbPort, this.dbService, this.dbName, this.dbUserName, this.dbUserPassword, this.executionId);
            mapIngestStatus = DB.getAllStatus(workspace, sipName);
            mapEntityIDs = DB.getAllEntityIDs(workspace, sipName);
        }
        finally {
            DB.close();
        }
        if (mapIngestStatus.isEmpty() || mapEntityIDs.isEmpty()) {
            Logger.info((java.lang.Object)("Nothing found in DB for SIP: '" + sipName + "'"));
            return;
        }
        boolean isFinished = true;
        for (java.lang.Object amdId : mapIngestStatus.keySet()) {
            IngestStatus ingestStatus = (IngestStatus)((java.lang.Object)mapIngestStatus.get(amdId));
            Logger.debug((java.lang.Object)("For SIP: '" + sipName + "' id: '" + (String)amdId + "' found status: '" + ingestStatus + "'"));
            if (ingestStatus == IngestStatus.FINISHED || ingestStatus == IngestStatus.REJECTED || ingestStatus == IngestStatus.DECLINED) continue;
            isFinished = false;
            break;
        }
        if (!isFinished) {
            Logger.info((java.lang.Object)("Not yet finished: '" + sipName + "'"));
            return;
        }
        boolean exceptionOccurred = false;
        block17: for (String string : mapIngestStatus.keySet()) {
            NodeAbstract node = document.getStructureMap().searchId(string);
            if (node == null) continue;
            try {
                switch (this.getAIPType(node)) {
                    case IE: {
                        node.setDynamicMetadataValueForName_force("locationOfOriginals", String.format(this.deeplinkPatternIE, mapEntityIDs.get(string)));
                        break;
                    }
                    case Collection: {
                        node.setDynamicMetadataValueForName_force("locationOfOriginals", String.format(this.deeplinkPatternCollection, mapEntityIDs.get(string)));
                        break;
                    }
                }
                IngestStatus ingestStatus = (IngestStatus)((java.lang.Object)mapIngestStatus.get(string));
                switch (ingestStatus) {
                    case FINISHED: {
                        node.setSubmitStatus(NodeAbstract.SubmitStatus.Submitted);
                        if (!node.isFolder() || this.getAIPType(node) != AIPType.IE) break;
                        for (MutableTreeTableNode child : ((NodeFolder)node).getDescendants()) {
                            ((NodeAbstract)child).setSubmitStatus(NodeAbstract.SubmitStatus.Submitted);
                        }
                        continue block17;
                    }
                    case REJECTED: 
                    case DECLINED: {
                        node.setSubmitStatus(NodeAbstract.SubmitStatus.SubmitFailed);
                        if (!node.isFolder() || this.getAIPType(node) != AIPType.IE) break;
                        for (MutableTreeTableNode child : ((NodeFolder)node).getDescendants()) {
                            ((NodeAbstract)child).setSubmitStatus(NodeAbstract.SubmitStatus.SubmitFailed);
                        }
                        continue block17;
                    }
                }
            }
            catch (CantSetSubmitStatusNotAllowedException e) {
                Logger.error((java.lang.Object)e.getMessage(), (Throwable)e);
                exceptionOccurred = true;
            }
            catch (MetadataElementSetterPostActionException e) {
                Logger.error((java.lang.Object)e.getMessage(), (Throwable)e);
                exceptionOccurred = true;
            }
        }
        if (!exceptionOccurred) {
            try {
                String feedbackPath = new File(document.getOriginalSIPFolder()).getParentFile().getParent() + FeedbackRelativeFolderName + File.separator + sipName;
                Logger.debug((java.lang.Object)("Sending feedback for SIP: '" + sipName + "' to folder: '" + feedbackPath + "'"));
                document.saveWithoutBackup();
                document.unlockIfNecessary();
                document.cleanupWorkingCopy();
                ch.docuteam.tools.file.FileUtil.copyToFolderOverwriting((String)document.getFilePath(), (String)feedbackPath);
                ch.docuteam.tools.file.FileUtil.delete((String)document.getOriginalSIPFolder());
            }
            catch (Exception ex) {
                Logger.error((java.lang.Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, IngestStatus> _getAllStatus(ch.docuteam.darc.mets.Document document) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, MetadataElementIsNotAllowedException, MetadataElementIsNotDefinedException, SQLException {
        String sipName = this.getSIPNameWithoutExtension(document);
        String workspace = document.getStructureMap().getRoot().getDynamicMetadataValueForName("refCodeAdmin");
        Logger.debug((java.lang.Object)("Getting all status entries for SIP: '" + sipName + "'"));
        try {
            DB.initialize(this.dbHost, this.dbPort, this.dbService, this.dbName, this.dbUserName, this.dbUserPassword, this.executionId);
            Map<String, IngestStatus> map = DB.getAllStatus(workspace, sipName);
            return map;
        }
        finally {
            DB.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _setAllStatus(ch.docuteam.darc.mets.Document document, IngestStatus status) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, MetadataElementIsNotDefinedException, MetadataElementIsNotAllowedException, SQLException {
        String sipName = this.getSIPNameWithoutExtension(document);
        String workspace = document.getStructureMap().getRoot().getDynamicMetadataValueForName("refCodeAdmin");
        Logger.debug((java.lang.Object)("Setting all status entries for SIP: '" + sipName + "' to: '" + status + "'"));
        try {
            DB.initialize(this.dbHost, this.dbPort, this.dbService, this.dbName, this.dbUserName, this.dbUserPassword, this.executionId);
            DB._setAllStatus(status, workspace, sipName);
        }
        finally {
            DB.close();
        }
    }

    private void checkPropertiesForSubmit() {
        if (this.ingestSubmitDir == null) {
            throw new NullPointerException("Missing property: 'AIPCreator.ingestSubmitDir." + OSSuffix + "'");
        }
    }

    private void checkPropertiesForStorage() {
        if (this.aipFolderPath == null) {
            throw new NullPointerException("Missing property: 'AIPCreator.aipFolderPath'");
        }
        if (this.executionId == null) {
            throw new NullPointerException("Missing property: 'AIPCreator.executionId'");
        }
        if (this.deeplinkPatternCollection == null) {
            throw new NullPointerException("Missing property: 'AIPCreator.deeplinkPatternCollection'");
        }
        if (this.deeplinkPatternIE == null) {
            throw new NullPointerException("Missing property: 'AIPCreator.deeplinkPatternIE'");
        }
        if (IsWithoutDB) {
            return;
        }
        if (this.dbHost == null) {
            throw new NullPointerException("Missing property: 'AIPCreator.dbHost'");
        }
        if (this.dbPort == null) {
            throw new NullPointerException("Missing property: 'AIPCreator.dbPort'");
        }
        if (this.dbService == null) {
            throw new NullPointerException("Missing property: 'AIPCreator.dbService'");
        }
        if (this.dbUserName == null) {
            throw new NullPointerException("Missing property: 'AIPCreator.dbUserName'");
        }
        if (this.dbUserPassword == null) {
            throw new NullPointerException("Missing property: 'AIPCreator.dbUserPassword'");
        }
    }

    private List<String> submitCheckRecursive(NodeAbstract node) {
        Vector<String> rejectMessages = new Vector<String>();
        for (NodeAbstract n : node.getWithDescendants()) {
            if (!n.getSubmitStatus().equals((java.lang.Object)NodeAbstract.SubmitStatus.SubmitRequested)) continue;
            for (String message : this.submitCheck(n)) {
                rejectMessages.add(message);
            }
        }
        return rejectMessages;
    }

    private List<String> submitCheck(NodeAbstract node) {
        NodeAbstract.SubmitStatus submitStatus;
        Vector<String> rejectMessages = new Vector<String>();
        String pathString = node.getPathString();
        Logger.info((java.lang.Object)("Performing submit-check for node: '" + pathString + "' (" + node.getAdmId() + ")"));
        if (!node.fileExists()) {
            rejectMessages.add("MessageSubmitNodeFileDoesNotExist '" + pathString + "'");
        }
        if (!node.canRead()) {
            rejectMessages.add("MessageSubmitNodeFileIsNotReadable '" + pathString + "'");
        }
        if (!node.canWrite()) {
            rejectMessages.add("MessageSubmitNodeFileIsNotWritable '" + pathString + "'");
        }
        if ((submitStatus = node.getSubmitStatus()) == NodeAbstract.SubmitStatus.SubmitRequestPending) {
            rejectMessages.add("MessageSubmitNodeIsAlreadySubmitPending '" + pathString + "'");
        }
        if (node.hasDynamicMetadataElementInstancesWhichAreMandatoryButNotSet()) {
            rejectMessages.add("MessageSubmitNodeMandatoryMetadataNotSet '" + pathString + "'");
        }
        Boolean allChildrenLevelsAreUndef = null;
        for (int i = 0; i < node.getChildCount(); ++i) {
            boolean childLevelIsUndef = ((NodeAbstract)node.getChildAt(i)).getLevel().isUndefined();
            if (allChildrenLevelsAreUndef == null) {
                allChildrenLevelsAreUndef = childLevelIsUndef;
                continue;
            }
            if (allChildrenLevelsAreUndef == childLevelIsUndef) continue;
            rejectMessages.add("MessageSubmitNodeHasHeterogenousChildren '" + pathString + "'");
            break;
        }
        if (rejectMessages.isEmpty()) {
            Logger.info((java.lang.Object)"Node is OK");
        } else {
            Logger.info((java.lang.Object)("Can't submit node because: " + rejectMessages));
        }
        return rejectMessages;
    }

    private List<String> generateAIP(NodeAbstract node, String workspace, String sipName, String submitTimestamp) throws SQLException {
        List<String> errorMessages = new Vector<String>();
        switch (this.getAIPType(node)) {
            case IE: {
                errorMessages = this.generateIE(node, workspace, sipName, submitTimestamp);
                break;
            }
            case Collection: {
                errorMessages = this.generateCollection((NodeFolder)node, workspace, sipName, submitTimestamp);
                for (int i = 0; i < node.getChildCount(); ++i) {
                    errorMessages.addAll(this.generateAIP((NodeAbstract)node.getChildAt(i), workspace, sipName, submitTimestamp));
                }
                break;
            }
            case None: {
                Logger.info((java.lang.Object)("Skipping in '" + sipName + "' node: '" + node.getPathString() + "': Neither IE nor Collection"));
                break;
            }
            default: {
                Logger.error((java.lang.Object)"This should't ever happen!");
            }
        }
        return errorMessages;
    }

    private AIPType getAIPType(NodeAbstract node) {
        if (node.isFile()) {
            return node.getLevel().isUndefined() ? AIPType.None : AIPType.IE;
        }
        if (node.getChildCount() == 0) {
            return AIPType.None;
        }
        if (node.getLevel().isUndefined()) {
            return AIPType.Collection;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (((NodeAbstract)node.getChildAt(i)).getLevel().isUndefined()) continue;
            return AIPType.Collection;
        }
        return AIPType.IE;
    }

    private List<String> generateCollection(NodeFolder node, String workspace, String sipName, String submitTimestamp) throws SQLException {
        Vector<String> errorMessages = new Vector<String>();
        if (node.getSubmitStatus() != NodeAbstract.SubmitStatus.SubmitRequestPending) {
            Logger.info((java.lang.Object)("Skipping in '" + sipName + "' node: '" + node.getPathString() + "': Submit status is not '" + NodeAbstract.SubmitStatus.SubmitRequestPending + "'"));
            return errorMessages;
        }
        String aipPath = this.aipFolderPath + File.separator + workspace + File.separator + sipName;
        String filenameForNode = ch.docuteam.tools.file.FileUtil.asStrictSafeFileName((String)node.getLabel());
        String filenameForNodeLimited = filenameForNode.substring(0, Math.min(filenameForNode.length(), 198));
        String aipFilePath = aipPath + "/" + filenameForNodeLimited + node.getAdmId() + ".xml";
        Logger.info((java.lang.Object)("Creating Collection in '" + aipPath + "' node: '" + node.getPathString() + "'"));
        DB.logCollectionCreationStart((NodeAbstract)node, aipFilePath, workspace, sipName, submitTimestamp);
        try {
            Document document = DocumentHelper.createDocument();
            Element collectionElement = document.addElement("Collection");
            collectionElement.addElement("url").addText(workspace + "/" + node.getPathString());
            collectionElement.addElement("externalSystem").addText(workspace);
            collectionElement.addElement("name").addText(node.getLabel());
            if (node.getPID() != null) {
                collectionElement.addElement("externalId").addText((String)node.getPID().get(0));
            }
            this.addCollectionMetadataElementToCollectionElement(collectionElement, "dc:title", node.getUnitTitle().substring(0, Math.min(node.getUnitTitle().length(), 255)));
            if (node.isRoot().booleanValue()) {
                this.addCollectionMetadataElementToCollectionElement(collectionElement, "dcterms:isPartOf", workspace);
            } else {
                this.addCollectionMetadataElementToCollectionElement(collectionElement, "dcterms:isPartOf", workspace + "/" + ((NodeAbstract)node.getParent()).getPathString());
            }
            for (String key : MetadataNamesMapToDC.keySet()) {
                this.addDynamicMetadataValuesToCollectionElement((NodeAbstract)node, workspace, key, collectionElement, MetadataNamesMapToDC.get(key));
            }
            try (OutputStreamWriter oswriter = new OutputStreamWriter((OutputStream)new FileOutputStream(aipFilePath), StandardCharsets.UTF_8);){
                OutputFormat.createPrettyPrint();
                OutputFormat outformat = new OutputFormat("  ", false, "UTF-8");
                XMLWriter writer = new XMLWriter((Writer)oswriter, outformat);
                writer.write(document);
            }
        }
        catch (Exception ex) {
            Logger.error((java.lang.Object)ex.getMessage(), (Throwable)ex);
            errorMessages.add("MessageSubmitNodeExceptionCreatingCollection '" + aipPath + "': " + ex.getMessage());
        }
        DB.logCollectionCreationEnd((NodeAbstract)node, errorMessages.isEmpty() ? IngestStatus.FEEDER_FINISHED : IngestStatus.FEEDER_ERROR, workspace, sipName);
        return errorMessages;
    }

    private void addDynamicMetadataValuesToCollectionElement(NodeAbstract node, String workspace, String mdName, Element collectionElement, String elementName) {
        Logger.debug((java.lang.Object)("Mapping metadata: '" + mdName + "'"));
        try {
            for (String s : node.getAllDynamicMetadataValuesForName(mdName)) {
                if (s == null || s.isEmpty()) continue;
                String value = DB.getRosettaCodeIfExists(workspace, mdName, s);
                this.addCollectionMetadataElementToCollectionElement(collectionElement, elementName, value);
                Logger.debug((java.lang.Object)("Mapping: '" + mdName + "' to: '" + elementName + "' value: '" + value + "'"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addCollectionMetadataElementToCollectionElement(Element collectionElement, String key, String value) {
        Element collectionMetaDataElement = collectionElement.addElement("CollectionMetaData");
        collectionMetaDataElement.addElement("key").addText(key);
        collectionMetaDataElement.addElement("value").addText(value);
    }

    private List<String> generateIE(NodeAbstract node, String workspace, String sipName, String submitTimestamp) throws SQLException {
        Vector<String> errorMessages = new Vector<String>();
        if (node.getSubmitStatus() != NodeAbstract.SubmitStatus.SubmitRequestPending) {
            Logger.info((java.lang.Object)("Skipping in '" + sipName + "' node: '" + node.getPathString() + "': Submit status is not 'SubmitStatusPending'"));
            return errorMessages;
        }
        String aipPath = this.aipFolderPath + File.separator + workspace + File.separator + sipName;
        String aipRootPath = aipPath + "/" + ch.docuteam.tools.file.FileUtil.asStrictSafeFileName((String)node.getLabel()) + node.getAdmId();
        String ieFilePath = aipRootPath + "/content/ie.xml";
        String dcFilePath = aipRootPath + "/content/dc.xml";
        String streamsFilePath = aipRootPath + "/content/streams";
        Logger.info((java.lang.Object)("Creating DC in '" + aipPath + "' node: '" + node.getLabel() + "'"));
        DB.logIECreationStart(node, aipRootPath, workspace, sipName, submitTimestamp);
        try {
            DublinCore dc = DublinCoreFactory.getInstance().createDocument();
            dc.addElement("dc:title", node.getUnitTitle().substring(0, Math.min(node.getUnitTitle().length(), 200)));
            new File(dcFilePath).getParentFile().mkdirs();
            dc.save(dcFilePath);
            Logger.info((java.lang.Object)("Creating IE in '" + aipPath + "' node: '" + node.getLabel() + "'"));
            IEParser ie = IEParserFactory.create();
            Logger.debug((java.lang.Object)("Adding DC to IE in '" + aipPath + "' node: '" + node.getLabel() + "'"));
            dc = ie.getDublinCoreParser();
            dc.addElement("dc:title", node.getUnitTitle().substring(0, Math.min(node.getUnitTitle().length(), 1000)));
            dc.addElement("dcterms:isPartOf", workspace + "/" + ((NodeAbstract)node.getParent()).getPathString());
            for (String key : MetadataNamesMapToDC.keySet()) {
                this.addDynamicMetadataValuesToDCElement(node, workspace, key, dc, MetadataNamesMapToDC.get(key));
            }
            ie.setIEDublinCore(dc);
            Logger.debug((java.lang.Object)("Adding DNX to IE in '" + aipPath + "' node: '" + node.getLabel() + "'"));
            ie.setIeDnx(new DnxDocumentHelper(DnxDocumentFactory.getInstance().createDnxDocument()).getDocument());
            try {
                String retentionPolicy = DB.getRosettaCodeIfExists(workspace, "retentionPolicy", node.getDynamicMetadataValueForName("retentionPolicy"));
                ie.getAmdSecArray()[0].getRightsMDArray(0).getMdWrap().getXmlData().set(XmlObject.Factory.parse((String)("<dnx xmlns='http://www.exlibrisgroup.com/dps/dnx'><section id='accessRightsPolicy'><record><key id='policyId'>" + retentionPolicy + "</key></record></section></dnx>")));
                Logger.debug((java.lang.Object)("Adding retentionPolicy value: '" + retentionPolicy + "'"));
            }
            catch (MetadataElementIsNotDefinedException retentionPolicy) {
            }
            catch (MetadataElementIsNotAllowedException retentionPolicy) {
                // empty catch block
            }
            try {
                String accessRestrictionPeriod = DB.getRosettaCodeIfExists(workspace, "accessRestrictionPeriod", node.getDynamicMetadataValueForName("accessRestrictionPeriod"));
                if (accessRestrictionPeriod != null) {
                    ie.getAmdSecArray()[0].getRightsMDArray(0).getMdWrap().getXmlData().set(XmlObject.Factory.parse((String)("<dnx xmlns='http://www.exlibrisgroup.com/dps/dnx'><section id='accessRightsPolicy'><record><key id='policyId'>" + accessRestrictionPeriod + "</key></record></section></dnx>")));
                    Logger.debug((java.lang.Object)("Adding accessRestrictionPeriod value: '" + accessRestrictionPeriod + "'"));
                }
            }
            catch (MetadataElementIsNotDefinedException ex) {
                Logger.warn((java.lang.Object)"Trying to handle the metadata element 'accessRestrictionPeriod', but this element is not defined");
            }
            catch (MetadataElementIsNotAllowedException ex) {
                Logger.warn((java.lang.Object)"Trying to handle the metadata element 'accessRestrictionPeriod', but this element is not allowed for this level");
            }
            try {
                String retentionPeriod = DB.getRosettaCodeIfExists(workspace, "retentionPeriod", node.getDynamicMetadataValueForName("retentionPeriod"));
                ie.getAmdSecArray()[0].getTechMDArray(0).getMdWrap().getXmlData().set(XmlObject.Factory.parse((String)("<dnx xmlns='http://www.exlibrisgroup.com/dps/dnx'><section id='retentionPolicy'><record><key id='policyId'>" + retentionPeriod + "</key></record></section></dnx>")));
                Logger.debug((java.lang.Object)("Adding retentionPeriod value: '" + retentionPeriod + "'"));
            }
            catch (MetadataElementIsNotDefinedException ex) {
                Logger.warn((java.lang.Object)"Trying to handle the metadata element 'retentionPeriod', but this element is not defined");
            }
            catch (MetadataElementIsNotAllowedException ex) {
                Logger.warn((java.lang.Object)"Trying to handle the metadata element 'retentionPeriod', but this element is not allowed for this level");
            }
            String sectionCharacteristics = null;
            try {
                String characteristics = node.getDynamicMetadataValueForName("characteristics");
                if (characteristics != null && !characteristics.isEmpty()) {
                    Logger.debug((java.lang.Object)("Adding characteristics value: '" + characteristics + "'"));
                    sectionCharacteristics = "<section id='generalIECharacteristics'><record><key id='status'>ACTIVE</key><key id='IEEntityType'>" + characteristics + "</key></record></section>";
                }
            }
            catch (MetadataElementIsNotDefinedException ex) {
                Logger.warn((java.lang.Object)"Trying to handle the metadata element 'characteristics', but this element is not defined");
            }
            catch (MetadataElementIsNotAllowedException ex) {
                Logger.warn((java.lang.Object)"Trying to handle the metadata element 'characteristics', but this element is not allowed for this level");
            }
            String sectionCharacteristicsNote = null;
            try {
                String characteristicsNote = node.getDynamicMetadataValueForName("characteristicsNote");
                if (characteristicsNote != null && !characteristicsNote.isEmpty()) {
                    Logger.debug((java.lang.Object)("Adding characteristicsNote value: '" + characteristicsNote + "'"));
                    sectionCharacteristicsNote = "<section id='webHarvesting'><record><key id='primarySeedURL'>" + characteristicsNote + "</key></record></section>";
                }
            }
            catch (MetadataElementIsNotDefinedException ex) {
                Logger.warn((java.lang.Object)"Trying to handle the metadata element 'characteristics', but this element is not defined");
            }
            catch (MetadataElementIsNotAllowedException ex) {
                Logger.warn((java.lang.Object)"Trying to handle the metadata element 'characteristics', but this element is not allowed for this level");
            }
            if (sectionCharacteristics != null || sectionCharacteristicsNote != null) {
                java.lang.Object xmlObjectString = "<dnx xmlns='http://www.exlibrisgroup.com/dps/dnx'>";
                if (sectionCharacteristics != null) {
                    xmlObjectString = (String)xmlObjectString + sectionCharacteristics;
                }
                if (sectionCharacteristicsNote != null) {
                    xmlObjectString = (String)xmlObjectString + sectionCharacteristicsNote;
                }
                xmlObjectString = (String)xmlObjectString + "</dnx>";
                ie.getAmdSecArray()[0].getTechMDArray(0).getMdWrap().getXmlData().set(XmlObject.Factory.parse((String)xmlObjectString));
            }
            ie.setIeSourceMd(MdSecType.MdWrap.MDTYPE.EAD, XmlObject.Factory.parse((String)this.getEADElementPath(node).asXML()));
            if (node.isFile()) {
                Logger.debug((java.lang.Object)("Adding fileGrp to IE in '" + aipPath + "' node: '" + node.getLabel() + "'"));
                MetsType.FileSec.FileGrp fGrp = ie.addNewFileGrp(Enum.UsageType.VIEW, "PRESERVATION_MASTER");
                fGrp.setUSE(Enum.UsageType.VIEW.toString());
                Logger.debug((java.lang.Object)("Adding DNX to fileGrp in '" + aipPath + "' node: '" + node.getLabel() + "'"));
                DnxDocument fileGrpDnx = ie.getFileGrpDnx(fGrp.getID());
                this.fillFileGrpDnx(fileGrpDnx, node, "PRESERVATION_MASTER");
                ie.setFileDnx(fileGrpDnx, fGrp.getID());
                Logger.debug((java.lang.Object)("Adding file to IE in '" + aipPath + "' node: '" + node.getLabel() + "'"));
                FileType fileType = ie.addNewFile(fGrp, node.getMimeType(), node.getLabel(), null);
                Logger.debug((java.lang.Object)("Adding DNX to file in '" + aipPath + "' node: '" + node.getLabel() + "'"));
                DnxDocument fileDnx = ie.getFileDnx(fileType.getID());
                this.fillFileDnx(fileDnx, node, workspace);
                ie.setFileDnx(fileDnx, fileType.getID());
                ch.docuteam.tools.file.FileUtil.copyToFolderOverwriting((String)node.getAbsolutePathString(), (String)streamsFilePath);
            } else if (this.isFolderContainingMigratedFiles(node)) {
                Logger.debug((java.lang.Object)"Is migrated IE, will create specific fileGrp for Representations");
                Logger.debug((java.lang.Object)("Adding fileGrp to IE in '" + aipPath + "' node: '" + node.getLabel() + "'"));
                MetsType.FileSec.FileGrp fGrpMaster = ie.addNewFileGrp(Enum.UsageType.VIEW, "ORIGINAL_MASTER");
                fGrpMaster.setUSE(Enum.UsageType.VIEW.toString());
                Logger.debug((java.lang.Object)("Adding DNX to fileGrp in '" + aipPath + "' node: '" + node.getLabel() + "'"));
                DnxDocument fileGrpMasterDnx = ie.getFileGrpDnx(fGrpMaster.getID());
                this.fillFileGrpDnx(fileGrpMasterDnx, (NodeAbstract)((NodeFile)node.getChildAt(0)), "ORIGINAL_MASTER");
                ie.setFileDnx(fileGrpMasterDnx, fGrpMaster.getID());
                Logger.debug((java.lang.Object)("Adding file to IE in '" + aipPath + "' node: '" + ((NodeFile)node.getChildAt(0)).getLabel() + "'"));
                FileType fileTypeMaster = ie.addNewFile(fGrpMaster, ((NodeFile)node.getChildAt(0)).getMimeType(), ((NodeFile)node.getChildAt(0)).getLabel(), null);
                Logger.debug((java.lang.Object)("Adding DNX to file in '" + aipPath + "' node: '" + ((NodeFile)node.getChildAt(0)).getLabel() + "'"));
                DnxDocument fileDnxMaster = ie.getFileDnx(fileTypeMaster.getID());
                this.fillFileDnx(fileDnxMaster, (NodeAbstract)((NodeFile)node.getChildAt(0)), workspace);
                ie.setFileDnx(fileDnxMaster, fileTypeMaster.getID());
                ch.docuteam.tools.file.FileUtil.copyToFolderOverwriting((String)((NodeFile)node.getChildAt(0)).getAbsolutePathString(), (String)streamsFilePath);
                Logger.debug((java.lang.Object)("Adding fileGrp to IE in '" + aipPath + "' node: '" + node.getLabel() + "'"));
                MetsType.FileSec.FileGrp fGrpDerived = ie.addNewFileGrp(Enum.UsageType.VIEW, "PRESERVATION_MASTER");
                fGrpDerived.setUSE(Enum.UsageType.VIEW.toString());
                Logger.debug((java.lang.Object)("Adding DNX to fileGrp in '" + aipPath + "' node: '" + node.getLabel() + "'"));
                DnxDocument fileGrpDerivedDnx = ie.getFileGrpDnx(fGrpDerived.getID());
                this.fillFileGrpDnx(fileGrpDerivedDnx, (NodeAbstract)node.getChildAt(1), "PRESERVATION_MASTER");
                ie.setFileDnx(fileGrpDerivedDnx, fGrpDerived.getID());
                Logger.debug((java.lang.Object)("Adding file to IE in '" + aipPath + "' node: '" + ((NodeFile)node.getChildAt(1)).getLabel() + "'"));
                FileType fileTypeDerived = ie.addNewFile(fGrpDerived, ((NodeFile)node.getChildAt(1)).getMimeType(), ((NodeFile)node.getChildAt(1)).getLabel(), null);
                Logger.debug((java.lang.Object)("Adding DNX to file in '" + aipPath + "' node: '" + ((NodeFile)node.getChildAt(1)).getLabel() + "'"));
                DnxDocument fileDnxDerived = ie.getFileDnx(fileTypeDerived.getID());
                this.fillFileDnx(fileDnxDerived, (NodeAbstract)((NodeFile)node.getChildAt(1)), workspace);
                ie.setFileDnx(fileDnxDerived, fileTypeDerived.getID());
                ch.docuteam.tools.file.FileUtil.copyToFolderOverwriting((String)((NodeFile)node.getChildAt(1)).getAbsolutePathString(), (String)streamsFilePath);
            } else {
                Logger.debug((java.lang.Object)"Creating a complex IE");
                int migrationCount = 0;
                for (MutableTreeTableNode child : ((NodeFolder)node).getChildren()) {
                    if (!this.isFolderContainingMigratedFiles((NodeAbstract)child)) continue;
                    ++migrationCount;
                }
                if (migrationCount > 0) {
                    Logger.debug((java.lang.Object)"Is migrated IE, will create specific fileGrp for Representations");
                    Logger.debug((java.lang.Object)("Adding fileGrp to IE in '" + aipPath + "' node: '" + node.getLabel() + "'"));
                    MetsType.FileSec.FileGrp fGrpMaster = ie.addNewFileGrp(Enum.UsageType.VIEW, "ORIGINAL_MASTER");
                    fGrpMaster.setUSE(Enum.UsageType.VIEW.toString());
                    Logger.debug((java.lang.Object)("Adding DNX to fileGrp in '" + aipPath + "' node: '" + node.getLabel() + "'"));
                    DnxDocument fileGrpMasterDnx = ie.getFileGrpDnx(fGrpMaster.getID());
                    this.fillFileGrpDnx(fileGrpMasterDnx, node, "ORIGINAL_MASTER");
                    ie.setFileDnx(fileGrpMasterDnx, fGrpMaster.getID());
                    for (NodeFile subNode : ((NodeFolder)node).getDescendantFiles()) {
                        if (subNode.getMigrationDerivedNode() == null) continue;
                        StringBuilder filePathRelativeToIENodeStringBuilder = new StringBuilder(200);
                        NodeFile parent = subNode;
                        do {
                            filePathRelativeToIENodeStringBuilder.insert(0, "_" + parent.getLabel());
                        } while ((parent = (NodeAbstract)parent.getParent()) != node);
                        String filePathRelativeToIENode = filePathRelativeToIENodeStringBuilder.toString().substring(1);
                        Logger.debug((java.lang.Object)("Adding file to complex IE in '" + aipPath + "' node: '" + filePathRelativeToIENode + "'"));
                        FileType fileType = ie.addNewFile(fGrpMaster, subNode.getMimeType(), filePathRelativeToIENode, null);
                        DnxDocument fileDnx = ie.getFileDnx(fileType.getID());
                        this.fillFileDnx(fileDnx, (NodeAbstract)subNode, workspace);
                        ie.setFileDnx(fileDnx, fileType.getID());
                        ch.docuteam.tools.file.FileUtil.copyToOverwriting((String)subNode.getAbsolutePathString(), (String)(streamsFilePath + "/" + filePathRelativeToIENode));
                    }
                    Logger.debug((java.lang.Object)("Adding fileGrp to IE in '" + aipPath + "' node: '" + node.getLabel() + "'"));
                    MetsType.FileSec.FileGrp fGrpDerived = ie.addNewFileGrp(Enum.UsageType.VIEW, "PRESERVATION_MASTER");
                    fGrpDerived.setUSE(Enum.UsageType.VIEW.toString());
                    Logger.debug((java.lang.Object)("Adding DNX to fileGrp in '" + aipPath + "' node: '" + node.getLabel() + "'"));
                    DnxDocument fileGrpDerivedDnx = ie.getFileGrpDnx(fGrpDerived.getID());
                    this.fillFileGrpDnx(fileGrpDerivedDnx, node, "PRESERVATION_MASTER");
                    ie.setFileDnx(fileGrpDerivedDnx, fGrpDerived.getID());
                    for (NodeFile subNode : ((NodeFolder)node).getDescendantFiles()) {
                        if (subNode.getMigrationSourceNode() == null) continue;
                        StringBuilder filePathRelativeToIENodeStringBuilder = new StringBuilder(200);
                        NodeFile parent = subNode;
                        do {
                            filePathRelativeToIENodeStringBuilder.insert(0, "_" + parent.getLabel());
                        } while ((parent = (NodeAbstract)parent.getParent()) != node);
                        String filePathRelativeToIENode = filePathRelativeToIENodeStringBuilder.toString().substring(1);
                        Logger.debug((java.lang.Object)("Adding file to complex IE in '" + aipPath + "' node: '" + filePathRelativeToIENode + "'"));
                        FileType fileType = ie.addNewFile(fGrpDerived, subNode.getMimeType(), filePathRelativeToIENode, null);
                        DnxDocument fileDnx = ie.getFileDnx(fileType.getID());
                        this.fillFileDnx(fileDnx, (NodeAbstract)subNode, workspace);
                        ie.setFileDnx(fileDnx, fileType.getID());
                        ch.docuteam.tools.file.FileUtil.copyToOverwriting((String)subNode.getAbsolutePathString(), (String)(streamsFilePath + "/" + filePathRelativeToIENode));
                    }
                } else {
                    Logger.debug((java.lang.Object)("Adding fileGrp to IE in '" + aipPath + "' node: '" + node.getLabel() + "'"));
                    MetsType.FileSec.FileGrp fGrp = ie.addNewFileGrp(Enum.UsageType.VIEW, "PRESERVATION_MASTER");
                    fGrp.setUSE(Enum.UsageType.VIEW.toString());
                    Logger.debug((java.lang.Object)("Adding DNX to fileGrp in '" + aipPath + "' node: '" + node.getLabel() + "'"));
                    DnxDocument fileGrpDnx = ie.getFileGrpDnx(fGrp.getID());
                    this.fillFileGrpDnx(fileGrpDnx, node, "PRESERVATION_MASTER");
                    ie.setFileDnx(fileGrpDnx, fGrp.getID());
                    for (NodeFile subNode : ((NodeFolder)node).getDescendantFiles()) {
                        StringBuilder filePathRelativeToIENodeStringBuilder = new StringBuilder(200);
                        NodeFile parent = subNode;
                        do {
                            filePathRelativeToIENodeStringBuilder.insert(0, "_" + parent.getLabel());
                        } while ((parent = (NodeAbstract)parent.getParent()) != node);
                        String filePathRelativeToIENode = filePathRelativeToIENodeStringBuilder.toString().substring(1);
                        Logger.debug((java.lang.Object)("Adding file to complex IE in '" + aipPath + "' node: '" + filePathRelativeToIENode + "'"));
                        FileType fileType = ie.addNewFile(fGrp, subNode.getMimeType(), filePathRelativeToIENode, null);
                        DnxDocument fileDnx = ie.getFileDnx(fileType.getID());
                        this.fillFileDnx(fileDnx, (NodeAbstract)subNode, workspace);
                        ie.setFileDnx(fileDnx, fileType.getID());
                        ch.docuteam.tools.file.FileUtil.copyToOverwriting((String)subNode.getAbsolutePathString(), (String)(streamsFilePath + "/" + filePathRelativeToIENode));
                    }
                }
            }
            Logger.debug((java.lang.Object)("Generating structMap in '" + aipPath + "' node: '" + node.getLabel() + "'"));
            ie.generateStructMap(null, null, "Table of Contents");
            Logger.debug((java.lang.Object)("IE source:\n" + ie.toXML()));
            Logger.debug((java.lang.Object)("Saving '" + aipPath + "' node: '" + node.getLabel() + "'"));
            FileUtil.writeFile((File)new File(ieFilePath), (String)ie.toXML());
        }
        catch (Exception ex) {
            errorMessages.add("MessageSubmitNodeExceptionCreatingIE '" + aipPath + "': " + ex.getMessage());
        }
        DB.logIECreationEnd(node, errorMessages.isEmpty() ? IngestStatus.FEEDER_FINISHED : IngestStatus.FEEDER_ERROR, workspace, sipName);
        return errorMessages;
    }

    private void addDynamicMetadataValuesToDCElement(NodeAbstract node, String workspace, String mdName, DublinCore dc, String elementName) {
        Logger.debug((java.lang.Object)("Mapping metadata: '" + mdName + "'"));
        try {
            for (String s : node.getAllDynamicMetadataValuesForName(mdName)) {
                if (s == null || s.isEmpty()) continue;
                String value = DB.getRosettaCodeIfExists(workspace, mdName, s);
                dc.addElement(elementName, value);
                Logger.debug((java.lang.Object)("Mapping: '" + mdName + "' to: '" + elementName + "' value: '" + value + "'"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void fillFileGrpDnx(DnxDocument dnx, NodeAbstract node, String preservationType) {
        DnxDocumentHelper fileGrpDocumentHelper = new DnxDocumentHelper(dnx);
        fileGrpDocumentHelper.getGeneralRepCharacteristics().setPreservationType(preservationType);
        fileGrpDocumentHelper.getGeneralRepCharacteristics().setUsageType(Enum.UsageType.VIEW.toString());
        fileGrpDocumentHelper.getGeneralRepCharacteristics().setLabel(node.getLabel());
    }

    private void fillFileDnx(DnxDocument dnx, NodeAbstract node, String workspace) {
        DnxDocumentHelper fileDocumentHelper = new DnxDocumentHelper(dnx);
        fileDocumentHelper.getGeneralFileCharacteristics().setLabel(node.getUnitTitle());
        fileDocumentHelper.getGeneralFileCharacteristics().setFileOriginalPath(workspace + "/" + node.getPathString());
        fileDocumentHelper.getGeneralFileCharacteristics().setFileOriginalName(node.getLabel());
        DnxDocumentHelper.FileFixity[] fileFixityArray = new DnxDocumentHelper.FileFixity[1];
        DnxDocumentHelper dnxDocumentHelper = fileDocumentHelper;
        Objects.requireNonNull(dnxDocumentHelper);
        fileFixityArray[0] = new DnxDocumentHelper.FileFixity(dnxDocumentHelper, null, null, node.getChecksumType(), node.getChecksum());
        fileDocumentHelper.setFileFixitys(Arrays.asList(fileFixityArray));
    }

    private Element getEADElementPath(NodeAbstract node) {
        TreePath treePath = node.getTreePath();
        Element rootElement = (Element)((NodeAbstract)treePath.getPathComponent(0)).getMyDMDSectionWithEAD().getEADElement().clone();
        Element lastCElement = (Element)rootElement.selectSingleNode("EAD:archdesc/EAD:dsc/EAD:c");
        for (int i = 1; i < treePath.getPathCount(); ++i) {
            NodeAbstract child = (NodeAbstract)treePath.getPathComponent(i);
            Element childCElement = (Element)child.getMyDMDSectionWithEAD().getEADElement().selectSingleNode("EAD:archdesc/EAD:dsc/EAD:c").clone();
            lastCElement.add(childCElement);
            lastCElement = childCElement;
        }
        for (java.lang.Object submitStatusXMLNode : rootElement.selectNodes(".//EAD:name[@role='submitStatus']")) {
            ((Node)submitStatusXMLNode).setText(NodeAbstract.SubmitStatus.Submitted.toString());
        }
        return rootElement;
    }

    private boolean isFolderContainingMigratedFiles(NodeAbstract node) {
        if (node.getChildCount() == 2 && ((NodeAbstract)node.getChildAt(0)).isFile() && ((NodeAbstract)node.getChildAt(1)).isFile()) {
            Object sourceObject = ((NodeAbstract)node.getChildAt(0)).getMyDigiprov().getLastObject();
            Object derivedObject = ((NodeAbstract)node.getChildAt(1)).getMyDigiprov().getLastObject();
            if (sourceObject.getRelatedObjectIdValue().equals(derivedObject.getId()) && sourceObject.getRelationshipType().equals("source") && derivedObject.getRelationshipType().equals("derivation")) {
                return true;
            }
        }
        return false;
    }

    private void _prepareTestRun(String submitPath) throws FileUtilExceptionListException {
        ch.docuteam.tools.file.FileUtil.delete((String)submitPath);
    }

    static {
        MetadataNamesMapToDC.put("PID", "dc:identifier");
        MetadataNamesMapToDC.put("origination", "dc:creator");
        MetadataNamesMapToDC.put("author", "dc:creator");
        MetadataNamesMapToDC.put("creationPeriod", "dcterms:temporal");
        MetadataNamesMapToDC.put("creationPeriodNotes", "dc:description");
        MetadataNamesMapToDC.put("scopeContent", "dc:subject");
        MetadataNamesMapToDC.put("language", "dc:language");
        MetadataNamesMapToDC.put("languageNotes", "dc:description");
        MetadataNamesMapToDC.put("accessRestriction", "dc:rights");
        MetadataNamesMapToDC.put("accessRestrictionPeriodBaseYear", "dc:date");
        MetadataNamesMapToDC.put("accessRestrictionExplanation", "dc:description");
        MetadataNamesMapToDC.put("retentionPeriodBaseYear", "dc:available");
        MetadataNamesMapToDC.put("archivalHistory", "dc:description");
        MetadataNamesMapToDC.put("objectType", "dc:type");
        MetadataNamesMapToDC.put("extent", "dcterms:extent");
        MetadataNamesMapToDC.put("refCodeOld", "dc:identifier");
        MetadataNamesMapToDC.put("refCode", "dc:identifier");
        MetadataNamesMapToDC.put("reproductions", "dcterms:hasVersion");
        MetadataNamesMapToDC.put("comment", "dc:description");
        MetadataNamesMapToDC.put("institution", "dc:publisher");
        MetadataNamesMapToDC.put("arrangement", "dc:format");
        MetadataNamesMapToDC.put("accessNr", "dc:source");
        MetadataNamesMapToDC.put("appraisalAndDestruction", "dc:description");
        MetadataNamesMapToDC.put("bibliography", "dcterms:isReferencedBy");
        MetadataNamesMapToDC.put("unitTitleAdditional", "dcterms:alternative");
        MetadataNamesMapToDC.put("material", "dcterms:medium");
        MetadataNamesMapToDC.put("conditionsOfReproductions", "dc:description");
        MetadataNamesMapToDC.put("relatedMaterial", "dcterms:references");
        MetadataNamesMapToDC.put("descriptionLevel", "dc:description");
        MetadataNamesMapToDC.put("descriptionLevelNotes", "dc:description");
        MetadataNamesMapToDC.put("descriptionRules", "dc:description");
        MetadataNamesMapToDC.put("revisions", "dcterms:hasVersion");
        MetadataNamesMapToDC.put("responsible", "dcterms:rightsHolder");
        MetadataNamesMapToDC.put("involved", "dc:contributor");
        MetadataNamesMapToDC.put("staff", "dc:contributor");
        MetadataNamesMapToDC.put("projectName", "dcterms:alternative");
        MetadataNamesMapToDC.put("projectTitle", "dcterms:alternative");
        MetadataNamesMapToDC.put("project", "dc:type");
        MetadataNamesMapToDC.put("projectAbbreviation", "dc:type");
        MetadataNamesMapToDC.put("location", "dcterms:spatial");
        MetadataNamesMapToDC.put("journal", "dcterms:bibliographicCitation");
        MetadataNamesMapToDC.put("university", "dc:contributor");
        MetadataNamesMapToDC.put("institute", "dc:contributor");
        MetadataNamesMapToDC.put("compartment", "dc:subject");
        MetadataNamesMapToDC.put("method", "dc:coverage");
        MetadataNamesMapToDC.put("keyword", "dc:subject");
        MetadataNamesMapToDC.put("fundingSource", "dcterms:mediator");
        MetadataNamesMapToDC.put("status", "dcterms:conformsTo");
        MetadataNamesMapToDC.put("publisher", "dc:publisher");
        MetadataNamesMapToDC.put("doiJournal", "dcterms:isReferencedBy");
        MetadataNamesMapToDC.put("usage", "dcterms:requires");
        MetadataNamesMapToDC.put("year", "dc:date");
        MetadataNamesMapToDC.put("abstract", "dcterms:abstract");
        IsTestRun = false;
        IsWithoutDB = false;
    }

    public static enum IngestStatus {
        IN_PROGRESS,
        IN_HUMAN_STAGE,
        IN_TA,
        ACTIVE,
        DECLINED,
        REJECTED,
        FINISHED,
        FEEDER_STARTED,
        FEEDER_FINISHED,
        FEEDER_ERROR,
        FEEDER_SUBMITTED,
        UNKNOWN;


        public static IngestStatus named(String status) {
            try {
                return IngestStatus.valueOf(status);
            }
            catch (Exception ex) {
                return UNKNOWN;
            }
        }
    }

    private static enum AIPType {
        IE,
        Collection,
        None;

    }

    private static abstract class DB {
        private static final String _TrackingTableName = ".INGEST_TRACKING_RECORD_FEEDER ";
        private static final String _CodeTableName = ".CODE_MAPPING ";
        private static String TrackingTableName;
        private static String CodeTableName;
        private static Connection Connection;
        private static String ExecutionId;

        private DB() {
        }

        protected static void initialize(String host, String port, String serviceName, String dbName, String userName, String userPassword, String executionId) throws SQLException {
            if (IsWithoutDB) {
                return;
            }
            String connectionString = host + ":" + port + "/" + serviceName;
            Logger.debug((java.lang.Object)("(" + executionId + ") DB Initialization: " + connectionString));
            TrackingTableName = dbName + _TrackingTableName;
            CodeTableName = dbName + _CodeTableName;
            Connection = DriverManager.getConnection(connectionString, userName, userPassword);
            ExecutionId = executionId;
        }

        protected static void close() throws SQLException {
            if (IsWithoutDB) {
                return;
            }
            Logger.debug((java.lang.Object)("(" + ExecutionId + ") DB Close"));
            if (Connection != null) {
                Connection.close();
            }
        }

        protected static boolean wasAlreadyIngested(String workspace, String sipName, NodeAbstract node) throws SQLException {
            if (IsWithoutDB) {
                return false;
            }
            String sqlStatement = "select count(*) from " + TrackingTableName + "where workspace_id = ?   and sip_name = ?   and amd_id = ?";
            try (PreparedStatement pstmt = Connection.prepareStatement(sqlStatement);){
                boolean bl;
                block13: {
                    pstmt.setString(1, workspace);
                    pstmt.setString(2, sipName);
                    pstmt.setString(3, node.getAdmId());
                    ResultSet resultSet = pstmt.executeQuery();
                    try {
                        boolean bl2 = bl = resultSet.next() && resultSet.getInt(1) != 0;
                        if (resultSet == null) break block13;
                    }
                    catch (Throwable throwable) {
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    resultSet.close();
                }
                return bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected static void logIECreationStart(NodeAbstract node, String submitRootPath, String workspace, String sipName, String submitTimestamp) throws SQLException {
            if (IsWithoutDB) {
                return;
            }
            String relativeSubmitRootPath = workspace + File.separator + sipName + File.separator + node.getPathString();
            String doi = null;
            if (node.getPID() != null) {
                doi = (String)node.getPID().get(0);
            }
            try (PreparedStatement pstmt = null;){
                pstmt = Connection.prepareStatement("insert into " + TrackingTableName + "(amd_id, workflow_execution_id, workspace_id,workspace_path,submit_timestamp,source_path,create_dt,update_dt,sip_name,sip_path,sip_type,sip_status,doi) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                pstmt.setString(1, node.getAdmId());
                pstmt.setString(2, ExecutionId);
                pstmt.setString(3, workspace);
                pstmt.setString(4, relativeSubmitRootPath);
                pstmt.setTimestamp(5, Timestamp.valueOf(submitTimestamp));
                pstmt.setString(6, relativeSubmitRootPath);
                pstmt.setTimestamp(7, new Timestamp(new Date().getTime()));
                pstmt.setTimestamp(8, new Timestamp(new Date().getTime()));
                pstmt.setString(9, sipName);
                pstmt.setString(10, submitRootPath);
                pstmt.setString(11, "IE");
                pstmt.setString(12, IngestStatus.FEEDER_STARTED.toString());
                pstmt.setString(13, doi);
                Logger.debug((java.lang.Object)("(" + ExecutionId + ") Generating IE:  '" + workspace + "/" + sipName + "/" + node.getAdmId() + "/" + node.getLabel() + "': Start"));
                pstmt.executeUpdate();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected static void logIECreationEnd(NodeAbstract node, IngestStatus status, String workspace, String sipName) throws SQLException {
            if (IsWithoutDB) {
                return;
            }
            try (PreparedStatement pstmt = null;){
                pstmt = Connection.prepareStatement("update " + TrackingTableName + "set sip_status = ?, update_dt = ? where workspace_id = ? and sip_name = ? and amd_id = ?");
                pstmt.setString(1, status.toString());
                pstmt.setTimestamp(2, new Timestamp(new Date().getTime()));
                pstmt.setString(3, workspace);
                pstmt.setString(4, sipName);
                pstmt.setString(5, node.getAdmId());
                Logger.debug((java.lang.Object)("(" + ExecutionId + ") Generating IE:  '" + workspace + "/" + sipName + "/" + node.getAdmId() + "/" + node.getLabel() + "': " + status));
                pstmt.executeUpdate();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected static void logCollectionCreationStart(NodeAbstract node, String submitRootPath, String workspace, String sipName, String submitTimestamp) throws SQLException {
            if (IsWithoutDB) {
                return;
            }
            if (DB.wasAlreadyIngested(workspace, sipName, node)) {
                Logger.debug((java.lang.Object)("(" + ExecutionId + ") DB entry for :  '" + workspace + "/" + sipName + "/" + node.getAdmId() + "/" + node.getLabel() + "' already exists and will not be re-created"));
            } else {
                String relativeSubmitRootPath = workspace + File.separator + sipName + File.separator + node.getPathString();
                String doi = null;
                if (node.getPID() != null) {
                    doi = (String)node.getPID().get(0);
                }
                try (PreparedStatement pstmt = null;){
                    pstmt = Connection.prepareStatement("insert into " + TrackingTableName + "(amd_id, workflow_execution_id, workspace_id,workspace_path,submit_timestamp,source_path,create_dt,update_dt,sip_name,sip_path,sip_type,sip_status,doi) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                    pstmt.setString(1, node.getAdmId());
                    pstmt.setString(2, ExecutionId);
                    pstmt.setString(3, workspace);
                    pstmt.setString(4, relativeSubmitRootPath);
                    pstmt.setTimestamp(5, Timestamp.valueOf(submitTimestamp));
                    pstmt.setString(6, relativeSubmitRootPath);
                    pstmt.setTimestamp(7, new Timestamp(new Date().getTime()));
                    pstmt.setTimestamp(8, new Timestamp(new Date().getTime()));
                    pstmt.setString(9, sipName);
                    pstmt.setString(10, submitRootPath);
                    pstmt.setString(11, "Collection");
                    pstmt.setString(12, IngestStatus.FEEDER_STARTED.toString());
                    pstmt.setString(13, doi);
                    Logger.debug((java.lang.Object)("(" + ExecutionId + ") Generating Call:  '" + workspace + "/" + sipName + "/" + node.getAdmId() + "/" + node.getLabel() + "': Start"));
                    pstmt.executeUpdate();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected static void logCollectionCreationEnd(NodeAbstract node, IngestStatus status, String workspace, String sipName) throws SQLException {
            if (IsWithoutDB) {
                return;
            }
            try (PreparedStatement pstmt = null;){
                pstmt = Connection.prepareStatement("update " + TrackingTableName + "set sip_status = ?, update_dt = ? where workspace_id = ? and sip_name = ? and amd_id = ?");
                pstmt.setString(1, status.toString());
                pstmt.setTimestamp(2, new Timestamp(new Date().getTime()));
                pstmt.setString(3, workspace);
                pstmt.setString(4, sipName);
                pstmt.setString(5, node.getAdmId());
                Logger.debug((java.lang.Object)("(" + ExecutionId + ") Generating Call:  '" + workspace + "/" + sipName + "/" + node.getAdmId() + "/" + node.getLabel() + "': " + status));
                pstmt.executeUpdate();
            }
        }

        protected static void logAIPCreationFinalizeOK(String workspace, String sipName) throws SQLException {
            if (IsWithoutDB) {
                return;
            }
            String sqlStatement = "update " + TrackingTableName + "set sip_status = ?, update_dt = ? where workspace_id = ? and sip_name = ?and sip_status in (?, ?)";
            try (PreparedStatement pstmt = Connection.prepareStatement(sqlStatement);){
                pstmt.setString(1, IngestStatus.FEEDER_SUBMITTED.toString());
                pstmt.setTimestamp(2, new Timestamp(new Date().getTime()));
                pstmt.setString(3, workspace);
                pstmt.setString(4, sipName);
                pstmt.setString(5, IngestStatus.FEEDER_FINISHED.toString());
                pstmt.setString(6, IngestStatus.FEEDER_ERROR.toString());
                Logger.debug((java.lang.Object)("(" + ExecutionId + ") Finalizing SIP: '" + workspace + "/" + sipName + "'"));
                pstmt.executeUpdate();
            }
        }

        protected static Map<String, IngestStatus> getAllStatus(String workspace, String sipName) throws SQLException {
            if (IsWithoutDB) {
                return null;
            }
            HashMap<String, IngestStatus> mapIngestStatus = new HashMap<String, IngestStatus>();
            String sqlStatement = "select amd_id, sip_status from " + TrackingTableName + "where workspace_id = ?  and sip_name = ?";
            try (PreparedStatement pstmt = Connection.prepareStatement(sqlStatement);){
                pstmt.setString(1, workspace);
                pstmt.setString(2, sipName);
                try (ResultSet resultSet = pstmt.executeQuery();){
                    while (resultSet.next()) {
                        mapIngestStatus.put(resultSet.getString(1), IngestStatus.named(resultSet.getString(2)));
                    }
                }
            }
            return mapIngestStatus;
        }

        protected static Map<String, String> getAllEntityIDs(String workspace, String sipName) throws SQLException {
            if (IsWithoutDB) {
                return null;
            }
            HashMap<String, String> mapEntityIDs = new HashMap<String, String>();
            String sqlQuery = "select amd_id, entity_id from " + TrackingTableName + "where workspace_id = ?   and sip_name = ?";
            try (PreparedStatement pstmt = Connection.prepareStatement(sqlQuery);){
                pstmt.setString(1, workspace);
                pstmt.setString(2, sipName);
                try (ResultSet resultSet = pstmt.executeQuery();){
                    while (resultSet.next()) {
                        mapEntityIDs.put(resultSet.getString(1), resultSet.getString(2));
                    }
                }
            }
            return mapEntityIDs;
        }

        protected static String getRosettaCodeIfExists(String workspace, String codeType, String codeFeeder) throws SQLException {
            if (IsWithoutDB) {
                return codeFeeder;
            }
            String codeRosetta = null;
            String sqlQuery = "select code_rosetta from " + CodeTableName + "where ws_refcodeadmin = ?   and code_type = ?   and code_feeder = ?";
            try (PreparedStatement pstmt = Connection.prepareStatement(sqlQuery);){
                pstmt.setString(1, workspace);
                pstmt.setString(2, codeType);
                pstmt.setString(3, codeFeeder);
                try (ResultSet resultSet = pstmt.executeQuery();){
                    if (resultSet.next()) {
                        codeRosetta = resultSet.getString(1);
                        Logger.debug((java.lang.Object)("Translating: '" + codeType + "' from: '" + codeFeeder + "' to: '" + codeRosetta + "'"));
                    }
                }
            }
            return codeRosetta != null ? codeRosetta : codeFeeder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void _prepareTestRun(String workspace, String workspacePath, String sipName) throws SQLException {
            if (IsWithoutDB) {
                return;
            }
            try (PreparedStatement pstmt = null;){
                pstmt = Connection.prepareStatement("delete from " + TrackingTableName + "where workspace_id = ?   and workspace_path = ?   and sip_name = ?");
                pstmt.setString(1, workspace);
                pstmt.setString(2, workspace + "/" + sipName + "/" + workspacePath);
                pstmt.setString(3, sipName);
                Logger.debug((java.lang.Object)("(" + ExecutionId + ") Preparing for testrun AIP:  '" + workspace + "/" + sipName + "/" + workspacePath + "'"));
                pstmt.executeUpdate();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void _setAllStatus(IngestStatus status, String workspace, String sipName) throws SQLException, IllegalArgumentException {
            if (IsWithoutDB) {
                return;
            }
            try (PreparedStatement pstmt = null;){
                pstmt = Connection.prepareStatement("update " + TrackingTableName + "set sip_status = ? where workspace_id = ?   and sip_name = ?");
                pstmt.setString(1, status.toString());
                pstmt.setString(2, workspace);
                pstmt.setString(3, sipName);
                Logger.debug((java.lang.Object)("(" + ExecutionId + ") Setting status AIP:  '" + workspace + "/" + sipName + "': Status: '" + status + "'"));
                pstmt.executeUpdate();
            }
        }
    }
}

