/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.scriptRunner;

import com.exlibris.core.infra.svc.api.scriptRunner.ExecAbstract;
import com.exlibris.core.infra.svc.api.scriptRunner.ExecLocal;
import com.exlibris.core.infra.svc.api.scriptRunner.ExecPipe;
import com.exlibris.core.infra.svc.api.scriptRunner.ExecWrapper;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class ExecTest {
    public static void main(String[] args) {
        int memorySize = new Integer(args[0]);
        String commandsFile = args[1];
        String strategyName = args[2];
        ExecAbstract strategy = null;
        int[] memory = new int[memorySize];
        if (strategyName.equals("local")) {
            strategy = new ExecLocal();
        }
        if (strategyName.equals("pipe")) {
            try {
                strategy = new ExecPipe("/storage/test.sh");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (strategyName.equals("wrapper")) {
            strategy = new ExecWrapper();
        }
        try {
            String strLine;
            FileInputStream fstream = new FileInputStream(commandsFile);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            long startTime = System.currentTimeMillis();
            while ((strLine = br.readLine()) != null) {
                String[] command = strLine.split("\\s+");
                ArrayList<String> commandArgs = new ArrayList<String>();
                for (int i = 1; i < command.length; ++i) {
                    if (command[i].equals("")) continue;
                    commandArgs.add(command[i]);
                }
                strategy.execExternalProcess(command[0], commandArgs);
                System.out.println(strLine + " exit code " + strategy.getExitValue());
                if (strategy.getExitValue() == 0) {
                    System.out.println(strategy.getInputStream());
                    continue;
                }
                System.out.println(strategy.getErrorStream());
            }
            long estimatedTime = System.currentTimeMillis() - startTime;
            System.out.println("elapsed time " + estimatedTime + " ms");
            in.close();
        }
        catch (Exception e) {
            System.err.println("Error: " + e.getMessage());
        }
    }
}

