/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.sdk.utils.metsHrefUtils;

import com.exlibris.core.sdk.utils.FileUtil;
import com.exlibris.core.sdk.utils.metsHrefUtils.HrefUrlUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public class HrefUrlLocalUtil
implements HrefUrlUtil {
    private static final String FILE_PREFIX = FilenameUtils.normalize((String)"file://");
    private File file;
    private String formattedPath;
    private boolean isRelative = false;
    private String filePath;

    public HrefUrlLocalUtil(String filePath, String sipStreamsPath) {
        filePath = FilenameUtils.normalize((String)filePath);
        this.formatPath(filePath, sipStreamsPath);
    }

    private void formatPath(String filePath, String sipStreamsPath) {
        String prefix;
        this.filePath = filePath;
        if (filePath.startsWith(FILE_PREFIX)) {
            filePath = filePath.substring(FILE_PREFIX.length());
        }
        if (StringUtils.isEmpty((String)(prefix = FilenameUtils.getPrefix((String)filePath.replace("~", "")))) && sipStreamsPath != null) {
            filePath = sipStreamsPath + File.separator + filePath;
            this.isRelative = true;
        }
        this.formattedPath = filePath;
    }

    @Override
    public void init() throws Exception {
        this.file = new File(this.formattedPath);
    }

    @Override
    public long getFileSize() throws Exception {
        return this.file.length();
    }

    @Override
    public InputStream getFileInputStream() throws Exception {
        return new FileInputStream(this.file);
    }

    @Override
    public void closeFileConnection() throws Exception {
    }

    @Override
    public String getFormattedFilePath() {
        return this.formattedPath;
    }

    @Override
    public String getFileName() {
        return this.file.getName();
    }

    @Override
    public boolean supportsMove() {
        return true;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public boolean isRelative() {
        return this.isRelative;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.formattedPath == null ? 0 : this.toString().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HrefUrlLocalUtil other = (HrefUrlLocalUtil)obj;
        return !(this.formattedPath == null ? other.formattedPath != null : !this.toString().equals(other.toString()));
    }

    public String toString() {
        try {
            return new File(this.formattedPath).getCanonicalPath();
        }
        catch (IOException e) {
            return this.formattedPath;
        }
    }

    @Override
    public String getRelativePath() {
        if (this.isRelative()) {
            return this.filePath;
        }
        return this.getFileName();
    }

    @Override
    public void copyTo(String destinationPath) throws Exception {
        if (!this.getFile().isFile()) {
            this.formattedPath = URLDecoder.decode(this.formattedPath, "UTF-8");
            this.file = new File(this.formattedPath);
        }
        FileUtil.copyFile(this.getFile(), new File(destinationPath));
    }

    @Override
    public String getFormattedAbsolutePath() throws IOException {
        this.filePath = this.filePath.contains(":") ? this.filePath.replace(":", "") : this.filePath;
        return FilenameUtils.normalize((String)this.filePath);
    }
}

