/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.dps.utils;

import com.exlibris.core.infra.common.exceptions.logging.DescriptorConstants;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.security.UserPrincipal;
import com.exlibris.core.infra.common.shared.dataObjects.KeyValuePair;
import com.exlibris.core.infra.common.util.Checksummer;
import com.exlibris.core.infra.common.util.IOUtil;
import com.exlibris.core.infra.svc.api.GeneralParameterManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.infra.svc.api.utils.DublinCoreDefinition;
import com.exlibris.core.sdk.consts.Enum;
import com.exlibris.core.sdk.formatting.DublinCore;
import com.exlibris.core.sdk.parser.IEParserException;
import com.exlibris.core.sdk.utils.FileUtil;
import com.exlibris.core.sdk.utils.XmlUtils;
import com.exlibris.digitool.common.dnx.DnxDocument;
import com.exlibris.digitool.common.dnx.DnxDocumentHelper;
import com.exlibris.digitool.exceptions.DepositProcessingException;
import com.exlibris.digitool.exceptions.DigitoolException;
import com.exlibris.digitool.repository.dataObjects.DescriptorRow;
import com.exlibris.digitool.repository.dataObjects.FileCharacteristics;
import com.exlibris.digitool.repository.dataObjects.RepresentationCharacteristics;
import com.exlibris.digitool.repository.ifc.AddRepresentationManager;
import com.exlibris.digitool.repository.ifc.MetaData;
import com.exlibris.digitool.repository.ifc.RepositoryServices;
import com.exlibris.digitool.repository.ifc.RepresentationContent;
import com.exlibris.digitool.utils.CSVUtil;
import com.exlibris.dps.backoffice.model.CSVTemplateField;
import com.exlibris.dps.sdk.deposit.IEParser;
import com.exlibris.repository.dps.model.collections.HDeCollection;
import com.exlibris.repository.persistence.digitalentity.HDeStreamRef;
import com.exlibris.repository.persistence.rip.HrRipRegistry;
import gov.loc.mets.MdSecType;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.dom4j.Namespace;

public class RepositoryUtils {
    private static final String TEMP_REP = "TEMP_REP";
    private static final String TEMP_FILE = "TEMP_FILE";
    private static final String EXTERNALID = "externalid";
    private static final String EXTERNALSYSTEM = "externalsystem";
    private static final String PUBLISH = "publish";
    private static final String NAVIGATE = "navigate";
    private static final String DESCRIPTION = "description";
    private static final String OTHER = "OTHER";
    public static final String DERIVATIVE_COPY = "DERIVATIVE_COPY";
    public static final String PRESERVATION_MASTER = "PRESERVATION_MASTER";
    public static final String NONE = "none";
    static ExLogger logger = ExLogger.getExLogger(RepositoryUtils.class, "RPS");

    public static void completeUpdateRep(List<FileCharacteristics> filesList, String directory, UserPrincipal up, String iePid, RepresentationCharacteristics rc) throws Exception {
        RepositoryUtils.completeUpdateRep(filesList, directory, up, iePid, rc, null);
    }

    public static void completeUpdateRep(List<FileCharacteristics> filesList, String directory, UserPrincipal up, String iePid, RepresentationCharacteristics rc, Long processID) throws Exception {
        ArrayList<String[]> rows = new ArrayList<String[]>();
        DescriptorRow row = null;
        RepresentationCharacteristics repChars = rc;
        for (FileCharacteristics file : filesList) {
            if (repChars == null) {
                repChars = RepositoryUtils.getRepCharacteristics(file.getParentPid());
            }
            row = RepositoryUtils.getDescriptorRow(file, iePid, repChars.getPreservationType(), repChars.getUsageType(), repChars.getAccessRightsPolicy(), repChars.getRepresentationEntityType(), repChars.getRepresentationCode(), repChars.getProvenanceInformation(), repChars.getLabel(), repChars.getProperties());
            rows.add(row.getRow());
        }
        CSVUtil.writeFile(FilenameUtils.concat((String)directory, (String)"Import_Descriptor.csv"), rows, row.getHeaderRow());
        AddRepresentationManager manager = (AddRepresentationManager)ServiceLocator.getInstance().lookUp(AddRepresentationManager.class);
        manager.addRepresentation(directory, up.getUserName(), up.getInstitutionPath(), HrRipRegistry.RipType.MEDITOR.toString(), iePid, 43L, 44L, null, processID);
    }

    public static DescriptorRow getDescriptorRow(FileCharacteristics file, String iePid, String presType, String usageType, String arPolicy, String repEntityType, String repCode, String provInfo, String label, List<KeyValuePair<String, String>> properties) throws Exception {
        DescriptorRow row = new DescriptorRow(DescriptorRow.DescriptorHeader.AccessRightsPolicy);
        row.set(DescriptorRow.DescriptorHeader.IePid, iePid);
        row.set(DescriptorRow.DescriptorHeader.RepresentationPid, com.exlibris.core.sdk.strings.StringUtils.isEmptyString(file.getParentPid()) ? TEMP_REP : file.getParentPid());
        if (com.exlibris.core.sdk.strings.StringUtils.isEmptyString(file.getPid())) {
            row.set(DescriptorRow.DescriptorHeader.OriginalPid, TEMP_FILE);
        } else {
            row.set(DescriptorRow.DescriptorHeader.OriginalPid, file.getPid());
        }
        row.set(DescriptorRow.DescriptorHeader.Filename, file.getFilename());
        row.set(DescriptorRow.DescriptorHeader.FileLocation, file.isOriginal() ? null : StringUtils.removeEnd((String)file.getSourcePath(), (String)file.getFilename()));
        row.set(DescriptorRow.DescriptorHeader.PreservationType, presType);
        row.set(DescriptorRow.DescriptorHeader.UsageType, usageType);
        row.set(DescriptorRow.DescriptorHeader.AccessRightsPolicy, arPolicy);
        row.set(DescriptorRow.DescriptorHeader.RepresentationEntityType, repEntityType);
        row.set(DescriptorRow.DescriptorHeader.RepresentationCode, repCode);
        row.set(DescriptorRow.DescriptorHeader.FileLabel, com.exlibris.core.sdk.strings.StringUtils.getNullSafe(file.getLabel()));
        row.set(DescriptorRow.DescriptorHeader.FileStructMapLabel, com.exlibris.core.sdk.strings.StringUtils.getNullSafe(file.getStructMapLabel()));
        row.set(DescriptorRow.DescriptorHeader.Checksum, file.getChecksum());
        String submissionReason = provInfo;
        if (DERIVATIVE_COPY.equals(presType)) {
            submissionReason = "";
        } else if (com.exlibris.core.sdk.strings.StringUtils.isEmptyString(submissionReason)) {
            submissionReason = ".";
        }
        row.set(DescriptorRow.DescriptorHeader.SubmissionReason, submissionReason);
        row.set(DescriptorRow.DescriptorHeader.Notes, com.exlibris.core.sdk.strings.StringUtils.getNullSafe(file.getNote()));
        row.set(DescriptorRow.DescriptorHeader.Label, com.exlibris.core.sdk.strings.StringUtils.getNullSafe(label));
        row.addAdditionalParameters(properties);
        return row;
    }

    public static List<DescriptorRow> getDescriptorRows(RepresentationContent[] representationContents, String iePid, String preservationType, String arPolicy, String repEntityType, String repCode, String submissionReason, String label, MetaData[] metadata) throws Exception {
        ArrayList<DescriptorRow> descriptorRows = new ArrayList<DescriptorRow>();
        for (RepresentationContent representationContent : representationContents) {
            String fixityAlgorithmType;
            String fixityValue;
            DescriptorRow row = new DescriptorRow(DescriptorRow.DescriptorHeader.AccessRightsPolicy, DescriptorRow.DescriptorHeader.ChecksumType, DescriptorRow.DescriptorHeader.FileOriginalPath);
            row.set(DescriptorRow.DescriptorHeader.IePid, iePid);
            row.set(DescriptorRow.DescriptorHeader.RepresentationPid, TEMP_REP);
            row.set(DescriptorRow.DescriptorHeader.SubmissionReason, com.exlibris.core.sdk.strings.StringUtils.getNullSafe(submissionReason));
            row.set(DescriptorRow.DescriptorHeader.Label, com.exlibris.core.sdk.strings.StringUtils.getNullSafe(label));
            row.set(DescriptorRow.DescriptorHeader.PreservationType, preservationType);
            row.set(DescriptorRow.DescriptorHeader.UsageType, Enum.UsageType.VIEW.name());
            row.set(DescriptorRow.DescriptorHeader.AccessRightsPolicy, arPolicy);
            row.set(DescriptorRow.DescriptorHeader.RepresentationEntityType, repEntityType);
            row.set(DescriptorRow.DescriptorHeader.RepresentationCode, repCode);
            row.set(DescriptorRow.DescriptorHeader.OriginalPid, TEMP_FILE);
            row.set(DescriptorRow.DescriptorHeader.representationMetadata, RepositoryUtils.getMd(metadata));
            row.set(DescriptorRow.DescriptorHeader.FileOriginalPath, representationContent.getFileOriginalPath());
            row.set(DescriptorRow.DescriptorHeader.Filename, FilenameUtils.getName((String)representationContent.getNewFile()));
            row.set(DescriptorRow.DescriptorHeader.FileLocation, FilenameUtils.getFullPath((String)representationContent.getNewFile()));
            row.set(DescriptorRow.DescriptorHeader.FileLabel, representationContent.getLabel());
            row.set(DescriptorRow.DescriptorHeader.FileStructMapLabel, representationContent.getLabel());
            row.set(DescriptorRow.DescriptorHeader.fileMetadata, RepositoryUtils.getMd(representationContent.getMetadata()));
            if (representationContent.getFixity() != null && com.exlibris.core.sdk.strings.StringUtils.notEmptyString(representationContent.getFixity().getValue())) {
                fixityValue = representationContent.getFixity().getValue();
                fixityAlgorithmType = representationContent.getFixity().getAlgorithmType();
            } else {
                fixityValue = new Checksummer(new File(representationContent.getNewFile()), true, false, false).getMD5();
                fixityAlgorithmType = Checksummer.FixityAlgorithm.MD5.name();
            }
            row.set(DescriptorRow.DescriptorHeader.Checksum, fixityValue);
            row.set(DescriptorRow.DescriptorHeader.ChecksumType, fixityAlgorithmType);
            descriptorRows.add(row);
        }
        return descriptorRows;
    }

    public static String getMd(MetaData[] metadataArr) {
        String metaData = "";
        if (metadataArr != null) {
            for (MetaData md : metadataArr) {
                metaData = metaData + md.toString() + ";;";
            }
        }
        return metaData;
    }

    public static FileCharacteristics uploadFile(String importDir, String uploadFilename, InputStream inputStream, String uniqId, String note, String label, String structMapLabel) throws Exception {
        String filename = FileUtil.getFileName(uploadFilename);
        String tempDir = importDir;
        String filePath = tempDir + File.separator + uniqId + File.separator + filename;
        File targetFile = new File(filePath);
        if (targetFile.exists()) {
            throw new Exception("File with the same name already exists: " + targetFile.getAbsolutePath());
        }
        targetFile.getParentFile().mkdirs();
        Checksummer checksummer = null;
        targetFile.createNewFile();
        BufferedOutputStream outputStream = null;
        outputStream = new BufferedOutputStream(new FileOutputStream(targetFile));
        try {
            checksummer = new Checksummer(inputStream != null ? inputStream : new FileInputStream(new File(uploadFilename)), outputStream, true, false, false, false);
            checksummer.createChecksumAndCopyFile();
            if (inputStream == null) {
                IOUtil.shutdownStream(inputStream);
                IOUtil.shutdownStream(outputStream);
                File source = new File(uploadFilename);
                targetFile.setLastModified(source.lastModified());
            }
        }
        catch (Exception e) {
            throw new Exception("Unable to upload file", e);
        }
        finally {
            IOUtil.shutdownStream(inputStream);
            IOUtil.shutdownStream(outputStream);
        }
        return RepositoryUtils.createFileCharacteristics(filename, filePath, checksummer, note, label, structMapLabel);
    }

    public static FileCharacteristics createFileCharacteristics(String filename, String filePath, Checksummer checksummer, String note, String label, String structMapLabel) {
        FileCharacteristics fileCharacteristics = new FileCharacteristics();
        fileCharacteristics.setFilename(filename);
        fileCharacteristics.setDate(Calendar.getInstance().getTime());
        fileCharacteristics.setLabel(label);
        fileCharacteristics.setStructMapLabel(structMapLabel);
        fileCharacteristics.setNote(note);
        File targetFile = new File(filePath);
        fileCharacteristics.setSizeKB(targetFile.length());
        fileCharacteristics.setSourcePath(targetFile.getAbsolutePath());
        fileCharacteristics.setOriginalFilename(filename);
        fileCharacteristics.setOriginal(false);
        fileCharacteristics.setChecksum(checksummer.getMD5());
        return fileCharacteristics;
    }

    public static FileCharacteristics getFileCharacteristicsForExistingFile(HDeStreamRef streamRef) throws Exception {
        FileCharacteristics fc = new FileCharacteristics();
        DnxDocument dnxDocument = RepositoryUtils.getRepositoryServices().getDnxDocumentByPid(streamRef.getPid());
        DnxDocumentHelper dnxDocumentHelper = new DnxDocumentHelper(dnxDocument);
        String fcLabel = com.exlibris.core.sdk.strings.StringUtils.isEmptyString(dnxDocumentHelper.getGeneralFileCharacteristics().getLabel()) ? "" : dnxDocumentHelper.getGeneralFileCharacteristics().getLabel();
        fc.setLabel(fcLabel);
        fc.setOriginalFilename(streamRef.getFileOriginalName());
        fc.setSizeKB(Double.parseDouble(dnxDocumentHelper.getGeneralFileCharacteristics().getFileSizeBytes()));
        fc.setPid(streamRef.getPid());
        String path = RepositoryUtils.getRepositoryServices().getFilePath(streamRef.getPid());
        fc.setSourcePath(path);
        String fName = FileUtil.getFileName(path);
        fc.setFilename(fName);
        fc.setParentPid(RepositoryUtils.getRepositoryServices().getParentRepPid(streamRef.getPid()));
        return fc;
    }

    public static String getPidFromDnx(DnxDocument dnx) {
        DnxDocumentHelper helper = new DnxDocumentHelper(dnx);
        List<DnxDocumentHelper.InternalIdentifier> internalIdentifiers = helper.getInternalIdentifiers();
        for (DnxDocumentHelper.InternalIdentifier internalIdentifier : internalIdentifiers) {
            if (!internalIdentifier.getInternalIdentifierType().equals("PID")) continue;
            return internalIdentifier.getInternalIdentifierValue();
        }
        return null;
    }

    public static Integer getPABulkSize() {
        int bulkSize = 100;
        try {
            GeneralParameterManager gpm = (GeneralParameterManager)ServiceLocator.getInstance().lookUp(GeneralParameterManager.class);
            bulkSize = Integer.parseInt(gpm.getParameter("background_jobs", "pa_bulk_size"));
        }
        catch (Exception e) {
            logger.error("Failed to get PA bulk size from general parameter , default bulk size will be used (" + bulkSize + "). error msg: " + e, new String[0]);
        }
        return bulkSize;
    }

    public static Integer getFileBulkLength() {
        int bulkSize = 100;
        return bulkSize;
    }

    public static Integer getPASetListPageSize() {
        int bulkSize = 1000;
        try {
            GeneralParameterManager gpm = (GeneralParameterManager)ServiceLocator.getInstance().lookUp(GeneralParameterManager.class);
            bulkSize = Integer.parseInt(gpm.getParameter("background_jobs", "pa_set_list_page_size"));
        }
        catch (Exception e) {
            logger.error("Failed to get PA set list page size from general parameter , default bulk size will be used (" + bulkSize + "). error msg: " + e, new String[0]);
        }
        return bulkSize;
    }

    public static boolean addPropertiesToDnx(Map<String, String> csvRowHash, DnxDocument dnx, DublinCore dc, HDeCollection collection, List<CSVTemplateField> csvTemplatesFields, String objType) throws DepositProcessingException, IOException, IEParserException, XmlException {
        boolean hasSourceMd = false;
        HashSet<String> dcPrefixes = new HashSet<String>();
        if (dc != null) {
            dcPrefixes.add("dc:");
            dcPrefixes.add("dcterms:");
            Map<String, Namespace> dcNameSpaces = DublinCoreDefinition.getNameSpaceMap();
            if (dcNameSpaces != null) {
                for (String prefix : dcNameSpaces.keySet()) {
                    dcPrefixes.add(prefix + ":");
                    dc.addNamespace(dcNameSpaces.get(prefix));
                }
            }
        }
        Set<String> keysSet = csvRowHash.keySet();
        for (String label : keysSet) {
            String validationLabel = label.split("_")[0];
            if ("event".equalsIgnoreCase(validationLabel)) {
                dnx.parseXmlToEventSection(csvRowHash.get(label));
                continue;
            }
            if (StringUtils.containsIgnoreCase((String)validationLabel, (String)"Source Metadata")) {
                hasSourceMd = true;
                continue;
            }
            String xpath = RepositoryUtils.getXpathByTypeAndLabel(csvTemplatesFields, objType, validationLabel);
            if (xpath != null) {
                String modifiedValue = XmlUtils.stripNonValidXMLCharacters(csvRowHash.get(label));
                if (!modifiedValue.equals(csvRowHash.get(label))) {
                    logger.warn((Object)("The value " + csvRowHash.get(label) + " inserted into DNX , while converting CSV , was modified. "), new String[0]);
                }
                if (dcPrefixes.contains(xpath.substring(0, xpath.indexOf(":") + 1))) {
                    String[] array = xpath.split("@");
                    if (array != null && array.length >= 2) {
                        String[] atrribute = array[1].split("=");
                        xpath = array[0] + "@" + atrribute[1].replaceAll("\"", "");
                        if (atrribute[0] != null && atrribute[0].startsWith("xsi")) {
                            dc.addElement(xpath, csvRowHash.get(label), DublinCore.XsiQName);
                            continue;
                        }
                        dc.addElement(xpath, csvRowHash.get(label), DublinCore.XmlQName);
                        continue;
                    }
                    dc.addElement(xpath, csvRowHash.get(label));
                    continue;
                }
                if (xpath.startsWith("dnx.")) {
                    RepositoryUtils.addKeyToDnxDoc(dnx, xpath, csvRowHash.get(label));
                    continue;
                }
                if (xpath.toLowerCase().startsWith("collection.")) {
                    RepositoryUtils.addParameterToCollection(collection, xpath, csvRowHash.get(label));
                    continue;
                }
                if (!xpath.startsWith("SIP.")) continue;
                dc.addNamespace(DublinCoreDefinition.rosettaNamespace);
                dc.addElement(50, xpath.split("\\.")[1], csvRowHash.get(label));
                continue;
            }
            logger.warn((Object)("The label '" + validationLabel + "' in object type level '" + objType + "' has no mapping in the CS's CSV Template"), new String[0]);
        }
        return hasSourceMd;
    }

    public static void addSourceMDFromCSV(Map<String, String> csvRowHash, String objType, IEParser ie, String id) throws IEParserException, XmlException, DepositProcessingException {
        Set<String> keysSet = csvRowHash.keySet();
        for (String label : keysSet) {
            String validationLabel = label.split("_")[0];
            if (!StringUtils.containsIgnoreCase((String)validationLabel, (String)"Source Metadata")) continue;
            XmlObject sourceMDContent = RepositoryUtils.getXmlObject(csvRowHash.get(label));
            String sourceMdType = sourceMDContent.getDomNode().getFirstChild().getFirstChild().getNextSibling().getAttributes().getNamedItem("MDTYPE").getNodeValue();
            MdSecType.MdWrap.MDTYPE.Enum mdType = MdSecType.MdWrap.MDTYPE.Enum.forString(sourceMdType);
            if (mdType == null) {
                throw new DepositProcessingException(DescriptorConstants.RP_MetadataTypeNotExist, sourceMdType);
            }
            if (OTHER.equalsIgnoreCase(sourceMdType)) {
                sourceMdType = sourceMDContent.getDomNode().getFirstChild().getFirstChild().getNextSibling().getAttributes().getNamedItem("OTHERMDTYPE").getNodeValue();
            }
            if (sourceMdType == null) {
                throw new DepositProcessingException(DescriptorConstants.RP_MissingOtherMD, (Object)mdType);
            }
            String strippedXML = StringUtils.substringBetween((String)sourceMDContent.toString(), (String)"<xmlData>", (String)"</xmlData>");
            sourceMDContent = XmlObject.Factory.parse((String)strippedXML);
            ie.setSourceMd(mdType, sourceMDContent, sourceMdType, id);
        }
    }

    private static void addParameterToCollection(HDeCollection collection, String xpath, String value) {
        if (xpath.toLowerCase().contains(DESCRIPTION)) {
            collection.setDescription(value);
        } else if (xpath.toLowerCase().contains(EXTERNALSYSTEM)) {
            collection.setExternalSystem(value);
        } else if (xpath.toLowerCase().contains(EXTERNALID)) {
            collection.setExternalId(value);
        } else if (xpath.toLowerCase().contains(PUBLISH)) {
            collection.setPublish(Boolean.parseBoolean(value));
        } else if (xpath.toLowerCase().contains(NAVIGATE)) {
            collection.setNavigate(Boolean.parseBoolean(value));
        }
    }

    private static String getXpathByTypeAndLabel(List<CSVTemplateField> csvTemplatesFields, String objType, String label) {
        String xpath = null;
        String string = objType = "REPRESENTATION".equalsIgnoreCase(objType) ? "REP" : objType;
        if (csvTemplatesFields != null) {
            for (CSVTemplateField csvTemplateField : csvTemplatesFields) {
                if (!csvTemplateField.getObjectType().name().equalsIgnoreCase(objType)) continue;
                String fieldXpath = csvTemplateField.getFieldXpath();
                String fieldLabel = StringUtils.isNotBlank((String)csvTemplateField.getFieldLabel()) ? csvTemplateField.getFieldLabel() : CSVUtil.getLabelByXpathAndObjectType(objType, fieldXpath);
                if (!fieldLabel.equals(label)) continue;
                xpath = fieldXpath;
                break;
            }
        }
        if (xpath == null) {
            if (objType.equalsIgnoreCase("SIP")) {
                if (label.equals("External System")) {
                    xpath = "SIP.externalSystem";
                } else if (label.equals("External ID")) {
                    xpath = "SIP.externalId";
                }
            }
            if (objType.equalsIgnoreCase("Collection")) {
                if (label.equals("Title (DC)")) {
                    xpath = "dc:title";
                } else if (label.equals("Is Part Of (DCTERMS)")) {
                    xpath = "dcterms:isPartOf";
                }
            }
            if (objType.equalsIgnoreCase("File")) {
                if (label.equals("File Original Name")) {
                    xpath = "dnx.generalFileCharacteristics.fileOriginalName";
                } else if (label.equals("File Original Path")) {
                    xpath = "dnx.generalFileCharacteristics.fileOriginalPath";
                }
            }
        }
        return xpath;
    }

    private static void addKeyToDnxDoc(DnxDocument dnx, String xpath, String value) {
        String[] xpathParams = xpath.split("\\.");
        if (xpathParams.length == 3) {
            dnx.updateSectionKey(xpathParams[1], xpathParams[2], value);
        } else if (xpathParams.length == 4) {
            dnx.updateRecordSectionKey(xpathParams[1], xpathParams[2], xpathParams[3], value);
        }
    }

    public static RepresentationCharacteristics getRepCharacteristics(String repPid) throws DigitoolException {
        RepresentationCharacteristics rc = new RepresentationCharacteristics();
        DnxDocumentHelper d = new DnxDocumentHelper(RepositoryUtils.getRepositoryServices().getDnxDocumentByPid(repPid));
        if (d.getAccessRightsPolicy() != null) {
            rc.setAccessRightsPolicy(d.getAccessRightsPolicy().getPolicyId());
        }
        rc.setPreservationType(d.getGeneralRepCharacteristics().getPreservationType());
        rc.setRepresentationCode(d.getGeneralRepCharacteristics().getRepresentationCode());
        rc.setLabel(d.getGeneralRepCharacteristics().getLabel());
        rc.setUsageType(d.getGeneralRepCharacteristics().getUsageType());
        return rc;
    }

    private static RepositoryServices getRepositoryServices() throws DigitoolException {
        RepositoryServices repositoryServices = (RepositoryServices)ServiceLocator.getInstance().lookUp(RepositoryServices.class);
        if (repositoryServices == null) {
            throw new DigitoolException(DescriptorConstants.GN_UnexpectedError, "Failed to lookup RepositoryServices");
        }
        return repositoryServices;
    }

    public static String getTempDeliveryDirectory() {
        GeneralParameterManager gpm = (GeneralParameterManager)ServiceLocator.getInstance().lookUp(GeneralParameterManager.class);
        String operationalShared = gpm.getParameter("general", "operational_shared");
        return operationalShared + File.separator + "tmp" + File.separator + "delivery" + File.separator;
    }

    protected static XmlObject getXmlObject(String xml) throws IEParserException {
        try {
            if (xml.contains("?xml version=")) {
                xml = StringUtils.substringAfter((String)xml, (String)"?>");
            }
            if (xml.contains("mets:")) {
                xml = xml.replaceAll("mets:", "");
            }
            return XmlObject.Factory.parse((String)xml);
        }
        catch (XmlException e) {
            throw new IEParserException(IEParserException.Descriptor.XML_PARSING_EXCEPTION, (Throwable)e);
        }
    }

    public static String normalizeInput(String input) {
        return com.exlibris.core.sdk.strings.StringUtils.isEmptyString(input) || "null".equalsIgnoreCase(input) ? NONE : input.toLowerCase();
    }
}

