/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.repository.procauto;

import com.exlibris.core.infra.model.annotation.Searchable;
import com.exlibris.repository.persistence.HDeSet;
import com.exlibris.repository.procauto.HPaTaskChainTasks;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;

@Entity
@NamedQueries(value={@NamedQuery(name="deleteTaskByTaskName", query="DELETE from HPaTask WHERE name = :name")})
@NamedNativeQueries(value={@NamedNativeQuery(name="getTaskByTaskName", query="select * from HPaTask WHERE name = :name", resultClass=HPaTask.class)})
@Table(name="HPATASK")
public class HPaTask {
    private Long taskId;
    private String name;
    private String description;
    private String createdBy;
    private Date creationDate;
    private String modifiedBy;
    private Date modificationDate;
    private String javaClass;
    private HDeSet.PremisObjectType objectType;
    private PrivilegeGroupType privilegeGroup;
    private String formDefinition;
    private List<HPaTaskChainTasks> hpataskchaintasksByTaskId;
    private int requiresSet;
    private TaskExecutionType executionType;
    private String indexXml;

    @Id
    @Column(name="TASK_ID")
    @GeneratedValue(strategy=GenerationType.AUTO)
    public Long getTaskId() {
        return this.taskId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    @JoinColumn(name="TASK_ID", updatable=false)
    public List<HPaTaskChainTasks> getHpataskchaintasksByTaskId() {
        return this.hpataskchaintasksByTaskId;
    }

    public void setHpataskchaintasksByTaskId(List<HPaTaskChainTasks> hpataskchaintasksByTaskId) {
        this.hpataskchaintasksByTaskId = hpataskchaintasksByTaskId;
    }

    public void addTaskChainTasks(HPaTaskChainTasks taskChainTasks) {
        if (this.getHpataskchaintasksByTaskId() == null) {
            this.setHpataskchaintasksByTaskId(new ArrayList<HPaTaskChainTasks>(0));
        }
        taskChainTasks.setHPaTask(this);
        this.getHpataskchaintasksByTaskId().add(taskChainTasks);
    }

    @Column(name="NAME", nullable=false, length=50)
    @Searchable
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name="DESCRIPTION", length=200)
    @Searchable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Column(name="CREATED_BY", nullable=false)
    @Searchable
    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @Column(name="CREATION_DATE")
    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    @Column(name="MODIFIED_BY")
    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    @Column(name="MODIFICATION_DATE")
    public Date getModificationDate() {
        return this.modificationDate;
    }

    public void setModificationDate(Date modificationDate) {
        this.modificationDate = modificationDate;
    }

    @Column(name="JAVA_CLASS", nullable=false, length=300)
    public String getJavaClass() {
        return this.javaClass;
    }

    public void setJavaClass(String javaClass) {
        this.javaClass = javaClass;
    }

    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="OBJECT_TYPE", nullable=false)
    @Searchable
    public HDeSet.PremisObjectType getObjectType() {
        return this.objectType;
    }

    public void setObjectType(HDeSet.PremisObjectType objectType2) {
        this.objectType = objectType2;
    }

    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="PRIVILEGE_GROUP", nullable=false)
    @Searchable
    public PrivilegeGroupType getPrivilegeGroup() {
        return this.privilegeGroup;
    }

    public void setPrivilegeGroup(PrivilegeGroupType privilegeGroup) {
        this.privilegeGroup = privilegeGroup;
    }

    @Column(name="REQUIRES_SET", nullable=false)
    public int getRequiresSet() {
        return this.requiresSet;
    }

    public void setRequiresSet(int requiresSet) {
        this.requiresSet = requiresSet;
    }

    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="EXECUTION_TYPE")
    public TaskExecutionType getExecutionType() {
        return this.executionType;
    }

    public void setExecutionType(TaskExecutionType executionType) {
        this.executionType = executionType;
    }

    @Lob
    @Column(name="FORM_DEFINITION")
    public String getFormDefinition() {
        return this.formDefinition;
    }

    public void setFormDefinition(String formDefinition) {
        this.formDefinition = formDefinition;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.javaClass == null ? 0 : this.javaClass.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.taskId == null ? 0 : this.taskId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HPaTask)) {
            return false;
        }
        HPaTask other = (HPaTask)obj;
        if (this.javaClass == null ? other.javaClass != null : !this.javaClass.equals(other.javaClass)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.taskId == null ? other.taskId != null : !this.taskId.equals(other.taskId));
    }

    @Column(name="index_xml")
    @Lob
    public String getIndexXml() {
        return this.indexXml;
    }

    public void setIndexXml(String indexXml) {
        this.indexXml = indexXml;
    }

    public static enum PrivilegeGroupType {
        NA,
        FULL,
        TYPICAL,
        VIEW;

    }

    public static enum TaskExecutionType {
        INTERNAL,
        EXTERNAL;

    }
}

