/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.compiler.matcher;

import java.util.ArrayList;
import java.util.List;
import net.byteseek.compiler.AbstractCompiler;
import net.byteseek.compiler.CompileException;
import net.byteseek.compiler.Optimiser;
import net.byteseek.compiler.matcher.MatcherCompilerUtils;
import net.byteseek.compiler.matcher.SequenceMatcherOptimiser;
import net.byteseek.matcher.bytes.ByteMatcherFactory;
import net.byteseek.matcher.bytes.OptimalByteMatcherFactory;
import net.byteseek.matcher.sequence.ByteSequenceMatcher;
import net.byteseek.matcher.sequence.SequenceMatcher;
import net.byteseek.matcher.sequence.SequenceSequenceMatcher;
import net.byteseek.parser.ParseException;
import net.byteseek.parser.Parser;
import net.byteseek.parser.regex.RegexParser;
import net.byteseek.parser.tree.ParseTree;
import net.byteseek.parser.tree.ParseTreeType;
import net.byteseek.parser.tree.ParseTreeUtils;
import net.byteseek.parser.tree.node.ChildrenNode;

public class SequenceMatcherCompiler
extends AbstractCompiler<SequenceMatcher, ParseTree> {
    protected static final boolean NOT_YET_INVERTED = false;
    protected static SequenceMatcherCompiler defaultCompiler;
    protected final ByteMatcherFactory byteMatcherFactory;
    protected final Optimiser<SequenceMatcher> optimiser;

    public static SequenceMatcher compileFrom(String expression) throws CompileException {
        defaultCompiler = new SequenceMatcherCompiler();
        return (SequenceMatcher)defaultCompiler.compile(expression);
    }

    public SequenceMatcherCompiler() {
        this(null, null, null);
    }

    public SequenceMatcherCompiler(ByteMatcherFactory factoryToUse) {
        this(null, factoryToUse, null);
    }

    public SequenceMatcherCompiler(Optimiser<SequenceMatcher> optimiser) {
        this(null, null, optimiser);
    }

    public SequenceMatcherCompiler(ByteMatcherFactory byteFactory, Optimiser<SequenceMatcher> optimiser) {
        this(null, byteFactory, optimiser);
    }

    public SequenceMatcherCompiler(Parser<ParseTree> parser) {
        this(parser, null, null);
    }

    public SequenceMatcherCompiler(Parser<ParseTree> parser, ByteMatcherFactory byteFactoryToUse) {
        this(parser, byteFactoryToUse, null);
    }

    public SequenceMatcherCompiler(Parser<ParseTree> parser, Optimiser<SequenceMatcher> optimiser) {
        this(parser, null, optimiser);
    }

    public SequenceMatcherCompiler(Parser<ParseTree> parser, ByteMatcherFactory byteFactoryToUse, Optimiser<SequenceMatcher> optimiser) {
        super(parser == null ? new RegexParser() : parser);
        this.byteMatcherFactory = byteFactoryToUse != null ? byteFactoryToUse : OptimalByteMatcherFactory.FACTORY;
        this.optimiser = optimiser != null ? optimiser : new SequenceMatcherOptimiser();
    }

    @Override
    protected SequenceMatcher doCompile(ParseTree ast) throws ParseException {
        List<SequenceMatcher> sequences = this.buildSequenceList(ast, new ArrayList<SequenceMatcher>());
        return this.optimiser.optimise(new SequenceSequenceMatcher(sequences));
    }

    protected List<SequenceMatcher> buildSequenceList(ParseTree matcherNode, List<SequenceMatcher> sequenceList) throws ParseException {
        switch (matcherNode.getParseTreeType()) {
            case BYTE: {
                this.addByteMatcher(matcherNode, sequenceList);
                break;
            }
            case ANY: {
                this.addAnyMatcher(matcherNode, sequenceList);
                break;
            }
            case ALL_BITMASK: {
                this.addAllBitmaskMatcher(matcherNode, sequenceList);
                break;
            }
            case ANY_BITMASK: {
                this.addAnyBitmaskMatcher(matcherNode, sequenceList);
                break;
            }
            case RANGE: {
                this.addRangeMatcher(matcherNode, sequenceList);
                break;
            }
            case STRING: {
                this.addStringMatcher(matcherNode, sequenceList);
                break;
            }
            case CASE_INSENSITIVE_STRING: {
                this.addCaseInsensitiveStringMatcher(matcherNode, sequenceList);
                break;
            }
            case SEQUENCE: {
                this.addSequenceMatcher(matcherNode, sequenceList);
                break;
            }
            case REPEAT: {
                this.addRepeatedSequence(matcherNode, sequenceList);
                break;
            }
            case SET: {
                this.addSetMatcher(matcherNode, sequenceList);
                break;
            }
            default: {
                throw new ParseException(this.getTypeErrorMessage(matcherNode));
            }
        }
        return sequenceList;
    }

    private void addRepeatedSequence(ParseTree ast, List<SequenceMatcher> sequenceList) throws ParseException {
        int timesToRepeat = ParseTreeUtils.getFirstRepeatValue(ast);
        SequenceMatcher sequenceToRepeat = this.doCompile(ParseTreeUtils.getLastChild(ast));
        for (int count = 1; count <= timesToRepeat; ++count) {
            sequenceList.add(sequenceToRepeat);
        }
    }

    private void addSequenceMatcher(ParseTree ast, List<SequenceMatcher> sequenceList) throws ParseException {
        for (ParseTree child : ast) {
            this.buildSequenceList(child, sequenceList);
        }
    }

    private void addCaseInsensitiveStringMatcher(ParseTree ast, List<SequenceMatcher> sequenceList) throws ParseException {
        sequenceList.add(MatcherCompilerUtils.createCaseInsensitiveMatcher(ast.getTextValue()));
    }

    private void addStringMatcher(ParseTree ast, List<SequenceMatcher> sequenceList) throws ParseException {
        sequenceList.add(new ByteSequenceMatcher(ast.getTextValue()));
    }

    private void addSetMatcher(ParseTree ast, List<SequenceMatcher> sequenceList) throws ParseException {
        sequenceList.add(MatcherCompilerUtils.createMatcherFromSet(ast, this.byteMatcherFactory));
    }

    private void addRangeMatcher(ParseTree ast, List<SequenceMatcher> sequenceList) throws ParseException {
        sequenceList.add(MatcherCompilerUtils.createRangeMatcher(ast));
    }

    private void addAnyBitmaskMatcher(ParseTree ast, List<SequenceMatcher> sequenceList) throws ParseException {
        sequenceList.add(MatcherCompilerUtils.createAnyBitmaskMatcher(ast));
    }

    private void addAllBitmaskMatcher(ParseTree ast, List<SequenceMatcher> sequenceList) throws ParseException {
        sequenceList.add(MatcherCompilerUtils.createAllBitmaskMatcher(ast));
    }

    private void addAnyMatcher(ParseTree ast, List<SequenceMatcher> sequenceList) throws ParseException {
        sequenceList.add(MatcherCompilerUtils.createAnyMatcher(ast));
    }

    private void addByteMatcher(ParseTree ast, List<SequenceMatcher> sequenceList) throws ParseException {
        sequenceList.add(MatcherCompilerUtils.createByteMatcher(ast));
    }

    @Override
    protected ParseTree joinExpressions(List<ParseTree> expressions) throws ParseException, CompileException {
        return new ChildrenNode(ParseTreeType.SEQUENCE, expressions, false);
    }

    private String getTypeErrorMessage(ParseTree ast) {
        ParseTreeType type = ast.getParseTreeType();
        return String.format("Unknown type %s ", new Object[]{type});
    }
}

