/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import uk.gov.nationalarchives.droid.core.interfaces.filter.Filter;
import uk.gov.nationalarchives.droid.core.interfaces.filter.FilterCriterion;

public final class BasicFilter
implements Filter {
    private final List<FilterCriterion> criteria;
    private boolean enabled;
    private boolean narrowed;

    public BasicFilter() {
        this(null, true);
    }

    public BasicFilter(FilterCriterion criterion) {
        this(Arrays.asList(criterion), true);
    }

    public BasicFilter(List<FilterCriterion> criteria, boolean isNarrowed) {
        this(criteria, isNarrowed, true);
    }

    public BasicFilter(List<FilterCriterion> criteria, boolean isNarrowed, boolean isEnabled) {
        this.criteria = criteria == null ? Collections.EMPTY_LIST : criteria;
        this.narrowed = isNarrowed;
        this.enabled = isEnabled;
    }

    @Override
    public List<FilterCriterion> getCriteria() {
        return this.criteria;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isNarrowed() {
        return this.narrowed;
    }

    @Override
    public boolean hasCriteria() {
        return this.criteria.size() > 0;
    }

    @Override
    public void setNarrowed(boolean isNarrowed) {
        this.narrowed = isNarrowed;
    }

    @Override
    public FilterCriterion getFilterCriterion(int index) {
        return this.criteria.get(index);
    }

    @Override
    public int getNumberOfFilterCriterion() {
        return this.criteria.size();
    }

    @Override
    public Filter clone() {
        return new BasicFilter(new ArrayList<FilterCriterion>(this.criteria), this.narrowed, this.enabled);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(narrowed: " + this.narrowed + " enabled: " + this.enabled + "criteria: " + this.criteria + ')';
    }
}

