/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffFXBase;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;

public class TiffProfileFXL
extends TiffFXBase {
    public TiffProfileFXL() {
        this._profileText = "TIFF-FX (Profile L)";
        this._mimeClass = 1;
    }

    @Override
    public boolean satisfiesThisProfile(IFD ifd) {
        if (!(ifd instanceof TiffIFD)) {
            return false;
        }
        TiffIFD tifd = (TiffIFD)ifd;
        if (!this.satisfiesClass(tifd)) {
            return false;
        }
        if (!this.satisfiesImageWidth(tifd, new int[]{864, 1024, 1216, 1728, 2048, 2432, 2592, 3072, 3456, 3648, 4096, 4864})) {
            return false;
        }
        if (!this.satisfiesCompression(tifd, 10)) {
            return false;
        }
        if (!this.satisfiesPhotometricInterpretation(tifd, new int[]{2, 5, 10})) {
            return false;
        }
        if (!this.satisfiesResolutionUnit(tifd, new int[]{2, 3, -1})) {
            return false;
        }
        if (!this.satisfiesSamplesPerPixel(tifd, new int[]{1, 3, 4})) {
            return false;
        }
        if (!this.satisfiesXResolution(tifd, new int[]{100, 200, 300, 400})) {
            return false;
        }
        NisoImageMetadata niso = tifd.getNisoImageMetadata();
        if (niso.getXSamplingFrequency().toLong() != niso.getYSamplingFrequency().toLong()) {
            return false;
        }
        if (!this.satisfiesIndexed(tifd, new int[]{0, 1})) {
            return false;
        }
        if (!this.satisfiesFillOrder(tifd, new int[]{1, 2})) {
            return false;
        }
        int bps = niso.getBitsPerSample()[0];
        if (bps > 16) {
            return false;
        }
        return tifd.getIndexed() != 1 || niso.getColormapRedValue() != null;
    }
}

