/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.tools.gui;

import ch.docuteam.tools.os.OperatingSystem;
import ch.docuteam.tools.string.StringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class LimitedIntegerTextField
extends JTextField {
    private static final long serialVersionUID = 1L;
    private static final Color BadValueBackgroundColor = Color.RED;
    private String originalText;
    private Integer minValue = null;
    private Integer maxValue = null;
    private final Color defaultBackgroundColor = this.getBackground();

    public static void main(String ... args) {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.add((Component)new LimitedIntegerTextField(), "North");
        f.add((Component)new LimitedIntegerTextField(10, (Integer)100), "South");
        f.setSize(100, 80);
        f.setLocationRelativeTo(null);
        f.setVisible(true);
    }

    public LimitedIntegerTextField() {
        this.setInputConstraints();
        this.setToolTipText("0 <= Num");
    }

    public LimitedIntegerTextField(Integer maxValue) {
        this.maxValue = maxValue;
        this.setColumns(this.maxValue.toString().length());
        this.setInputConstraints();
        this.setToolTipText("0 <= Num <= " + maxValue);
    }

    public LimitedIntegerTextField(Integer minValue, Integer maxValue) {
        if (minValue > maxValue) {
            this.minValue = maxValue;
            this.maxValue = minValue;
        } else {
            this.minValue = minValue;
            this.maxValue = maxValue;
        }
        this.setColumns(this.maxValue.toString().length());
        this.setInputConstraints();
        this.setToolTipText(this.minValue + " <= Num <= " + this.maxValue);
    }

    public Integer getValue() {
        if (this.getText() == null || this.getText().isEmpty()) {
            return null;
        }
        return new Integer(this.getText());
    }

    public void setValue(Byte value) {
        this.setText((String)(value == null ? "" : "" + value));
    }

    public void setValue(Short value) {
        this.setText((String)(value == null ? "" : "" + value));
    }

    public void setValue(Integer value) {
        this.setText((String)(value == null ? "" : "" + value));
    }

    public void setValue(Long value) {
        this.setText((String)(value == null ? "" : "" + value));
    }

    private void setInputConstraints() {
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (e.isTemporary()) {
                    return;
                }
                LimitedIntegerTextField.this.evaluate();
            }

            @Override
            public void focusGained(FocusEvent e) {
                if (e.isTemporary()) {
                    return;
                }
                LimitedIntegerTextField.this.rememberOriginalText();
                LimitedIntegerTextField.this.selectAll();
            }
        });
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LimitedIntegerTextField.this.evaluate();
            }
        });
        this.setDocument(new PlainDocument(){
            private static final long serialVersionUID = 1L;

            @Override
            public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
                if (str == null) {
                    return;
                }
                if (!StringUtil.isNumeric(str)) {
                    OperatingSystem.beep();
                    return;
                }
                if (LimitedIntegerTextField.this.getColumns() != 0 && this.getLength() + str.length() > LimitedIntegerTextField.this.getColumns()) {
                    OperatingSystem.beep();
                    return;
                }
                super.insertString(offset, str, attr);
            }
        });
    }

    private void rememberOriginalText() {
        this.originalText = this.getText();
    }

    private void evaluate() {
        Integer newValue = this.getValue();
        if (newValue == null) {
            this.setBackground(this.defaultBackgroundColor);
        } else if (this.minValue != null && newValue < this.minValue || this.maxValue != null && newValue > this.maxValue) {
            OperatingSystem.beep();
            this.setText(this.originalText);
            this.setBackground(BadValueBackgroundColor);
        } else {
            this.setValue(newValue);
            this.setBackground(this.defaultBackgroundColor);
        }
    }
}

