/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.authentication;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import java.io.File;
import java.net.URL;
import java.util.Timer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.lang.StringUtils;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.provider.AbstractMetadataProvider;
import org.opensaml.saml2.metadata.provider.FilesystemMetadataProvider;
import org.opensaml.saml2.metadata.provider.HTTPMetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallerFactory;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.parse.BasicParserPool;
import org.opensaml.xml.parse.ParserPool;
import org.w3c.dom.Element;

public class SamlMetadataUtils {
    protected static final ExLogger logger = ExLogger.getExLogger(SamlMetadataUtils.class);

    public static EntityDescriptor loadMetadata(URL url, String enityId) {
        EntityDescriptor idpEntityDescriptor = null;
        try {
            HTTPMetadataProvider idpMetaDataProvider = new HTTPMetadataProvider(new Timer(), new HttpClient(), url.toString());
            idpEntityDescriptor = SamlMetadataUtils.loadMetadata((AbstractMetadataProvider)idpMetaDataProvider, enityId);
        }
        catch (Exception e) {
            logger.error("Error retreiving metadata from URL.", e, new String[0]);
            return null;
        }
        return idpEntityDescriptor;
    }

    public static EntityDescriptor loadMetadata(String path, String enityId) {
        EntityDescriptor idpEntityDescriptor = null;
        try {
            FilesystemMetadataProvider idpMetaDataProvider = new FilesystemMetadataProvider(new File(path));
            idpEntityDescriptor = SamlMetadataUtils.loadMetadata((AbstractMetadataProvider)idpMetaDataProvider, enityId);
        }
        catch (Exception e) {
            logger.error("Error retreiving metadata from file.", e, new String[0]);
            return null;
        }
        return idpEntityDescriptor;
    }

    private static EntityDescriptor loadMetadata(AbstractMetadataProvider metadataProvider, String enityId) throws MetadataProviderException, MarshallingException, TransformerFactoryConfigurationError, TransformerException {
        metadataProvider.setRequireValidMetadata(true);
        metadataProvider.setParserPool((ParserPool)new BasicParserPool());
        metadataProvider.initialize();
        if (StringUtils.isBlank((String)enityId)) {
            enityId = SamlMetadataUtils.getEntityId(metadataProvider);
        }
        return metadataProvider.getEntityDescriptor(enityId);
    }

    private static String getEntityId(AbstractMetadataProvider metadataProvider) throws MarshallingException, TransformerFactoryConfigurationError, TransformerException, MetadataProviderException {
        Element element = SamlMetadataUtils.retrieveRootElement(metadataProvider.getMetadata());
        return element.getAttribute("entityID");
    }

    private static Element retrieveRootElement(XMLObject xmlObject) throws MarshallingException, TransformerFactoryConfigurationError, TransformerException {
        MarshallerFactory marshallerFactory = Configuration.getMarshallerFactory();
        Marshaller marshaller = marshallerFactory.getMarshaller(xmlObject);
        return marshaller.marshall(xmlObject);
    }
}

