/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.repository.persistence.digitalentity;

import com.exlibris.core.infra.model.annotation.Searchable;
import com.exlibris.core.infra.svc.api.entityLock.DpsLockable;
import com.exlibris.core.sdk.consts.Enum;
import com.exlibris.core.sdk.interfaces.PidWrapper;
import com.exlibris.core.sdk.strings.StringUtils;
import com.exlibris.repository.persistence.HOwneredEntity;
import com.exlibris.repository.persistence.digitalentity.HDePidMid;
import com.exlibris.repository.persistence.digitalentity.HDeRelation;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ColumnResult;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.SqlResultSetMappings;
import javax.persistence.Transient;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Table;

@Entity
@NamedQueries(value={@NamedQuery(name="getRepExtraData", query="select preservationType, lifeCycle, parentId from HDeControl where pid =:repPid"), @NamedQuery(name="getChildPids", query="select pid from HDeControl where parentId =:parentId"), @NamedQuery(name="getSourceByMdidAndpid", query="select md.value from HDeMetadata md, HDeControl control, HDePidMid pidmid where control.pid = pidmid.pid and pidmid.mid = md.mid and md.mdId =:mdid and control.pid =:pid"), @NamedQuery(name="getFileFormat", query="select formatLibraryId from HDeStreamRef where pid =:pid"), @NamedQuery(name="updateStatusBySip", query="update HDeControl set status=:newStatus where ingestId =:sipId and status=:oldStatus"), @NamedQuery(name="getLinkedFiles", query="select b.parentId, b.pid from HDeControl a, HDeControl b, HDeControl c, HDeControl d where c.pid = a.parentId and d.pid = b.parentId and c.parentId = d.parentId and a.groupId = b.groupId and a.pid = :filePid"), @NamedQuery(name="updateControlInstitutionByParentId", query="UPDATE HDeControl b SET b.owner = :institution WHERE b.parentId in (:pids)"), @NamedQuery(name="updateIeInstitution", query="UPDATE HDeControl b SET b.owner = :institution WHERE b.pid in (:iePids)")})
@SqlResultSetMappings(value={@SqlResultSetMapping(name="ieScalar", columns={@ColumnResult(name="iePid")}), @SqlResultSetMapping(name="repScalar", columns={@ColumnResult(name="repPid")})})
@NamedNativeQueries(value={@NamedNativeQuery(name="getIeControl", query="select * from hdecontrol where objecttype = 'INTELLECTUAL_ENTITY' start with pid = :pid connect by prior parentid = pid", resultClass=HDeControl.class), @NamedNativeQuery(name="getRepControl", query="select * from hdecontrol where objecttype = 'REPRESENTATION' start with pid = :pid connect by prior parentid = pid", resultClass=HDeControl.class), @NamedNativeQuery(name="getIePid", query="select pid as iePid from hdecontrol where objecttype = 'INTELLECTUAL_ENTITY' start with pid = :pid connect by prior parentid = pid", resultSetMapping="ieScalar"), @NamedNativeQuery(name="getRepPid", query="select pid as repPid from hdecontrol where objecttype = 'REPRESENTATION' start with pid = :pid connect by prior parentid = pid", resultSetMapping="repScalar")})
@javax.persistence.Table(name="HDECONTROL")
@Table(appliesTo="HDECONTROL", indexes={@Index(name="HDECONTROL_CREATEDATE", columnNames={"CREATEDATE"}), @Index(name="HDECONTROL_MODIFICATIONDATE", columnNames={"MODIFICATIONDATE"}), @Index(name="HDECONTROL_CMS", columnNames={"CMS_RECORD_ID", "CMS_SYSTEM"}), @Index(name="HDECONTROL_PID_LC_OT", columnNames={"LIFECYCLE", "PID", "OBJECTTYPE"})})
public class HDeControl
extends HOwneredEntity
implements DpsLockable,
PidWrapper {
    private Long id;
    private String pid;
    private Integer version;
    private String label;
    private String note;
    private String batchId;
    private String ingestId;
    private String ingestName;
    private String entityType;
    private String usageType;
    private String partitionA;
    private String partitionB;
    private String partitionC;
    private String preservationType;
    private String controlPreservationType;
    private Enum.ObjectType objectType;
    private Enum.Status status;
    private Calendar statusDate;
    private Enum.LifeCycle lifeCycle;
    private int orderingSequence;
    private int deliveryPriority;
    private String parentId;
    private String groupId;
    private int externalGroupId;
    private boolean additionalRelationships;
    private List pidMids = new ArrayList();
    private List relations;
    private List targetRelations;
    private String createDateStr;
    private String modifyDateStr;
    private String cmsSystem;
    private String cmsRecordId;
    private Integer revision;

    public HDeControl() {
    }

    public HDeControl(Long id, Calendar createDate, Calendar modificationDate, String owner, String creator, String modifiedBy, String pid, String label, String note, String ingestId, String ingestName, String usageType, String partitionA, String partitionB, String partitionC, String preservationType, Enum.ObjectType objectType2, Enum.Status status, Calendar statusDate, int orderingSequence, String cmsRecordId, String cmsSystem, int deliveryPriority) {
        this.setCreateDate(createDate);
        this.setModificationDate(modificationDate);
        this.setId(id);
        this.setOwner(owner);
        this.setCreator(creator);
        this.setModifiedBy(modifiedBy);
        this.pid = pid;
        this.label = label;
        this.note = note;
        this.ingestId = ingestId;
        this.ingestName = ingestName;
        this.usageType = usageType;
        this.partitionA = partitionA;
        this.partitionB = partitionB;
        this.partitionC = partitionC;
        this.preservationType = preservationType;
        this.objectType = objectType2;
        this.status = status;
        this.statusDate = statusDate;
        this.orderingSequence = orderingSequence;
        this.cmsRecordId = cmsRecordId;
        this.cmsSystem = cmsSystem;
        this.deliveryPriority = deliveryPriority;
    }

    public HDeControl(Long id, String pid, String label, Enum.Status status) {
        this.id = id;
        this.pid = pid;
        this.label = label;
        this.status = status;
    }

    @Override
    @Column(name="pid", nullable=false)
    @Searchable
    public String getPid() {
        return this.pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    @Column(length=4000)
    @Searchable
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = StringUtils.truncateStringByBytes(label, 4000);
    }

    @Column(length=512)
    @Searchable
    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = StringUtils.truncateStringByBytes(note, 512);
    }

    @Column
    @Searchable
    public String getBatchId() {
        return this.batchId;
    }

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    @Column
    @Searchable
    @Index(name="HDECONTROL_INGESTID")
    public String getIngestId() {
        return this.ingestId;
    }

    public void setIngestId(String ingestId) {
        this.ingestId = ingestId;
    }

    @Column
    @Searchable
    public String getIngestName() {
        return this.ingestName;
    }

    public void setIngestName(String ingestName) {
        this.ingestName = ingestName;
    }

    @Column
    @Searchable
    public String getEntityType() {
        return this.entityType;
    }

    public void setEntityType(String entityType) {
        this.entityType = entityType;
    }

    @Column
    @Searchable
    public String getUsageType() {
        return this.usageType;
    }

    public void setUsageType(String usageType) {
        this.usageType = usageType;
        if (this.usageType != null) {
            this.usageType = this.usageType.toUpperCase();
        }
    }

    @Column
    @Searchable
    public String getPartitionA() {
        return this.partitionA;
    }

    public void setPartitionA(String partitionA) {
        this.partitionA = partitionA;
    }

    @Column
    @Searchable
    public String getPartitionB() {
        return this.partitionB;
    }

    public void setPartitionB(String partitionB) {
        this.partitionB = partitionB;
    }

    @Column
    @Searchable
    public String getPartitionC() {
        return this.partitionC;
    }

    public void setPartitionC(String partitionC) {
        this.partitionC = partitionC;
    }

    @Column
    @Enumerated(value=EnumType.STRING)
    @Searchable
    @Index(name="HDECONTROL_STATUS")
    public Enum.Status getStatus() {
        return this.status;
    }

    public void setStatus(Enum.Status status) {
        this.status = status;
    }

    @OneToMany(targetEntity=HDeRelation.class, mappedBy="control", cascade={CascadeType.ALL})
    public List getRelations() {
        return this.relations;
    }

    public void setRelations(List relations) {
        this.relations = relations;
    }

    @OneToMany(targetEntity=HDePidMid.class, fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @JoinColumn(name="pid", referencedColumnName="pid", insertable=false, updatable=false)
    public List getPidMids() {
        return this.pidMids;
    }

    public void setPidMids(List pidMids) {
        this.pidMids = pidMids;
    }

    @OneToMany(targetEntity=HDeRelation.class, cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="targetControl")
    public List getTargetRelations() {
        return this.targetRelations;
    }

    public void setTargetRelations(List targetRelations) {
        this.targetRelations = targetRelations;
    }

    @Override
    @Transient
    public String getLockId() {
        return this.pid;
    }

    @Override
    @Transient
    public String getLockType() {
        return "HDeControl";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.entityType == null ? 0 : this.entityType.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.ingestId == null ? 0 : this.ingestId.hashCode());
        result = 31 * result + (this.ingestName == null ? 0 : this.ingestName.hashCode());
        result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
        result = 31 * result + (this.note == null ? 0 : this.note.hashCode());
        result = 31 * result + (this.partitionA == null ? 0 : this.partitionA.hashCode());
        result = 31 * result + (this.partitionB == null ? 0 : this.partitionB.hashCode());
        result = 31 * result + (this.partitionC == null ? 0 : this.partitionC.hashCode());
        result = 31 * result + (this.pid == null ? 0 : this.pid.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.usageType == null ? 0 : this.usageType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HDeControl other = (HDeControl)obj;
        if (this.entityType == null ? other.entityType != null : !this.entityType.equals(other.entityType)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.ingestId == null ? other.ingestId != null : !this.ingestId.equals(other.ingestId)) {
            return false;
        }
        if (this.ingestName == null ? other.ingestName != null : !this.ingestName.equals(other.ingestName)) {
            return false;
        }
        if (this.label == null ? other.label != null : !this.label.equals(other.label)) {
            return false;
        }
        if (this.note == null ? other.note != null : !this.note.equals(other.note)) {
            return false;
        }
        if (this.partitionA == null ? other.partitionA != null : !this.partitionA.equals(other.partitionA)) {
            return false;
        }
        if (this.partitionB == null ? other.partitionB != null : !this.partitionB.equals(other.partitionB)) {
            return false;
        }
        if (this.partitionC == null ? other.partitionC != null : !this.partitionC.equals(other.partitionC)) {
            return false;
        }
        if (this.pid == null ? other.pid != null : !this.pid.equals(other.pid)) {
            return false;
        }
        if (this.status == null ? other.status != null : !this.status.equals((Object)other.status)) {
            return false;
        }
        return !(this.usageType == null ? other.usageType != null : !this.usageType.equals(other.usageType));
    }

    @Column
    @Enumerated(value=EnumType.STRING)
    @Searchable
    public String getPreservationType() {
        return this.preservationType;
    }

    public void setPreservationType(String preservationType) {
        this.preservationType = preservationType;
    }

    @Transient
    public String getControlPreservationType() {
        return this.preservationType.toString();
    }

    public void setControlPreservationType(String controlPreservationType) {
        this.preservationType = controlPreservationType;
        this.controlPreservationType = controlPreservationType;
    }

    @Column
    @Enumerated(value=EnumType.STRING)
    @Searchable
    @Index(name="HDECONTROL_OBJECTTYPE")
    public Enum.ObjectType getObjectType() {
        return this.objectType;
    }

    public void setObjectType(Enum.ObjectType objectType2) {
        this.objectType = objectType2;
    }

    @Column
    @Searchable
    public Calendar getStatusDate() {
        return this.statusDate;
    }

    public void setStatusDate(Calendar statusDate) {
        this.statusDate = statusDate;
    }

    @Column
    @Enumerated(value=EnumType.STRING)
    @Searchable
    @Index(name="HDECONTROL_LIFECYCLE")
    public Enum.LifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    public void setLifeCycle(Enum.LifeCycle lifeCycle) {
        this.lifeCycle = lifeCycle;
    }

    @Column
    @Searchable
    public int getOrderingSequence() {
        return this.orderingSequence;
    }

    public void setOrderingSequence(int orderingSequence) {
        this.orderingSequence = orderingSequence;
    }

    @Column
    @Searchable
    public int getDeliveryPriority() {
        return this.deliveryPriority;
    }

    public void setDeliveryPriority(int deliveryPriority) {
        this.deliveryPriority = deliveryPriority;
    }

    @Column
    @Searchable
    @Index(name="HDECONTROL_PARENTID")
    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    @Column
    @Searchable
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @Column
    @Searchable
    public int getExternalGroupId() {
        return this.externalGroupId;
    }

    public void setExternalGroupId(int externalGroupId) {
        this.externalGroupId = externalGroupId;
    }

    @Column
    @Searchable
    public boolean isAdditionalRelationships() {
        return this.additionalRelationships;
    }

    public void setAdditionalRelationships(boolean additionalRelationships) {
        this.additionalRelationships = additionalRelationships;
    }

    @Transient
    public String getCreateDateStr() {
        if (super.getCreateDate() == null) {
            return "";
        }
        return super.getCreateDate().getTime().toString();
    }

    @Transient
    public String getModifyDateStr() {
        if (super.getModificationDate() == null) {
            return "";
        }
        return super.getModificationDate().getTime().toString();
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    @Column(name="cms_system")
    public String getCmsSystem() {
        return this.cmsSystem;
    }

    public void setCmsSystem(String cmsSystem) {
        this.cmsSystem = cmsSystem;
    }

    @Column(name="cms_record_id")
    public String getCmsRecordId() {
        return this.cmsRecordId;
    }

    public void setCmsRecordId(String cmsRecordId) {
        this.cmsRecordId = cmsRecordId;
    }

    @Transient
    public Integer getRevision() {
        return this.revision;
    }

    public void setRevision(Integer revision) {
        this.revision = revision;
    }

    public HDeControl copy() {
        HDeControl newIE = new HDeControl();
        newIE.setApplication(this.getApplication());
        newIE.setBatchId(this.getBatchId());
        newIE.setCmsRecordId(this.getCmsRecordId());
        newIE.setCmsSystem(this.getCmsSystem());
        if (this.preservationType != null) {
            newIE.setControlPreservationType(this.getControlPreservationType());
        }
        newIE.setCreateDate(Calendar.getInstance());
        newIE.setDeliveryPriority(this.getDeliveryPriority());
        newIE.setEntityType(this.getEntityType());
        newIE.setExternalGroupId(this.getExternalGroupId());
        newIE.setGroupId(this.getGroupId());
        newIE.setIngestId(this.getIngestId());
        newIE.setCreateDateDummy(this.getCreateDateDummy());
        newIE.setIngestName(this.getIngestName());
        newIE.setLabel(this.getLabel());
        newIE.setLifeCycle(this.getLifeCycle());
        newIE.setLockedBy(this.getLockedBy());
        newIE.setLockedDate(this.getLockedDate());
        newIE.setModificationDate(Calendar.getInstance());
        newIE.setModificationDateDummy(this.getModificationDateDummy());
        newIE.setNote(this.getNote());
        newIE.setObjectType(this.getObjectType());
        newIE.setOrderingSequence(this.getOrderingSequence());
        newIE.setOwner(this.getOwner());
        newIE.setParentId(this.getParentId());
        newIE.setPartitionA(this.getPartitionA());
        newIE.setPartitionB(this.getPartitionB());
        newIE.setPartitionC(this.getPartitionC());
        newIE.setPreservationType(this.getPreservationType());
        newIE.setStatus(this.getStatus());
        newIE.setStatusDate(this.getStatusDate());
        newIE.setUsageType(this.getUsageType());
        newIE.setVersion(this.getVersion());
        newIE.setRelations(this.getRelations());
        newIE.setTargetRelations(this.getTargetRelations());
        newIE.setCreator(this.getCreator());
        newIE.setModifiedBy(this.getModifiedBy());
        return newIE;
    }
}

