/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module;

import edu.harvard.hul.ois.jhove.AESAudioMetadata;
import edu.harvard.hul.ois.jhove.Agent;
import edu.harvard.hul.ois.jhove.AgentType;
import edu.harvard.hul.ois.jhove.Checksum;
import edu.harvard.hul.ois.jhove.ChecksumInputStream;
import edu.harvard.hul.ois.jhove.ChecksumType;
import edu.harvard.hul.ois.jhove.Checksummer;
import edu.harvard.hul.ois.jhove.Document;
import edu.harvard.hul.ois.jhove.DocumentType;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.ExternalSignature;
import edu.harvard.hul.ois.jhove.Identifier;
import edu.harvard.hul.ois.jhove.IdentifierType;
import edu.harvard.hul.ois.jhove.InfoMessage;
import edu.harvard.hul.ois.jhove.InternalSignature;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.SignatureType;
import edu.harvard.hul.ois.jhove.SignatureUseType;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import edu.harvard.hul.ois.jhove.module.wave.AssocDataListChunk;
import edu.harvard.hul.ois.jhove.module.wave.BroadcastExtChunk;
import edu.harvard.hul.ois.jhove.module.wave.CartChunk;
import edu.harvard.hul.ois.jhove.module.wave.CueChunk;
import edu.harvard.hul.ois.jhove.module.wave.DataChunk;
import edu.harvard.hul.ois.jhove.module.wave.DataSize64Chunk;
import edu.harvard.hul.ois.jhove.module.wave.ExifInfo;
import edu.harvard.hul.ois.jhove.module.wave.FactChunk;
import edu.harvard.hul.ois.jhove.module.wave.FormatChunk;
import edu.harvard.hul.ois.jhove.module.wave.InstrumentChunk;
import edu.harvard.hul.ois.jhove.module.wave.LabelChunk;
import edu.harvard.hul.ois.jhove.module.wave.LinkChunk;
import edu.harvard.hul.ois.jhove.module.wave.ListInfoChunk;
import edu.harvard.hul.ois.jhove.module.wave.MpegChunk;
import edu.harvard.hul.ois.jhove.module.wave.NoteChunk;
import edu.harvard.hul.ois.jhove.module.wave.PeakEnvelopeChunk;
import edu.harvard.hul.ois.jhove.module.wave.SampleChunk;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class WaveModule
extends ModuleBase {
    private static final String NAME = "WAVE-hul";
    private static final String RELEASE = "1.6";
    private static final int[] DATE = new int[]{2018, 3, 29};
    private static final String[] FORMATS = new String[]{"WAVE", "Audio for Windows", "EBU Technical Specification 3285", "Broadcast Wave Format", "BWF", "EBU Technical Specification 3306", "RF64"};
    private static final String COVERAGE = "WAVE (PCMWAVEFORMAT, WAVEFORMATEX, WAVEFORMATEXTENSIBLE); Broadcast Wave Format (BWF) version 0, 1 and 2; RF64";
    private static final String[] MIMETYPES = new String[]{"audio/vnd.wave", "audio/wav", "audio/wave", "audio/x-wav", "audio/x-wave"};
    private static final String WELLFORMED = null;
    private static final String VALIDITY = null;
    private static final String REPINFO = null;
    private static final String NOTE = "There is no published standard for WAVE files. This module regards a file as valid if it conforms to common usage practices.";
    private static final String RIGHTS = "Copyright 2004-2007 by JSTOR and the President and Fellows of Harvard College. Released under the GNU Lesser General Public License.";
    private static final String RIFF_SIGNATURE = "RIFF";
    private static final String RF64_SIGNATURE = "RF64";
    private static final int RIFF_FORM_TYPE_LENGTH = 4;
    private static final int CHUNK_HEADER_LENGTH = 8;
    public static final long LOOKUP_EXTENDED_DATA_SIZE = 0xFFFFFFFFL;
    protected Map<String, Long> extendedChunkSizes;
    protected Checksummer _ckSummer;
    protected ChecksumInputStream _cstream;
    protected DataInputStream _dstream;
    protected Property _metadata;
    protected List<Property> _propList;
    protected List<Property> _notes;
    protected List<Property> _labels;
    protected List<Property> _labeledText;
    protected List<Property> _samples;
    protected AESAudioMetadata _aesMetadata;
    protected long bytesRemaining;
    protected int _blockAlign;
    protected ExifInfo _exifInfo;
    protected int waveCodec;
    protected long extendedRiffSize;
    protected long extendedSampleLength;
    protected long sampleCount;
    protected long sampleRate;
    protected boolean formatChunkSeen;
    protected boolean factChunkSeen;
    protected boolean dataChunkSeen;
    protected boolean dataSize64ChunkSeen;
    protected boolean instrumentChunkSeen;
    protected boolean mpegChunkSeen;
    protected boolean cartChunkSeen;
    protected boolean broadcastExtChunkSeen;
    protected boolean peakChunkSeen;
    protected boolean linkChunkSeen;
    protected boolean cueChunkSeen;
    protected boolean flagPCMWaveFormat;
    protected boolean flagWaveFormatEx;
    protected boolean flagWaveFormatExtensible;
    protected boolean flagRF64;
    protected boolean firstSampleOffsetMarked;

    public WaveModule() {
        super(NAME, RELEASE, DATE, FORMATS, COVERAGE, MIMETYPES, WELLFORMED, VALIDITY, REPINFO, NOTE, RIGHTS, false);
        this._vendor = Agent.harvardInstance();
        Agent msAgent = new Agent.Builder("Microsoft Corporation", AgentType.COMMERCIAL).address("One Microsoft Way, Redmond, WA 98052-6399").telephone("+1 (800) 426-9400").web("http://www.microsoft.com").build();
        Document doc = new Document("PCMWAVEFORMAT", DocumentType.WEB);
        doc.setIdentifier(new Identifier("http://msdn.microsoft.com/library/default.asp?url=/library/en-us/multimed/htm/_win32_pcmwaveformat_str.asp", IdentifierType.URL));
        doc.setPublisher(msAgent);
        this._specification.add(doc);
        doc = new Document("WAVEFORMATEX", DocumentType.WEB);
        doc.setIdentifier(new Identifier("http://msdn.microsoft.com/library/default.asp?url=/library/en-us/multimed/htm/_win32_waveformatex_str.asp", IdentifierType.URL));
        doc.setPublisher(msAgent);
        this._specification.add(doc);
        doc = new Document("WAVEFORMATEXTENSIBLE", DocumentType.WEB);
        doc.setIdentifier(new Identifier("http://msdn.microsoft.com/library/default.asp?url=/library/en-us/multimed/htm/_win32_waveformatextensible_str.asp", IdentifierType.URL));
        doc.setPublisher(msAgent);
        this._specification.add(doc);
        Agent ebuAgent = new Agent.Builder("European Broadcasting Union", AgentType.COMMERCIAL).address("Casa postale 45, Ancienne Route 17A, CH-1218 Grand-Saconex, Geneva, Switzerland").telephone("+41 (0)22 717 2111").fax("+41 (0)22 747 4000").email("techreview@ebu.ch").web("http://www.ebu.ch").build();
        doc = new Document("Specification of the Broadcast Wave Format (BWF)", DocumentType.REPORT);
        doc.setIdentifier(new Identifier("EBU Technical Specification 3285", IdentifierType.OTHER));
        doc.setIdentifier(new Identifier("https://tech.ebu.ch/docs/tech/tech3285.pdf", IdentifierType.URL));
        doc.setPublisher(ebuAgent);
        doc.setDate("2011-05");
        this._specification.add(doc);
        doc = new Document("MBWF / RF64: An Extended File Format for Audio", DocumentType.REPORT);
        doc.setIdentifier(new Identifier("EBU Technical Specification 3306", IdentifierType.OTHER));
        doc.setIdentifier(new Identifier("https://tech.ebu.ch/docs/tech/tech3306-2009.pdf", IdentifierType.URL));
        doc.setPublisher(ebuAgent);
        doc.setDate("2009-07");
        this._specification.add(doc);
        Agent ietfAgent = new Agent.Builder("IETF", AgentType.STANDARD).web("https://www.ietf.org").build();
        doc = new Document("WAVE and AVI Codec Registries", DocumentType.RFC);
        doc.setPublisher(ietfAgent);
        doc.setDate("1998-06");
        doc.setIdentifier(new Identifier("RFC 2361", IdentifierType.RFC));
        doc.setIdentifier(new Identifier("https://www.ietf.org/rfc/rfc2361.txt", IdentifierType.URL));
        this._specification.add(doc);
        ExternalSignature sig = new ExternalSignature(".wav", SignatureType.EXTENSION, SignatureUseType.OPTIONAL);
        this._signature.add(sig);
        sig = new ExternalSignature(".bwf", SignatureType.EXTENSION, SignatureUseType.OPTIONAL, "For BWF profile");
        this._signature.add(sig);
        sig = new ExternalSignature(".rf64", SignatureType.EXTENSION, SignatureUseType.OPTIONAL, "For RF64 profile");
        this._signature.add(sig);
        sig = new InternalSignature(RIFF_SIGNATURE, SignatureType.MAGIC, SignatureUseType.MANDATORY_IF_APPLICABLE, 0);
        this._signature.add(sig);
        sig = new InternalSignature(RF64_SIGNATURE, SignatureType.MAGIC, SignatureUseType.MANDATORY_IF_APPLICABLE, 0);
        this._signature.add(sig);
        sig = new InternalSignature("WAVE", SignatureType.MAGIC, SignatureUseType.MANDATORY, 8);
        this._signature.add(sig);
        this._bigEndian = false;
    }

    public int parse(InputStream stream, RepInfo info, int parseIndex) throws IOException {
        this.initParse();
        info.setModule((Module)this);
        this._aesMetadata.setPrimaryIdentifier(info.getUri());
        if (info.getURLFlag()) {
            this._aesMetadata.setOtherPrimaryIdentifierType("URI");
        } else {
            this._aesMetadata.setPrimaryIdentifierType("FILE_NAME");
        }
        this._ckSummer = null;
        if (this._je != null && this._je.getChecksumFlag() && info.getChecksum().isEmpty()) {
            this._ckSummer = new Checksummer();
            this._cstream = new ChecksumInputStream(stream, this._ckSummer);
            this._dstream = WaveModule.getBufferedDataStream((InputStream)this._cstream, (int)(this._je != null ? this._je.getBufferSize() : 0));
        } else {
            this._dstream = WaveModule.getBufferedDataStream((InputStream)stream, (int)(this._je != null ? this._je.getBufferSize() : 0));
        }
        try {
            long riffSize;
            String firstFourChars = this.read4Chars(this._dstream);
            if (firstFourChars.equals(RF64_SIGNATURE)) {
                info.setProfile(RF64_SIGNATURE);
                this.flagRF64 = true;
            } else if (!firstFourChars.equals(RIFF_SIGNATURE)) {
                info.setMessage((Message)new ErrorMessage("File does not start with RIFF header", 0L));
                info.setWellFormed(false);
                return 0;
            }
            this.bytesRemaining = riffSize = this.readUnsignedInt(this._dstream);
            String formType = this.read4Chars(this._dstream);
            this.bytesRemaining -= 4L;
            if (!"WAVE".equals(formType)) {
                info.setMessage((Message)new ErrorMessage("Form type in RIFF header is not WAVE", this._nByte));
                info.setWellFormed(false);
                return 0;
            }
            info.setSigMatch(this._name);
            info.setFormat(this._format[0]);
            info.setMimeType(this._mimeType[0]);
            if (this.flagRF64) {
                if (this.readChunk(info) && this.dataSize64ChunkSeen) {
                    if (riffSize == 0xFFFFFFFFL) {
                        if (this.compareUnsignedLongs(this.extendedRiffSize, Long.MAX_VALUE) > 0) {
                            info.setMessage((Message)new InfoMessage("File too large to validate"));
                            info.setWellFormed(-1);
                            return 0;
                        }
                        long bytesRead = riffSize - this.bytesRemaining;
                        this.bytesRemaining = this.extendedRiffSize - bytesRead;
                    }
                } else {
                    info.setMessage((Message)new ErrorMessage("Data Size 64 chunk not in required location", this._nByte));
                    info.setWellFormed(false);
                    return 0;
                }
            }
            while (this.bytesRemaining > 0L && this.readChunk(info)) {
            }
        }
        catch (EOFException eofe) {
            info.setWellFormed(false);
            String subMessage = "Bytes missing = " + this.bytesRemaining;
            if (eofe.getMessage() != null) {
                subMessage = subMessage + "; " + eofe.getMessage();
            }
            info.setMessage((Message)new ErrorMessage("Unexpected end of file", subMessage, this._nByte));
        }
        catch (Exception e) {
            e.printStackTrace();
            info.setWellFormed(false);
            info.setMessage((Message)new ErrorMessage("Exception reading file: " + e.getClass().getName() + ", " + e.getMessage(), this._nByte));
            return 0;
        }
        if (this.sampleCount > 0L) {
            this._aesMetadata.setDuration(this.sampleCount);
        }
        if (!this._labels.isEmpty()) {
            this._propList.add(new Property("Labels", PropertyType.PROPERTY, PropertyArity.LIST, this._labels));
        }
        if (!this._labeledText.isEmpty()) {
            this._propList.add(new Property("LabeledText", PropertyType.PROPERTY, PropertyArity.LIST, this._labeledText));
        }
        if (!this._notes.isEmpty()) {
            this._propList.add(new Property("Notes", PropertyType.PROPERTY, PropertyArity.LIST, this._notes));
        }
        if (!this._samples.isEmpty()) {
            this._propList.add(new Property("Samples", PropertyType.PROPERTY, PropertyArity.LIST, this._samples));
        }
        if (this._exifInfo != null) {
            this._propList.add(this._exifInfo.buildProperty());
        }
        if (!this.formatChunkSeen) {
            info.setMessage((Message)new ErrorMessage("No Format chunk found"));
            info.setWellFormed(false);
            return 0;
        }
        if (!this.dataChunkSeen) {
            info.setMessage((Message)new ErrorMessage("No Data chunk found"));
            info.setWellFormed(false);
            return 0;
        }
        if (this._ckSummer != null) {
            try {
                long n;
                while ((n = this.skipBytes(this._dstream, 2048L, this)) != 0L) {
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            info.setSize(this._cstream.getNBytes());
            info.setChecksum(new Checksum(this._ckSummer.getCRC32(), ChecksumType.CRC32));
            String value = this._ckSummer.getMD5();
            if (value != null) {
                info.setChecksum(new Checksum(value, ChecksumType.MD5));
            }
            if ((value = this._ckSummer.getSHA1()) != null) {
                info.setChecksum(new Checksum(value, ChecksumType.SHA1));
            }
        }
        info.setProperty(this._metadata);
        if (this.flagPCMWaveFormat) {
            info.setProfile("PCMWAVEFORMAT");
        }
        if (this.flagWaveFormatEx) {
            info.setProfile("WAVEFORMATEX");
        }
        if (this.flagWaveFormatExtensible) {
            info.setProfile("WAVEFORMATEXTENSIBLE");
        }
        if (this.broadcastExtChunkSeen && (this.waveCodec == 80 && this.factChunkSeen || this.waveCodec == 1)) {
            info.setProfile("BWF");
        }
        return 0;
    }

    public void markFirstSampleOffset() {
        if (!this.firstSampleOffsetMarked) {
            this.firstSampleOffsetMarked = true;
            this._aesMetadata.setFirstSampleOffset(this._nByte);
        }
    }

    public void setExifInfo(ExifInfo exifInfo) {
        this._exifInfo = exifInfo;
    }

    public void setBlockAlign(int align) {
        this._blockAlign = align;
    }

    public ExifInfo getExifInfo() {
        return this._exifInfo;
    }

    public int getWaveCodec() {
        return this.waveCodec;
    }

    public int getBlockAlign() {
        return this._blockAlign;
    }

    public void addWaveProperty(Property prop) {
        this._propList.add(prop);
    }

    public void addLabel(Property p) {
        this._labels.add(p);
    }

    public void addLabeledText(Property p) {
        this._labeledText.add(p);
    }

    public void addSample(Property p) {
        this._samples.add(p);
    }

    public void addNote(Property p) {
        this._notes.add(p);
    }

    public void addListInfo(List l) {
        this._propList.add(new Property("ListInfo", PropertyType.PROPERTY, PropertyArity.LIST, (Object)l));
    }

    private int compareUnsignedLongs(long x, long y) {
        return (x += Long.MIN_VALUE) < (y += Long.MIN_VALUE) ? -1 : (x == y ? 0 : 1);
    }

    public long readSignedLong(DataInputStream stream) throws IOException {
        return WaveModule.readSignedLong((DataInputStream)stream, (boolean)false, (ModuleBase)this);
    }

    public long readUnsignedInt(DataInputStream stream) throws IOException {
        return WaveModule.readUnsignedInt((DataInputStream)stream, (boolean)false, (ModuleBase)this);
    }

    public int readSignedInt(DataInputStream stream) throws IOException {
        return WaveModule.readSignedInt((DataInputStream)stream, (boolean)false, (ModuleBase)this);
    }

    public int readUnsignedShort(DataInputStream stream) throws IOException {
        return WaveModule.readUnsignedShort((DataInputStream)stream, (boolean)false, (ModuleBase)this);
    }

    public int readSignedShort(DataInputStream stream) throws IOException {
        return WaveModule.readSignedShort((DataInputStream)stream, (boolean)false, (ModuleBase)this);
    }

    public String read4Chars(DataInputStream stream) throws IOException {
        StringBuilder sb = new StringBuilder(4);
        for (int i = 0; i < 4; ++i) {
            int ch = WaveModule.readUnsignedByte((DataInputStream)stream, (ModuleBase)this);
            if (ch == 0) continue;
            sb.append((char)ch);
        }
        return sb.toString();
    }

    public void setWaveCodec(int value) {
        this.waveCodec = value;
    }

    public void addSamples(long samples) {
        this.sampleCount += samples;
    }

    public void setSampleRate(long rate) {
        this.sampleRate = rate;
    }

    public void setPCMWaveFormat(boolean b) {
        this.flagPCMWaveFormat = b;
    }

    public void setWaveFormatEx(boolean b) {
        this.flagWaveFormatEx = b;
    }

    public void setWaveFormatExtensible(boolean b) {
        this.flagWaveFormatExtensible = b;
    }

    protected void initParse() {
        super.initParse();
        this._propList = new LinkedList<Property>();
        this._notes = new LinkedList<Property>();
        this._labels = new LinkedList<Property>();
        this._labeledText = new LinkedList<Property>();
        this._samples = new LinkedList<Property>();
        this.firstSampleOffsetMarked = false;
        this.waveCodec = -1;
        this.sampleCount = 0L;
        this.bytesRemaining = 0L;
        this.extendedRiffSize = 0L;
        this.extendedSampleLength = 0L;
        this.extendedChunkSizes = new HashMap<String, Long>();
        this._metadata = new Property("WAVEMetadata", PropertyType.PROPERTY, PropertyArity.LIST, this._propList);
        this._aesMetadata = new AESAudioMetadata();
        this._aesMetadata.setByteOrder(1);
        this._aesMetadata.setAnalogDigitalFlag("FILE_DIGITAL");
        this._aesMetadata.setFormat("WAVE");
        this._aesMetadata.setUse("OTHER", "JHOVE_validation");
        this._aesMetadata.setDirection("NONE");
        this._propList.add(new Property("AESAudioMetadata", PropertyType.AESAUDIOMETADATA, (Object)this._aesMetadata));
        this.formatChunkSeen = false;
        this.dataChunkSeen = false;
        this.dataSize64ChunkSeen = false;
        this.instrumentChunkSeen = false;
        this.cartChunkSeen = false;
        this.mpegChunkSeen = false;
        this.broadcastExtChunkSeen = false;
        this.peakChunkSeen = false;
        this.linkChunkSeen = false;
        this.cueChunkSeen = false;
        this.flagPCMWaveFormat = false;
        this.flagWaveFormatEx = false;
        this.flagWaveFormatExtensible = false;
        this.flagRF64 = false;
    }

    protected boolean readChunk(RepInfo info) throws IOException {
        Long extendedSize;
        Chunk chunk = null;
        ChunkHeader chunkh = new ChunkHeader(this, info);
        if (!chunkh.readHeader(this._dstream)) {
            return false;
        }
        String chunkID = chunkh.getID();
        long chunkSize = chunkh.getSize();
        if (this.hasExtendedDataSizes() && chunkSize == 0xFFFFFFFFL && (extendedSize = this.extendedChunkSizes.get(chunkID)) != null) {
            chunkh.setSize(extendedSize);
            chunkSize = extendedSize;
        }
        this.bytesRemaining -= 8L;
        if (this.compareUnsignedLongs(this.bytesRemaining, chunkSize) < 0) {
            info.setMessage((Message)new ErrorMessage("Invalid chunk size", this._nByte));
            return false;
        }
        if ("fmt ".equals(chunkID)) {
            if (this.formatChunkSeen) {
                this.dupChunkError(info, "Format");
            }
            chunk = new FormatChunk(this, chunkh, this._dstream);
            this.formatChunkSeen = true;
        } else if ("data".equals(chunkID)) {
            if (!this.formatChunkSeen) {
                info.setMessage((Message)new ErrorMessage("Data chunk appears before Format chunk", this._nByte));
                info.setValid(false);
            }
            if (this.dataChunkSeen) {
                this.dupChunkError(info, "Data");
            }
            chunk = new DataChunk(this, chunkh, this._dstream);
            this.dataChunkSeen = true;
        } else if ("ds64".equals(chunkID)) {
            chunk = new DataSize64Chunk(this, chunkh, this._dstream);
            this.dataSize64ChunkSeen = true;
        } else if ("fact".equals(chunkID)) {
            chunk = new FactChunk(this, chunkh, this._dstream);
            this.factChunkSeen = true;
        } else if ("note".equals(chunkID)) {
            chunk = new NoteChunk(this, chunkh, this._dstream);
        } else if ("labl".equals(chunkID)) {
            chunk = new LabelChunk(this, chunkh, this._dstream);
        } else if ("list".equals(chunkID)) {
            chunk = new AssocDataListChunk(this, chunkh, this._dstream, info);
        } else if ("LIST".equals(chunkID)) {
            chunk = new ListInfoChunk(this, chunkh, this._dstream, info);
        } else if ("smpl".equals(chunkID)) {
            chunk = new SampleChunk(this, chunkh, this._dstream);
        } else if ("inst".equals(chunkID)) {
            if (this.instrumentChunkSeen) {
                this.dupChunkError(info, "Instrument");
            }
            chunk = new InstrumentChunk(this, chunkh, this._dstream);
            this.instrumentChunkSeen = true;
        } else if ("mext".equals(chunkID)) {
            if (this.mpegChunkSeen) {
                this.dupChunkError(info, "MPEG Audio Extension");
            }
            chunk = new MpegChunk(this, chunkh, this._dstream);
            this.mpegChunkSeen = true;
        } else if ("cart".equals(chunkID)) {
            if (this.cartChunkSeen) {
                this.dupChunkError(info, "Cart");
            }
            chunk = new CartChunk(this, chunkh, this._dstream);
            this.cartChunkSeen = true;
        } else if ("bext".equals(chunkID)) {
            if (this.broadcastExtChunkSeen) {
                this.dupChunkError(info, "Broadcast Audio Extension");
            }
            chunk = new BroadcastExtChunk(this, chunkh, this._dstream);
            this.broadcastExtChunkSeen = true;
        } else if ("levl".equals(chunkID)) {
            if (this.peakChunkSeen) {
                this.dupChunkError(info, "Peak Envelope");
            }
            chunk = new PeakEnvelopeChunk(this, chunkh, this._dstream);
            this.peakChunkSeen = true;
        } else if ("link".equals(chunkID)) {
            if (this.linkChunkSeen) {
                this.dupChunkError(info, "Link");
            }
            chunk = new LinkChunk(this, chunkh, this._dstream);
            this.linkChunkSeen = true;
        } else if ("cue ".equals(chunkID)) {
            if (this.cueChunkSeen) {
                this.dupChunkError(info, "Cue Points");
            }
            chunk = new CueChunk(this, chunkh, this._dstream);
            this.cueChunkSeen = true;
        } else {
            info.setMessage((Message)new InfoMessage("Ignored unrecognized chunk: " + chunkID, this._nByte));
        }
        long dataRead = this._nByte;
        if (chunk != null) {
            if (!chunk.readChunk(info)) {
                return false;
            }
        } else {
            this.skipBytes(this._dstream, chunkSize, this);
        }
        dataRead = this._nByte - dataRead;
        this.bytesRemaining -= dataRead;
        if (dataRead < chunkSize) {
            if (this._dstream.available() > 0) {
                info.setMessage((Message)new InfoMessage("Ignored unrecognized data in chunk: " + chunkID, this._nByte));
                this.bytesRemaining -= this.skipBytes(this._dstream, chunkSize - dataRead, this);
            } else {
                throw new EOFException("Truncated chunk = " + chunkID);
            }
        }
        if ((chunkSize & 1L) != 0L) {
            this.bytesRemaining -= this.skipBytes(this._dstream, 1L, this);
        }
        return true;
    }

    public AESAudioMetadata getAESMetadata() {
        return this._aesMetadata;
    }

    protected void dupChunkError(RepInfo info, String chunkName) {
        info.setMessage((Message)new ErrorMessage("Duplicate chunks found for type: " + chunkName, this._nByte));
        info.setValid(false);
    }

    public Property buildBitmaskProperty(int val, String name, String[] oneValueNames, String[] zeroValueNames) {
        if (this._je != null && this._je.getShowRawFlag()) {
            return new Property(name, PropertyType.INTEGER, (Object)val);
        }
        LinkedList<String> slist = new LinkedList<String>();
        try {
            for (int i = 0; i < oneValueNames.length; ++i) {
                String s = (val & 1 << i) != 0 ? oneValueNames[i] : zeroValueNames[i];
                if (s == null || s.length() <= 0) continue;
                slist.add(s);
            }
        }
        catch (Exception e) {
            return null;
        }
        return new Property(name, PropertyType.STRING, PropertyArity.LIST, slist);
    }

    public boolean hasExtendedDataSizes() {
        return this.flagRF64 && this.dataSize64ChunkSeen;
    }

    public void setExtendedRiffSize(long size) {
        this.extendedRiffSize = size;
    }

    public void setExtendedSampleLength(long length) {
        this.extendedSampleLength = length;
    }

    public long getExtendedSampleLength() {
        return this.extendedSampleLength;
    }

    public void addExtendedChunkSize(String chunkId, Long chunkSize) {
        this.extendedChunkSizes.put(chunkId, chunkSize);
    }
}

