/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.io.reader;

import java.io.IOException;
import java.io.InputStream;
import net.byteseek.io.IOUtils;
import net.byteseek.io.reader.AbstractReader;
import net.byteseek.io.reader.cache.LeastRecentlyUsedCache;
import net.byteseek.io.reader.cache.TempFileCache;
import net.byteseek.io.reader.cache.TwoLevelCache;
import net.byteseek.io.reader.cache.WindowCache;
import net.byteseek.io.reader.windows.HardWindow;
import net.byteseek.io.reader.windows.SoftWindow;
import net.byteseek.io.reader.windows.SoftWindowRecovery;
import net.byteseek.io.reader.windows.Window;
import net.byteseek.io.reader.windows.WindowMissingException;
import net.byteseek.utils.ArgUtils;

public class InputStreamReader
extends AbstractReader {
    private final InputStream stream;
    private final boolean closeStreamOnClose;
    private long nextReadPos = 0L;
    private long length = -1L;
    private SoftWindowRecovery recovery;

    public InputStreamReader(InputStream stream) {
        this(stream, 4096, 32, true);
    }

    public InputStreamReader(InputStream stream, boolean closeStreamOnClose) {
        this(stream, 4096, 32, closeStreamOnClose);
    }

    public InputStreamReader(InputStream stream, WindowCache cache) {
        this(stream, 4096, cache, true);
    }

    public InputStreamReader(InputStream stream, WindowCache cache, boolean closeStreamOnClose) {
        this(stream, 4096, cache, closeStreamOnClose);
    }

    public InputStreamReader(InputStream stream, int windowSize) {
        this(stream, windowSize, 32, true);
    }

    public InputStreamReader(InputStream stream, int windowSize, boolean closeStreamOnClose) {
        this(stream, windowSize, 32, closeStreamOnClose);
    }

    public InputStreamReader(InputStream stream, int windowSize, int capacity) {
        this(stream, windowSize, TwoLevelCache.create(new LeastRecentlyUsedCache(capacity), new TempFileCache()), true);
    }

    public InputStreamReader(InputStream stream, int windowSize, int capacity, boolean closeStreamOnClose) {
        this(stream, windowSize, TwoLevelCache.create(new LeastRecentlyUsedCache(capacity), new TempFileCache()), closeStreamOnClose);
    }

    public InputStreamReader(InputStream stream, int windowSize, WindowCache cache) {
        this(stream, windowSize, cache, true);
    }

    public InputStreamReader(InputStream stream, int windowSize, WindowCache cache, boolean closeStreamOnClose) {
        super(windowSize, cache);
        ArgUtils.checkNullObject(stream, "stream");
        this.stream = stream;
        this.closeStreamOnClose = closeStreamOnClose;
    }

    @Override
    public final Window getWindow(long position) throws IOException {
        Window window = super.getWindow(position);
        if (window == null && position < this.nextReadPos && position >= 0L) {
            String message = "Cache failed to provide a window at position: %d but we have already read up to: %d";
            throw new WindowMissingException(String.format("Cache failed to provide a window at position: %d but we have already read up to: %d", position, this.nextReadPos));
        }
        return window;
    }

    @Override
    protected Window createWindow(long windowPos) throws IOException {
        Window window = null;
        while (this.nextReadPos <= windowPos && this.length == -1L) {
            byte[] bytes = new byte[this.windowSize];
            int totalRead = IOUtils.readBytes(this.stream, bytes);
            if (totalRead > 0) {
                window = this.recovery == null ? new HardWindow(bytes, this.nextReadPos, totalRead) : new SoftWindow(bytes, this.nextReadPos, totalRead, this.recovery);
                this.nextReadPos += (long)totalRead;
                if (windowPos >= this.nextReadPos) {
                    this.cache.addWindow(window);
                }
            }
            if (totalRead >= this.windowSize) continue;
            this.length = this.nextReadPos;
        }
        if (windowPos >= this.nextReadPos) {
            window = null;
        }
        return window;
    }

    @Override
    public long length() throws IOException {
        while (this.length == -1L) {
            byte[] bytes = new byte[this.windowSize];
            int totalRead = IOUtils.readBytes(this.stream, bytes);
            if (totalRead > 0) {
                Window lastWindow = this.recovery == null ? new HardWindow(bytes, this.nextReadPos, totalRead) : new SoftWindow(bytes, this.nextReadPos, totalRead, this.recovery);
                this.nextReadPos += (long)totalRead;
                this.cache.addWindow(lastWindow);
            }
            if (totalRead >= this.windowSize) continue;
            this.length = this.nextReadPos;
        }
        return this.length;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.closeStreamOnClose) {
                this.stream.close();
            }
        }
        finally {
            super.close();
        }
    }

    public void setSoftWindowRecovery(SoftWindowRecovery recovery) {
        this.recovery = recovery;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[stream:" + this.stream + " cache:" + this.cache + ']';
    }
}

