/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.tools.file.ssh;

import ch.docuteam.tools.file.ssh.SSHSession;
import ch.docuteam.tools.out.Logger;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

public class SFTPChannel {
    protected String user;
    protected String host;
    protected int port;
    protected String privateKeyFile;
    protected String knownHostsFile;
    private SSHSession sshSession;
    private ChannelSftp channelSftp;

    public SFTPChannel(String user, String host, int port, String privateKeyFile, String knownHostsFile) {
        this.user = user;
        this.host = host;
        this.port = port;
        this.privateKeyFile = privateKeyFile;
        this.knownHostsFile = knownHostsFile;
    }

    public void transferFileLeaveSessionOpen(String sourceFile, String targetFile, String targetDir) throws SftpException, JSchException, IOException {
        File f = new File(sourceFile);
        this.getChannelSftp();
        if (targetDir.startsWith("/")) {
            Logger.debug("change directory to root");
            this.channelSftp.cd("/");
            targetDir = targetDir.substring(1);
        }
        try (FileInputStream inputStream = new FileInputStream(f);){
            for (String dir : targetDir.split("/")) {
                try {
                    Logger.debug("change directory to '" + dir + "'");
                    this.channelSftp.cd(dir);
                }
                catch (SftpException e) {
                    Logger.debug("make and change to directory '" + dir + "'");
                    this.channelSftp.mkdir(dir);
                    this.channelSftp.cd(dir);
                }
            }
            Logger.debug("transferring to '" + targetFile + "'");
            this.channelSftp.put((InputStream)inputStream, targetFile);
            Logger.info("File transfered successfully using SFTP.");
        }
    }

    public void transferFileCloseSession(String sourceFile, String targetFile, String targetDir) throws SftpException, JSchException, IOException {
        this.transferFileLeaveSessionOpen(sourceFile, targetFile, targetDir);
        this.closeConnection();
    }

    public BufferedReader readFile(String targetFile, String targetDir) throws FileNotFoundException, SftpException, JSchException {
        InputStream is = null;
        InputStreamReader isr = null;
        this.getChannelSftp().cd(targetDir);
        is = this.getChannelSftp().get(targetFile);
        try {
            isr = new InputStreamReader(is, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Logger.error("error reading file: " + e);
            isr = new InputStreamReader(is);
        }
        BufferedReader br = new BufferedReader(isr);
        return br;
    }

    public void removeFile(String targetFile, String targetDir) throws FileNotFoundException, SftpException, JSchException {
        this.getChannelSftp().cd(targetDir);
        this.getChannelSftp().rm(targetFile);
    }

    public ChannelSftp getChannelSftp() throws FileNotFoundException, JSchException, SftpException {
        if (this.channelSftp == null) {
            Session session = this.getSSHConnection();
            Channel channel = session.openChannel("sftp");
            this.channelSftp = (ChannelSftp)channel;
            Logger.info("SFTP channel opened");
        }
        if (!this.channelSftp.isConnected()) {
            this.channelSftp.connect();
            Logger.debug("SFTP channel connected");
        }
        Logger.debug("SFTP working directory: '" + this.channelSftp.pwd() + "'");
        return this.channelSftp;
    }

    public Session getSSHConnection() throws FileNotFoundException, JSchException {
        if (this.sshSession == null) {
            this.sshSession = new SSHSession(this.user, this.host, this.port, this.privateKeyFile, this.knownHostsFile);
        }
        return this.sshSession.connect();
    }

    public void closeConnection() {
        if (this.channelSftp != null) {
            this.channelSftp.disconnect();
            Logger.debug("SFTP channel disconnected");
        }
        if (this.sshSession != null) {
            this.sshSession.disconnect();
            Logger.debug("SSH session disconnected");
        }
    }
}

