/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.packer.gui.launcher;

import ch.docuteam.packer.admin.BuildInfo;
import ch.docuteam.packer.gui.PackerConstants;
import ch.docuteam.tools.gui.GridBagPanel;
import ch.docuteam.tools.os.OperatingSystem;
import ch.docuteam.tools.out.Logger;
import ch.docuteam.tools.string.DateFormatter;
import ch.docuteam.tools.translations.I18N;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class AboutView
extends JDialog {
    private static final long serialVersionUID = 1L;
    protected JEditorPane docuteamLink;
    protected JEditorPane licenseLink;

    public AboutView(JFrame owner, String title) {
        super(owner, title, true);
        this.setIconImage(PackerConstants.getImage("DocuteamPacker.png"));
        this.setDefaultCloseOperation(2);
        this.getRootPane().registerKeyboardAction(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutView.this.close();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        this.docuteamLink = new JEditorPane("text/html", "<span style='font-family:Arial'><a href='http://www.docuteam.ch'>docuteam AG</a></span>");
        this.docuteamLink.setEditable(false);
        this.docuteamLink.setOpaque(false);
        this.docuteamLink.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hle) {
                if (HyperlinkEvent.EventType.ACTIVATED.equals(hle.getEventType())) {
                    AboutView.this.openURL(hle.getURL());
                }
            }
        });
        this.licenseLink = new JEditorPane("text/html", "<span style='font-family:Arial'><a href='http://www.gnu.org/licenses'>GNU General Public License</a></span>");
        this.licenseLink.setEditable(false);
        this.licenseLink.setOpaque(false);
        this.licenseLink.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hle) {
                if (HyperlinkEvent.EventType.ACTIVATED.equals(hle.getEventType())) {
                    AboutView.this.openURL(hle.getURL());
                }
            }
        });
    }

    public AboutView(JFrame owner) {
        this(owner, I18N.translate((String)"TitleAbout") + BuildInfo.getProduct());
        GridBagPanel gridBagPanel1 = new GridBagPanel((Border)new EmptyBorder(10, 10, 10, 10), new Insets(5, 5, 5, 5));
        gridBagPanel1.add((Component)new JLabel(PackerConstants.getImageIcon("Logo_docuteam_packer.png")), 0, 0, 0, 2, 13);
        gridBagPanel1.add((Component)new JLabel(BuildInfo.getProduct()), 1, 0, 17);
        gridBagPanel1.add((Component)new JLabel(BuildInfo.getVersion()), 1, 1, 17);
        gridBagPanel1.add((Component)new JLabel(BuildInfo.getLastChange()), 1, 2, 13);
        gridBagPanel1.add((Component)new JLabel("Copyright (C) " + DateFormatter.getCurrentDateTimeString((String)"yyyy") + " by: "), 5, 5, 0, 1, 17);
        gridBagPanel1.add((Component)this.docuteamLink, 5, 2, 13);
        gridBagPanel1.add((Component)new JLabel("License: "), 6, 0, 17);
        gridBagPanel1.add((Component)this.licenseLink, 6, 6, 1, 2, 13);
        gridBagPanel1.add((Component)new JLabel("OS: "), 7, 0, 17);
        gridBagPanel1.add((Component)new JLabel(OperatingSystem.osName() + " " + OperatingSystem.osVersion()), 7, 7, 1, 2, 13);
        gridBagPanel1.add((Component)new JLabel("JVM: "), 8, 0, 17);
        gridBagPanel1.add((Component)new JLabel(System.getProperty("java.vendor") + " " + System.getProperty("java.version")), 8, 8, 1, 2, 13);
        GridBagPanel gridBagPanel2 = new GridBagPanel((Border)new EmptyBorder(10, 10, 10, 10), new Insets(5, 5, 5, 5));
        gridBagPanel2.add((Component)new JLabel("<html><b><u>OpenOffice Installations:</u></b></html>"), 0, 0, 0, 3, 10);
        gridBagPanel2.add((Component)new JLabel("Local:"), 2, 2, 10);
        gridBagPanel2.add((Component)new JLabel("Remote:"), 2, 3, 10);
        gridBagPanel2.add((Component)new JLabel("Windows:"), 3, 1, 13);
        Box box = new Box(1);
        box.add((Component)gridBagPanel1);
        box.add((Component)gridBagPanel2);
        this.add(box);
        this.setPreferredSize(new Dimension(450, 500));
        this.setResizable(true);
        this.pack();
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    protected void openURL(URL url) {
        try {
            Desktop.getDesktop().browse(url.toURI());
        }
        catch (Exception ex) {
            Logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    protected void close() {
        this.setVisible(false);
        this.dispose();
    }
}

