/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.console;

import com.exlibris.core.infra.console.ConsolePage;
import java.lang.management.ManagementFactory;
import java.text.DecimalFormat;
import java.util.Set;
import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InvalidApplicationException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.openmbean.CompositeDataSupport;

public class MemoryPoolInformation
extends ConsolePage {
    private Set<ObjectName> getMemoryPoolObjectNames() {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        return server.queryNames(null, new QueryExp(){
            private static final long serialVersionUID = 5842978752536315905L;

            @Override
            public void setMBeanServer(MBeanServer s) {
            }

            @Override
            public boolean apply(ObjectName name) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
                return name.getDomain().equals("java.lang") && name.getCanonicalName().contains("type=MemoryPool");
            }
        });
    }

    private void printSizes(StringBuilder stringBuilder, long max, long committed, long used) {
        int size = 80;
        stringBuilder.append("<blockquote>|");
        int i = 0;
        while ((long)i < committed * 80L / max) {
            stringBuilder.append('-');
            ++i;
        }
        stringBuilder.append("|committed: ").append(this.getSize(committed)).append("\n");
        stringBuilder.append("+");
        for (i = 0; i < 80; ++i) {
            stringBuilder.append('-');
        }
        stringBuilder.append("+\n");
        stringBuilder.append("|");
        for (i = 0; i < 80; ++i) {
            if ((long)i <= used * 80L / max) {
                stringBuilder.append('/');
                continue;
            }
            if ((long)i == committed * 80L / max) {
                stringBuilder.append('|');
                continue;
            }
            stringBuilder.append(' ');
        }
        stringBuilder.append("| max: ").append(this.getSize(max)).append("\n");
        stringBuilder.append("+");
        for (i = 0; i < 80; ++i) {
            stringBuilder.append('-');
        }
        stringBuilder.append("+\n");
        stringBuilder.append("|");
        i = 0;
        while ((long)i < used * 80L / max) {
            stringBuilder.append('-');
            ++i;
        }
        stringBuilder.append("|used: ").append(this.getSize(used)).append("\n");
        stringBuilder.append("</blockquote>\n");
    }

    private String getSize(long size) {
        double s = size;
        int i = 0;
        while (s > 1024.0) {
            s /= 1024.0;
            ++i;
        }
        String res = new DecimalFormat("0.##").format(s);
        if (i == 0) {
            return res + " bytes";
        }
        if (i == 1) {
            return res + " Kb";
        }
        if (i == 2) {
            return res + " Mb";
        }
        return res + " Gb";
    }

    String printMemoryInfo() throws Exception {
        StringBuilder sb = new StringBuilder();
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        Set<ObjectName> objNames = this.getMemoryPoolObjectNames();
        this.addHeader(sb);
        sb.append("<pre>\n");
        sb.append("<b>Total Memory Pools:</b>").append(objNames.size()).append("\n");
        for (ObjectName memObjName : objNames) {
            sb.append("<blockquote><b>Pool: ").append(server.getAttribute(memObjName, "Name")).append("</b> (");
            String type = (String)server.getAttribute(memObjName, "Type");
            if ("HEAP".equals(type)) {
                sb.append("Heap memory");
            } else if ("NON_HEAP".equals(type)) {
                sb.append("Non-heap memory");
            } else {
                sb.append(type);
            }
            sb.append(')').append("\n");
            CompositeDataSupport support = (CompositeDataSupport)server.getAttribute(memObjName, "PeakUsage");
            sb.append("<blockquote>Peak Usage    :").append(" init:").append(support.get("init")).append(", ").append("used:").append(support.get("used")).append(", ").append("committed:").append(support.get("committed")).append(", ").append("max:").append(support.get("max")).append("<br>\n");
            support = (CompositeDataSupport)server.getAttribute(memObjName, "Usage");
            sb.append("\t\tCurrent Usage :").append(" init:").append(support.get("init")).append(", ").append("used:").append(support.get("used")).append(", ").append("committed:").append(support.get("committed")).append(", ").append("max:").append(support.get("max")).append("<br>\n");
            this.printSizes(sb, (Long)support.get("max"), (Long)support.get("committed"), (Long)support.get("used"));
            sb.append("</blockquote>\n");
            sb.append("</blockquote>\n");
        }
        sb.append("</blockquote></pre>");
        this.addFooter(sb);
        return sb.toString();
    }

    public static void main(String[] args) throws Exception {
        System.out.println(new MemoryPoolInformation().printMemoryInfo());
    }
}

