/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;

public abstract class TiffProfile {
    protected String _profileText;
    protected int _mimeClass = 0;
    private boolean _alreadyOK = false;
    public static final int MIME_GENERIC = 0;
    public static final int MIME_FX = 1;
    public static final int MIME_1314 = 2;

    public final boolean satisfiesProfile(IFD ifd) {
        boolean sp = this.satisfiesThisProfile(ifd);
        this._alreadyOK = false;
        if (sp) {
            this._alreadyOK = true;
        }
        return sp;
    }

    public abstract boolean satisfiesThisProfile(IFD var1);

    public String getText() {
        return this._profileText;
    }

    public void setAlreadyOK(boolean ok) {
        this._alreadyOK = ok;
    }

    public int getMimeClass() {
        return this._mimeClass;
    }

    public boolean isAlreadyOK() {
        return this._alreadyOK;
    }

    protected boolean satisfiesCompression(TiffIFD ifd, int[] values) {
        int compression = ifd.getNisoImageMetadata().getCompressionScheme();
        for (int i = 0; i < values.length; ++i) {
            if (compression != values[i]) continue;
            return true;
        }
        return false;
    }

    protected boolean satisfiesCompression(TiffIFD ifd, int value) {
        int[] values = new int[]{value};
        return this.satisfiesCompression(ifd, values);
    }

    protected boolean satisfiesPhotometricInterpretation(TiffIFD ifd, int[] values) {
        int pInt = ifd.getNisoImageMetadata().getColorSpace();
        for (int i = 0; i < values.length; ++i) {
            if (pInt != values[i]) continue;
            return true;
        }
        return false;
    }

    protected boolean satisfiesPhotometricInterpretation(TiffIFD ifd, int value) {
        int[] values = new int[]{value};
        return this.satisfiesPhotometricInterpretation(ifd, values);
    }

    protected boolean satisfiesResolutionUnit(TiffIFD ifd, int[] values) {
        int ru = ifd.getNisoImageMetadata().getSamplingFrequencyUnit();
        for (int i = 0; i < values.length; ++i) {
            if (ru != values[i]) continue;
            return true;
        }
        return false;
    }

    protected boolean satisfiesResolutionUnit(TiffIFD ifd, int value) {
        int[] values = new int[]{value};
        return this.satisfiesResolutionUnit(ifd, values);
    }

    protected boolean satisfiesXResolution(TiffIFD ifd, int[] values) {
        long xf = ifd.getNisoImageMetadata().getXSamplingFrequency().toLong();
        for (int i = 0; i < values.length; ++i) {
            if (xf != (long)values[i]) continue;
            return true;
        }
        return false;
    }

    protected boolean satisfiesYResolution(TiffIFD ifd, int[] values) {
        long yf = ifd.getNisoImageMetadata().getYSamplingFrequency().toLong();
        for (int i = 0; i < values.length; ++i) {
            if (yf != (long)values[i]) continue;
            return true;
        }
        return false;
    }

    protected boolean satisfiesSamplesPerPixel(TiffIFD ifd, int[] values) {
        int spp = ifd.getNisoImageMetadata().getSamplesPerPixel();
        for (int i = 0; i < values.length; ++i) {
            if (spp != values[i]) continue;
            return true;
        }
        return false;
    }

    protected boolean satisfiesSamplesPerPixel(TiffIFD ifd, int value) {
        int[] values = new int[]{value};
        return this.satisfiesSamplesPerPixel(ifd, values);
    }

    protected boolean satisfiesPlanarConfiguration(TiffIFD ifd, int[] values) {
        int spp = ifd.getNisoImageMetadata().getPlanarConfiguration();
        for (int i = 0; i < values.length; ++i) {
            if (spp != values[i]) continue;
            return true;
        }
        return false;
    }

    protected boolean satisfiesPlanarConfiguration(TiffIFD ifd, int value) {
        int[] values = new int[]{value};
        return this.satisfiesPlanarConfiguration(ifd, values);
    }

    protected boolean satisfiesOrientation(TiffIFD ifd, int[] values) {
        int spp = ifd.getNisoImageMetadata().getOrientation();
        for (int i = 0; i < values.length; ++i) {
            if (spp != values[i]) continue;
            return true;
        }
        return false;
    }

    protected boolean satisfiesOrientation(TiffIFD ifd, int value) {
        int[] values = new int[]{value};
        return this.satisfiesOrientation(ifd, values);
    }

    protected boolean satisfiesImageColorIndicator(TiffIFD ifd, int[] values) {
        int spp = ifd.getImageColorIndicator();
        for (int i = 0; i < values.length; ++i) {
            if (spp != values[i]) continue;
            return true;
        }
        return false;
    }

    protected boolean satisfiesImageColorIndicator(TiffIFD ifd, int value) {
        int[] values = new int[]{value};
        return this.satisfiesImageColorIndicator(ifd, values);
    }

    protected boolean satisfiesNewSubfileType(TiffIFD ifd, long[] values) {
        long spp = ifd.getNewSubfileType();
        for (int i = 0; i < values.length; ++i) {
            if (spp != values[i]) continue;
            return true;
        }
        return false;
    }

    protected boolean satisfiesNewSubfileType(TiffIFD ifd, long value) {
        long[] values = new long[]{value};
        return this.satisfiesNewSubfileType(ifd, values);
    }

    protected boolean satisfiesBackgroundColorIndicator(TiffIFD ifd, int[] values) {
        int spp = ifd.getBackgroundColorIndicator();
        for (int i = 0; i < values.length; ++i) {
            if (spp != values[i]) continue;
            return true;
        }
        return false;
    }

    protected boolean satisfiesBackgroundColorIndicator(TiffIFD ifd, int value) {
        int[] values = new int[]{value};
        return this.satisfiesBackgroundColorIndicator(ifd, values);
    }

    protected boolean satisfiesDotRange(TiffIFD ifd, int minValue, int maxValue) {
        int[] dotRange = ifd.getDotRange();
        if (dotRange == null || dotRange.length < 2) {
            return false;
        }
        return dotRange[0] == minValue || dotRange[1] == maxValue;
    }

    protected boolean satisfiesImageWidth(TiffIFD ifd, int[] values) {
        long iw = ifd.getNisoImageMetadata().getImageWidth();
        for (int i = 0; i < values.length; ++i) {
            if (iw != (long)values[i]) continue;
            return true;
        }
        return false;
    }

    protected boolean satisfiesIndexed(TiffIFD ifd, int[] values) {
        int ix = ifd.getIndexed();
        for (int i = 0; i < values.length; ++i) {
            if (ix != values[i]) continue;
            return true;
        }
        return false;
    }

    protected boolean satisfiesFillOrder(TiffIFD ifd, int[] values) {
        int f = ifd.getFillOrder();
        for (int i = 0; i < values.length; ++i) {
            if (f != values[i]) continue;
            return true;
        }
        return false;
    }
}

