/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.packer.gui.filePreview;

import ch.docuteam.converter.OOConverter;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.packer.gui.filePreview.FileType;
import ch.docuteam.tools.file.FileUtil;
import ch.docuteam.tools.id.UniqueID;
import ch.docuteam.tools.os.SystemProcess;
import ch.docuteam.tools.out.Logger;
import ch.docuteam.tools.string.StringUtil;
import ch.docuteam.tools.translations.I18N;
import com.sun.jimi.core.Jimi;
import com.twelvemonkeys.contrib.exif.EXIFUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.imageio.IIOImage;
import javax.media.jai.JAI;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.SwingViewBuilder;

public class FilePreviewPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String TempPDFFileNameTemplate = FileUtil.getTempFolder() + "/FileConverter/Temp_%s.pdf";
    private static final String TempPNGFileNameTemplate = FileUtil.getTempFolder() + "/FileConverter/Temp_%s.png";
    private static final int DefaultCacheSizeLimit = 100;
    private static final String Tab = "&nbsp;&nbsp;&nbsp;&nbsp;";
    private static List<String> TempPDFFileNames = new Vector<String>();
    private static List<String> TempPNGFileNames = new Vector<String>();
    private static Map<NodeAbstract, FilePreviewPanel> Cache = new HashMap<NodeAbstract, FilePreviewPanel>();
    private static int CacheSizeLimit = 100;
    private static List<NodeAbstract> CacheHitOrder = new ArrayList<NodeAbstract>(CacheSizeLimit);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private FilePreviewPanel(NodeAbstract node) {
        super(new BorderLayout());
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (node == null) {
                Logger.debug((Object)"No item selected");
                this.add(new JPanel());
                return;
            }
            if (!node.fileExists() || !node.canRead()) {
                Logger.debug((Object)("Item '" + node.getLabel() + "' could not be read"));
                JLabel previewNotAvailable = new JLabel(I18N.translate((String)"LabelPreviewCantReadFile"), 0);
                previewNotAvailable.setOpaque(true);
                previewNotAvailable.setBackground(Color.LIGHT_GRAY);
                this.add(previewNotAvailable);
                return;
            }
            String fileName = node.getFile().getAbsolutePath();
            FileType fileType = FileType.check(node);
            switch (fileType) {
                case Folder: {
                    Logger.debug((Object)("Item '" + node.getLabel() + "' identified as folder"));
                    StringBuilder pathString = new StringBuilder("<html>" + I18N.translate((String)"LabelPreviewFolder") + "<br>");
                    int indent = 0;
                    for (String pathElement : StringUtil.split((String)node.getPathString(), (String)"/")) {
                        pathString.append("<br>");
                        for (int i = 0; i < indent; ++i) {
                            pathString.append(Tab);
                        }
                        pathString.append(pathElement);
                        ++indent;
                    }
                    pathString.append("</html>");
                    JLabel previewFolder = new JLabel(pathString.toString());
                    previewFolder.setHorizontalAlignment(0);
                    previewFolder.setOpaque(true);
                    this.add(new JScrollPane(previewFolder));
                    return;
                }
                case Text: {
                    Logger.debug((Object)("Item '" + node.getLabel() + "' identified as text file"));
                    this.add(new JScrollPane(FilePreviewPanel.createTextAreaWithFile(fileName)));
                    return;
                }
                case HTML: {
                    Logger.debug((Object)("Item '" + node.getLabel() + "' identified as HTML file"));
                    JLabel previewHTML = new JLabel();
                    previewHTML.setVerticalAlignment(1);
                    previewHTML.setText(FileUtil.getFileContentAsString((String)fileName));
                    this.add(new JScrollPane(previewHTML));
                    return;
                }
                case PDF: {
                    Logger.debug((Object)("Item '" + node.getLabel() + "' identified as PDF file"));
                    this.add(new PDFPreviewer(this, fileName));
                    return;
                }
                case OOConvertable: {
                    Logger.debug((Object)("Item '" + node.getLabel() + "' identified as OO file"));
                    if (OOConverter.shallNotBeUsed()) {
                        JLabel previewNotAvailable = new JLabel(I18N.translate((String)"LabelOOConverterNotAvailable"), 0);
                        previewNotAvailable.setOpaque(true);
                        previewNotAvailable.setBackground(Color.LIGHT_GRAY);
                        this.add(previewNotAvailable);
                        return;
                    } else {
                        try {
                            String tempPDFFileName = String.format(TempPDFFileNameTemplate, UniqueID.getString());
                            OOConverter.convert2PDF((String)fileName, (String)tempPDFFileName);
                            TempPDFFileNames.add(tempPDFFileName);
                            this.add(new PDFPreviewer(this, tempPDFFileName));
                            return;
                        }
                        catch (Exception e) {
                            Logger.error((Object)e.getMessage(), (Throwable)e);
                            this.add(new JScrollPane(FilePreviewPanel.createPreviewError(e.toString())));
                            return;
                        }
                    }
                }
                case GraphicsNative: {
                    Logger.debug((Object)("Item '" + node.getLabel() + "' identified as native graphics file"));
                    this.add(new GraphicsPreviewer(this, new ImageIcon(fileName)));
                    return;
                }
                case GraphicsImageIO: {
                    Logger.debug((Object)("Item '" + node.getLabel() + "' identified as ImageIO graphics file"));
                    try {
                        IIOImage img = EXIFUtilities.readWithOrientation((File)new File(fileName));
                        this.add(new GraphicsPreviewer(this, new ImageIcon((BufferedImage)img.getRenderedImage())));
                        return;
                    }
                    catch (IOException e) {
                        Logger.error((Object)e.getMessage(), (Throwable)e);
                        this.add(new JScrollPane(FilePreviewPanel.createPreviewError(e.toString())));
                        return;
                    }
                }
                case GraphicsJAIConvertableImageRead: {
                    Logger.debug((Object)("Item '" + node.getLabel() + "' identified as JAI graphics file"));
                    try {
                        this.add(new GraphicsPreviewer(this, new ImageIcon(JAI.create((String)"ImageRead", (Object)fileName).getAsBufferedImage())));
                        return;
                    }
                    catch (Exception e) {
                        Logger.error((Object)e.getMessage(), (Throwable)e);
                        this.add(new JScrollPane(FilePreviewPanel.createPreviewError(e.toString())));
                        return;
                    }
                }
                case GraphicsJIMIConvertable: {
                    Logger.debug((Object)("Item '" + node.getLabel() + "' identified as JIMI graphics file"));
                    try {
                        this.add(new GraphicsPreviewer(this, new ImageIcon(Jimi.getImage((String)fileName))));
                        return;
                    }
                    catch (Exception e) {
                        Logger.error((Object)e.getMessage(), (Throwable)e);
                        this.add(new JScrollPane(FilePreviewPanel.createPreviewError(e.toString())));
                        return;
                    }
                }
                case GraphicsImageMagickConvertable: {
                    Logger.debug((Object)("Item '" + node.getLabel() + "' identified as ImageMagick graphics file"));
                    try {
                        String tempPNGFileName = String.format(TempPNGFileNameTemplate, UniqueID.getString());
                        String[] commandLine = new String[]{"/opt/local/bin/convert", "-compress", "none", fileName, new File(tempPNGFileName).getAbsolutePath()};
                        int errorCode = SystemProcess.execute((String[])commandLine);
                        if (errorCode != 0) {
                            throw new Exception("File conversion of '" + fileName + "' to PNG format returned error code: " + errorCode);
                        }
                        TempPNGFileNames.add(tempPNGFileName);
                        this.add(new GraphicsPreviewer(this, new ImageIcon(tempPNGFileName)));
                        return;
                    }
                    catch (Exception e) {
                        Logger.error((Object)e.getMessage(), (Throwable)e);
                        this.add(new JScrollPane(FilePreviewPanel.createPreviewError(e.toString())));
                        return;
                    }
                }
                default: {
                    Logger.debug((Object)("Item '" + node.getLabel() + "' could not identify type"));
                    this.add(new UnknownFormatPreviewer(fileName));
                    return;
                }
            }
        }
        finally {
            this.validate();
            this.repaint();
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    public static FilePreviewPanel create(NodeAbstract node, JPanel container) {
        if (CacheSizeLimit == 0) {
            return new FilePreviewPanel(node);
        }
        if (Cache.containsKey(node)) {
            Logger.info((Object)("Cache hit: " + node.getLabel()));
            CacheHitOrder.remove(CacheHitOrder.indexOf(node));
        } else {
            if (CacheHitOrder.size() >= CacheSizeLimit) {
                Logger.debug((Object)("Dropped from cache: " + CacheHitOrder.get(0).getLabel()));
                Cache.remove(CacheHitOrder.get(0));
                CacheHitOrder.remove(0);
            }
            Logger.debug((Object)("Insert into cache: " + node.getLabel()));
            Cache.put(node, new FilePreviewPanel(node));
        }
        CacheHitOrder.add(node);
        Logger.debug((Object)("Cache size: " + Cache.size() + "/" + CacheSizeLimit));
        return Cache.get(node);
    }

    public static void setCacheSizeLimit(int newCacheSizeLimit) {
        if (newCacheSizeLimit < 0) {
            throw new IllegalArgumentException("Cache size limit can not be set to a negative value");
        }
        Logger.debug((Object)("Setting FilePreviewer cache size to " + newCacheSizeLimit));
        if (newCacheSizeLimit == 0) {
            Cache.clear();
            CacheHitOrder.clear();
        } else if (newCacheSizeLimit < CacheSizeLimit) {
            for (int i = 0; i < Math.min(CacheSizeLimit - newCacheSizeLimit, CacheHitOrder.size()); ++i) {
                Cache.remove(CacheHitOrder.get(0));
                CacheHitOrder.remove(0);
            }
        }
        CacheSizeLimit = newCacheSizeLimit;
    }

    public static int getCacheSizeLimit() {
        return CacheSizeLimit;
    }

    public static void cleanupTemporaryFiles() {
        PDFPreviewer.cleanup();
        Logger.debug((Object)("PNGs to cleanup: " + TempPNGFileNames.size()));
        for (String s : TempPNGFileNames) {
            Logger.debug((Object)("Cleaning up: " + s));
            try {
                FileUtil.setWritable((String)s);
            }
            catch (Throwable ex) {
                Logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
            try {
                FileUtil.delete((String)s);
            }
            catch (Throwable ex) {
                Logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        Logger.debug((Object)("PDFs to cleanup: " + TempPDFFileNames.size()));
        for (String s : TempPDFFileNames) {
            Logger.debug((Object)("Cleaning up: " + s));
            try {
                FileUtil.setWritable((String)s);
            }
            catch (Throwable ex) {
                Logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
            try {
                FileUtil.delete((String)s);
            }
            catch (Throwable ex) {
                Logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private static JTextArea createPreviewError(String text) {
        JTextArea previewError = new JTextArea();
        previewError.setEditable(false);
        previewError.setLineWrap(true);
        previewError.setWrapStyleWord(true);
        previewError.setBackground(Color.YELLOW);
        previewError.setTabSize(4);
        previewError.setText(text);
        previewError.setCaretPosition(0);
        return previewError;
    }

    private static JTextArea createTextAreaWithFile(String fileName) {
        JTextArea previewText = new JTextArea();
        previewText.setEditable(false);
        previewText.setLineWrap(true);
        previewText.setWrapStyleWord(true);
        previewText.setTabSize(4);
        previewText.setText(FileUtil.getFileContentAsString((String)fileName));
        previewText.setCaretPosition(0);
        return previewText;
    }

    private static float zoomFactorToScaleProportionally(int imageWidth, int imageHeight, int displayWidth, int displayHeight) {
        return Math.min((float)displayWidth / (float)imageWidth, (float)displayHeight / (float)imageHeight);
    }

    private static class PDFPreviewer
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private static List<PDFPreviewer> AllPDFPreviewers = new Vector<PDFPreviewer>(100);
        private final SwingController controller;

        private PDFPreviewer(FilePreviewPanel parent, String fileName) {
            super(new BorderLayout());
            AllPDFPreviewers.add(this);
            this.controller = new SwingController();
            this.controller.setIsEmbeddedComponent(true);
            DocuteamPackerSwingViewBuilder factory = new DocuteamPackerSwingViewBuilder(this.controller);
            JToolBar toolBar = factory.buildCompleteToolBar(true);
            if (toolBar != null) {
                this.add((Component)toolBar, "North");
            }
            this.add((Component)this.controller.getDocumentViewController().getViewContainer(), "Center");
            JPanel statusPanel = factory.buildStatusPanel();
            if (statusPanel != null) {
                this.add((Component)statusPanel, "South");
            }
            this.controller.openDocument(fileName);
            this.controller.setPageFitMode(2, true);
        }

        public static void cleanup() {
            for (PDFPreviewer p : AllPDFPreviewers) {
                p.controller.closeDocument();
                p.controller.dispose();
            }
        }

        protected class DocuteamPackerSwingViewBuilder
        extends SwingViewBuilder {
            public DocuteamPackerSwingViewBuilder(SwingController c) {
                super(c);
            }

            public JToolBar buildCompleteToolBar(boolean embeddableComponent) {
                JToolBar toolbar = new JToolBar();
                this.commonToolBarSetup(toolbar, true);
                this.addToToolBar(toolbar, this.buildPageNavigationToolBar());
                this.addToToolBar(toolbar, this.buildZoomToolBar());
                this.addToToolBar(toolbar, this.buildFitToolBar());
                if (toolbar.getComponentCount() == 0) {
                    toolbar = null;
                }
                if (this.viewerController != null && toolbar != null) {
                    this.viewerController.setCompleteToolBar(toolbar);
                }
                return toolbar;
            }
        }
    }

    private static class GraphicsPreviewer
    extends JLabel {
        private static final long serialVersionUID = 1L;
        private final FilePreviewPanel parent;
        private final ImageIcon previewGraphicsImageIconOriginalSize;

        private GraphicsPreviewer(FilePreviewPanel parent, ImageIcon imageIcon) {
            this.parent = parent;
            this.setVerticalAlignment(0);
            this.setHorizontalAlignment(0);
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    this.wasResized();
                }
            });
            this.previewGraphicsImageIconOriginalSize = imageIcon;
        }

        private void wasResized() {
            this.setIcon(this.scaleProportionallyTo(this.previewGraphicsImageIconOriginalSize, this.parent.getWidth(), this.parent.getHeight()));
            this.repaint();
        }

        private ImageIcon scaleProportionallyTo(ImageIcon originalImageIcon, int displayWidth, int displayHeight) {
            int imageHeight;
            int imageWidth = originalImageIcon.getIconWidth();
            float zoomFactor = FilePreviewPanel.zoomFactorToScaleProportionally(imageWidth, imageHeight = originalImageIcon.getIconHeight(), displayWidth, displayHeight);
            if (zoomFactor >= 1.0f) {
                return originalImageIcon;
            }
            int zoomedImageWidth = (int)(zoomFactor * (float)imageWidth);
            int zoomedImageHeight = (int)(zoomFactor * (float)imageHeight);
            return new ImageIcon(originalImageIcon.getImage().getScaledInstance(zoomedImageWidth, zoomedImageHeight, 2));
        }
    }

    private static class UnknownFormatPreviewer
    extends JPanel {
        private static final long serialVersionUID = 1L;

        private UnknownFormatPreviewer(final String fileName) {
            super(new BorderLayout());
            JButton previewNotAvailableButton = new JButton(I18N.translate((String)"LabelPreviewNotAvailable"));
            previewNotAvailableButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.showFileContentsAsText(fileName);
                }
            });
            previewNotAvailableButton.setBorder(null);
            previewNotAvailableButton.setOpaque(true);
            previewNotAvailableButton.setHorizontalAlignment(0);
            previewNotAvailableButton.setBackground(Color.LIGHT_GRAY);
            this.add((Component)previewNotAvailableButton, "Center");
        }

        private void showFileContentsAsText(String fileName) {
            this.removeAll();
            this.add((Component)new JScrollPane(FilePreviewPanel.createTextAreaWithFile(fileName)), "Center");
            this.validate();
        }
    }
}

