/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.util;

import com.sun.star.lib.util.DisposeListener;
import com.sun.star.lib.util.DisposeNotifier;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class WeakMap
implements Map {
    private final HashMap map = new HashMap();
    private final ReferenceQueue queue = new ReferenceQueue();

    public WeakMap() {
    }

    public WeakMap(Map map) {
        this.putAll(map);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.map.containsValue(object);
    }

    public Object get(Object object) {
        return this.map.get(object);
    }

    public Object put(Object object, Object object2) {
        this.cleanUp();
        return this.map.put(object, new Entry(object, object2, this.queue));
    }

    public Object remove(Object object) {
        this.cleanUp();
        return this.map.remove(object);
    }

    public void putAll(Map map) {
        this.cleanUp();
        for (Map.Entry entry : map.entrySet()) {
            Object k = entry.getKey();
            this.map.put(k, new Entry(k, entry.getValue(), this.queue));
        }
    }

    @Override
    public void clear() {
        this.cleanUp();
        this.map.clear();
    }

    public Set keySet() {
        return this.map.keySet();
    }

    public Collection values() {
        return this.map.values();
    }

    public Set entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean equals(Object object) {
        return this.map.equals(object);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    public static Object getValue(Object object) {
        return object == null ? null : ((WeakReference)object).get();
    }

    private void cleanUp() {
        Entry entry;
        while ((entry = (Entry)this.queue.poll()) != null) {
            Object object = entry.key;
            if (entry != this.map.get(object)) continue;
            this.map.remove(object);
        }
    }

    private static final class Entry
    extends WeakReference
    implements DisposeListener {
        private final Object key;

        @Override
        public void notifyDispose(DisposeNotifier disposeNotifier) {
            this.clear();
            this.enqueue();
        }

        private Entry(Object object, Object object2, ReferenceQueue referenceQueue) {
            super(object2, referenceQueue);
            this.key = object;
            if (object2 instanceof DisposeNotifier) {
                ((DisposeNotifier)object2).addDisposeListener(this);
            }
        }
    }
}

