/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.writer;

import gov.loc.repository.bagit.domain.Bag;
import gov.loc.repository.bagit.domain.Manifest;
import gov.loc.repository.bagit.hash.Hasher;
import gov.loc.repository.bagit.util.PathUtils;
import gov.loc.repository.bagit.writer.BagitFileWriter;
import gov.loc.repository.bagit.writer.FetchWriter;
import gov.loc.repository.bagit.writer.ManifestWriter;
import gov.loc.repository.bagit.writer.MetadataWriter;
import gov.loc.repository.bagit.writer.PayloadWriter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BagWriter {
    private static final Logger logger = LoggerFactory.getLogger(BagWriter.class);
    private static final ResourceBundle messages = ResourceBundle.getBundle("MessageBundle");

    private BagWriter() {
    }

    public static void write(Bag bag, Path outputDir) throws IOException, NoSuchAlgorithmException {
        logger.debug(messages.getString("writing_payload_files"));
        Path bagitDir = PayloadWriter.writeVersionDependentPayloadFiles(bag, outputDir);
        logger.debug(messages.getString("upsert_payload_oxum"));
        String payloadOxum = PathUtils.generatePayloadOxum(PathUtils.getDataDir(bag.getVersion(), outputDir));
        bag.getMetadata().upsertPayloadOxum(payloadOxum);
        logger.debug(messages.getString("writing_bagit_file"));
        BagitFileWriter.writeBagitFile(bag.getVersion(), bag.getFileEncoding(), bagitDir);
        logger.debug(messages.getString("writing_payload_manifests"));
        ManifestWriter.writePayloadManifests(bag.getPayLoadManifests(), bagitDir, bag.getRootDir(), bag.getFileEncoding());
        if (!bag.getMetadata().isEmpty()) {
            logger.debug(messages.getString("writing_bag_metadata"));
            MetadataWriter.writeBagMetadata(bag.getMetadata(), bag.getVersion(), bagitDir, bag.getFileEncoding());
        }
        if (bag.getItemsToFetch().size() > 0) {
            logger.debug(messages.getString("writing_fetch_file"));
            FetchWriter.writeFetchFile(bag.getItemsToFetch(), bagitDir, bag.getRootDir(), bag.getFileEncoding());
        }
        if (bag.getTagManifests().size() > 0) {
            logger.debug(messages.getString("writing_tag_manifests"));
            BagWriter.writeTagManifestFiles(bag.getTagManifests(), bagitDir, bag.getRootDir());
            Set<Manifest> updatedTagManifests = BagWriter.updateTagManifests(bag, outputDir);
            bag.setTagManifests(updatedTagManifests);
            ManifestWriter.writeTagManifests(updatedTagManifests, bagitDir, outputDir, bag.getFileEncoding());
        }
    }

    private static Set<Manifest> updateTagManifests(Bag bag, Path newBagRootDir) throws NoSuchAlgorithmException, IOException {
        HashSet<Manifest> newManifests = new HashSet<Manifest>();
        for (Manifest tagManifest : bag.getTagManifests()) {
            Manifest newManifest = new Manifest(tagManifest.getAlgorithm());
            for (Path originalPath : tagManifest.getFileToChecksumMap().keySet()) {
                Path relativePath = bag.getRootDir().relativize(originalPath);
                Path pathToUpdate = newBagRootDir.resolve(relativePath);
                MessageDigest messageDigest = MessageDigest.getInstance(tagManifest.getAlgorithm().getMessageDigestName());
                String newChecksum = Hasher.hash(pathToUpdate, messageDigest);
                newManifest.getFileToChecksumMap().put(pathToUpdate, newChecksum);
            }
            newManifests.add(newManifest);
        }
        return newManifests;
    }

    private static void writeTagManifestFiles(Set<Manifest> manifests, Path outputDir, Path bagRootDir) throws IOException {
        for (Manifest manifest : manifests) {
            for (Map.Entry<Path, String> entry : manifest.getFileToChecksumMap().entrySet()) {
                Path relativeLocation = bagRootDir.relativize(entry.getKey());
                Path writeTo = outputDir.resolve(relativeLocation);
                Path writeToParent = writeTo.getParent();
                if (Files.exists(writeTo, new LinkOption[0]) || writeToParent == null) continue;
                Files.createDirectories(writeToParent, new FileAttribute[0]);
                Files.copy(entry.getKey(), writeTo, new CopyOption[0]);
            }
        }
    }
}

