/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.tools.id;

import ch.docuteam.tools.file.FileUtil;
import ch.docuteam.tools.file.exception.FileUtilExceptionListException;
import ch.docuteam.tools.out.Logger;
import java.io.File;
import java.io.IOException;

public abstract class NextNumber {
    private static final String LockFilePostfix = ".lock";
    private static final String DefaultFilePath = "./config/NextNumber";
    private static final String DefaultStartValue = "0";
    private static String FilePath = "./config/NextNumber";
    private static String StartValue = "0";

    public static void initialize(String filePath) {
        NextNumber.initialize(filePath, 0L);
    }

    public static void initialize(String filePath, Long startValue) {
        Logger.debug("NextNumber initialize FilePath: '" + filePath + "', StartValue: '" + startValue + "'");
        FilePath = filePath;
        StartValue = startValue.toString();
    }

    public static Long get() throws Exception {
        Logger.debug("Getting...");
        NextNumber.initializeIfNecessary();
        if (!NextNumber.waitUntilUnlocked()) {
            throw new Exception("Timeout!");
        }
        Long num = null;
        try {
            NextNumber.lock();
            num = new Long(FileUtil.getFileContentAsString(FilePath).trim());
            NextNumber.increment(num);
        }
        finally {
            NextNumber.unlock();
        }
        Logger.info("Got: " + num);
        return num;
    }

    public static String getString() throws Exception {
        return NextNumber.get().toString();
    }

    private static void initializeIfNecessary() throws IOException {
        if (!new File(FilePath).exists()) {
            Logger.debug("Initalizing: " + FilePath);
            FileUtil.createFileWithContent(FilePath, StartValue);
        }
    }

    private static void increment(Long num) throws IOException {
        Logger.debug("Incrementing: " + num);
        Long l = num;
        num = num + 1L;
        FileUtil.createFileWithContent(FilePath, num.toString());
        Logger.debug("Incremented: " + num);
    }

    private static boolean waitUntilUnlocked() {
        Logger.debug("Locked?");
        File lockFile = new File(FilePath + LockFilePostfix);
        boolean unlocked = false;
        for (int i = 20; i > 0; --i) {
            if (!lockFile.exists()) {
                unlocked = true;
                break;
            }
            Logger.debug("Retrying: " + i);
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return unlocked;
    }

    private static void lock() throws IOException {
        Logger.debug("Locking...");
        FileUtil.createFileWithContent(FilePath + LockFilePostfix, null);
    }

    private static void unlock() throws FileUtilExceptionListException {
        Logger.debug("Unlocking...");
        FileUtil.delete(FilePath + LockFilePostfix);
    }
}

