/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.io;

import java.io.IOException;
import java.io.InputStream;

public class ByteDoubleArrayInputStream
extends InputStream {
    protected byte[][] buf;
    protected int[] bufOffset;
    protected int pos;
    protected int posIndex;
    protected int mark = 0;
    protected int markIndex = 0;
    protected int count;

    public ByteDoubleArrayInputStream(byte[][] buf) {
        this.buf = buf;
        this.pos = 0;
        this.posIndex = 0;
        this.bufOffset = new int[buf.length];
        for (int i = 0; i < buf.length; ++i) {
            this.bufOffset[i] = this.count;
            this.count += buf[i].length;
        }
    }

    public synchronized int read() {
        float posOffset = this.bufOffset[this.posIndex] + this.pos;
        if (posOffset < (float)this.count) {
            if (posOffset < (float)(this.bufOffset[this.posIndex] + this.buf[this.posIndex].length)) {
                return this.buf[this.posIndex][this.pos++] & 0xFF;
            }
            ++this.posIndex;
            this.pos = 0;
            return this.buf[this.posIndex][this.pos++] & 0xFF;
        }
        return -1;
    }

    public synchronized int read(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.posIndex >= this.buf.length) {
            return -1;
        }
        int posOffset = this.bufOffset[this.posIndex] + this.pos;
        if (posOffset >= this.count) {
            return -1;
        }
        if (posOffset + len > this.count) {
            len = this.count - posOffset;
        }
        if (len <= 0) {
            return 0;
        }
        if (this.pos + len < this.buf[this.posIndex].length) {
            System.arraycopy(this.buf[this.posIndex], this.pos, b, off, len);
            this.pos += len;
        } else {
            int newLength = len;
            int partialOffset = this.buf[this.posIndex].length - this.pos;
            while (newLength > 0) {
                System.arraycopy(this.buf[this.posIndex], this.pos, b, off, partialOffset);
                off += partialOffset;
                this.pos += partialOffset;
                if ((newLength -= partialOffset) == 0) break;
                ++this.posIndex;
                this.pos = 0;
                if (this.pos + newLength < this.buf[this.posIndex].length) {
                    partialOffset = newLength;
                    continue;
                }
                partialOffset = this.buf[this.posIndex].length - this.pos;
            }
        }
        return len;
    }

    public synchronized long skip(long n) {
        if ((long)this.pos + n > (long)this.count) {
            n = this.count - this.pos;
        }
        if (n < 0L) {
            return 0L;
        }
        if ((long)this.pos + n < (long)this.bufOffset[this.posIndex]) {
            this.pos = (int)((long)this.pos + n);
        } else {
            long partialOffset = this.bufOffset[this.posIndex] - this.pos;
            while (n > 0L) {
                ++this.posIndex;
                if ((long)this.pos + (n -= partialOffset) < (long)this.bufOffset[this.posIndex]) {
                    partialOffset = n;
                    continue;
                }
                partialOffset = this.bufOffset[this.posIndex] - this.pos;
            }
        }
        return n;
    }

    public synchronized int available() {
        return this.count - (this.bufOffset[this.posIndex] + this.pos);
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int readAheadLimit) {
        this.mark = this.pos;
        this.markIndex = this.posIndex;
    }

    public synchronized void reset() {
        this.pos = this.mark;
        this.posIndex = this.markIndex;
    }

    public void close() throws IOException {
    }
}

