/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.sparql.query;

import java.util.regex.Matcher;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.parser.sparql.SPARQLQueries;

public class QueryStringUtil {
    @Deprecated(since="2.0")
    public static String getQueryString(String queryString, BindingSet bindings) {
        return QueryStringUtil.getTupleQueryString(queryString, bindings);
    }

    public static String getTupleQueryString(String queryString, BindingSet bindings) {
        if (bindings.size() == 0) {
            return queryString;
        }
        String qry = queryString;
        int b = qry.indexOf(123);
        String select = qry.substring(0, b);
        String where = qry.substring(b);
        for (String name : bindings.getBindingNames()) {
            String replacement = QueryStringUtil.valueToString(bindings.getValue(name));
            if (replacement == null) continue;
            String pattern = "[\\?\\$]" + name + "(?=\\W)";
            select = select.replaceAll(pattern, "(" + Matcher.quoteReplacement(replacement) + " as ?" + name + ")");
            where = where.replaceAll(pattern, Matcher.quoteReplacement(replacement));
        }
        return select + where;
    }

    public static String getUpdateString(String queryString, BindingSet bindings) {
        return QueryStringUtil.getGraphQueryString(queryString, bindings);
    }

    public static String getBooleanQueryString(String queryString, BindingSet bindings) {
        return QueryStringUtil.getGraphQueryString(queryString, bindings);
    }

    public static String getGraphQueryString(String queryString, BindingSet bindings) {
        if (bindings.size() == 0) {
            return queryString;
        }
        String qry = queryString;
        for (String name : bindings.getBindingNames()) {
            String replacement = QueryStringUtil.valueToString(bindings.getValue(name));
            if (replacement == null) continue;
            String pattern = "[\\?\\$]" + name + "(?=\\W)";
            qry = qry.replaceAll(pattern, Matcher.quoteReplacement(replacement));
        }
        return qry;
    }

    public static String valueToString(Value value) {
        return QueryStringUtil.appendValueAsString(new StringBuilder(), value).toString();
    }

    public static StringBuilder appendValueAsString(StringBuilder sb, Value value) {
        if (value == null) {
            return sb.append("UNDEF");
        }
        if (value instanceof IRI) {
            return QueryStringUtil.appendValue(sb, (IRI)value);
        }
        if (value instanceof Literal) {
            return QueryStringUtil.appendValue(sb, (Literal)value);
        }
        throw new IllegalArgumentException("BNode references not supported by SPARQL end-points");
    }

    private static StringBuilder appendValue(StringBuilder sb, IRI uri) {
        sb.append("<").append(uri.stringValue()).append(">");
        return sb;
    }

    private static StringBuilder appendValue(StringBuilder sb, Literal lit) {
        sb.append('\"');
        sb.append(SPARQLQueries.escape((String)lit.getLabel()));
        sb.append('\"');
        if (Literals.isLanguageLiteral((Literal)lit)) {
            sb.append('@');
            sb.append((String)lit.getLanguage().get());
        } else if (!lit.getDatatype().equals((Object)XSD.STRING)) {
            sb.append("^^<");
            sb.append(lit.getDatatype().stringValue());
            sb.append('>');
        }
        return sb;
    }
}

