/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.io.StringWriter;
import javax.xml.transform.TransformerException;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.lib.UnfailingErrorListener;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.serialize.XMLEmitter;
import net.sf.saxon.trans.XPathException;

public class MessageWarner
extends XMLEmitter {
    boolean abort = false;
    String errorCode = null;

    @Override
    public void startDocument(int properties) throws XPathException {
        this.setWriter(new StringWriter());
        this.abort = (properties & 0x4000) != 0;
        super.startDocument(properties);
    }

    @Override
    public void processingInstruction(String target, CharSequence data, Location locationId, int properties) throws XPathException {
        if (target.equals("error-code")) {
            this.errorCode = data.toString();
        } else {
            super.processingInstruction(target, data, locationId, properties);
        }
    }

    @Override
    public void endDocument() throws XPathException {
        UnfailingErrorListener listener = this.getPipelineConfiguration().getErrorListener();
        XPathException de = new XPathException(this.getWriter().toString());
        if (this.errorCode != null) {
            de.setErrorCodeQName(StructuredQName.fromEQName(this.errorCode));
        } else {
            de.setErrorCode("XTMM9000");
        }
        try {
            if (this.abort) {
                listener.error(de);
            } else {
                listener.warning(de);
            }
        }
        catch (TransformerException te) {
            throw XPathException.makeXPathException(te);
        }
    }

    @Override
    public void close() {
    }
}

