/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.TryCatch;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.QNameTest;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLCatch;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;

public class XSLTry
extends StyleElement {
    private Expression select;
    private boolean rollbackOutput = true;
    private List<QNameTest> catchTests = new ArrayList<QNameTest>();
    private List<Expression> catchExprs = new ArrayList<Expression>();

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public boolean mayContainSequenceConstructor() {
        return true;
    }

    @Override
    public void prepareAttributes() throws XPathException {
        String selectAtt = null;
        String rollbackOutputAtt = null;
        AttributeCollection atts = this.getAttributeList();
        block8: for (int a = 0; a < atts.getLength(); ++a) {
            String f;
            switch (f = atts.getNodeName(a).getDisplayName()) {
                case "select": {
                    selectAtt = atts.getValue(a);
                    this.select = this.makeExpression(selectAtt, a);
                    continue block8;
                }
                case "rollback-output": {
                    rollbackOutputAtt = atts.getValue(a);
                    continue block8;
                }
                default: {
                    this.checkUnknownAttribute(atts.getNodeName(a));
                }
            }
        }
        if (rollbackOutputAtt != null) {
            this.rollbackOutput = this.processBooleanAttribute("rollback-output", rollbackOutputAtt);
        }
    }

    @Override
    protected boolean isPermittedChild(StyleElement child) {
        return child instanceof XSLCatch;
    }

    @Override
    public void validate(ComponentDeclaration decl) throws XPathException {
        NodeInfo kid;
        this.select = this.typeCheck("select", this.select);
        boolean foundCatch = false;
        AxisIterator kids = this.iterateAxis((byte)3);
        while ((kid = kids.next()) != null) {
            if (kid instanceof XSLCatch) {
                foundCatch = true;
                continue;
            }
            if (kid instanceof XSLFallback) continue;
            if (foundCatch) {
                this.compileError("xsl:catch elements must come after all other children of xsl:try (excepting xsl:fallback)", "XTSE0010");
            }
            if (this.select == null) continue;
            this.compileError("An " + this.getDisplayName() + " element with a select attribute must be empty", "XTSE3140");
        }
        if (!foundCatch) {
            this.compileError("xsl:try must have at least one xsl:catch child element", "XTSE0010");
        }
    }

    @Override
    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        Expression content = this.compileSequenceConstructor(exec, decl, true);
        if (this.select == null) {
            this.select = content;
        }
        TryCatch expr = new TryCatch(this.select);
        for (int i = 0; i < this.catchTests.size(); ++i) {
            expr.addCatchExpression(this.catchTests.get(i), this.catchExprs.get(i));
        }
        expr.setRollbackOutput(this.rollbackOutput);
        return expr;
    }

    public void addCatchClause(QNameTest nameTest, Expression catchExpr) {
        this.catchTests.add(nameTest);
        this.catchExprs.add(catchExpr);
    }
}

