/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.component;

import com.sun.jimi.core.Jimi;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.JimiReader;
import com.sun.jimi.core.JimiUtils;
import com.sun.jimi.core.component.AreaRenderer;
import com.sun.jimi.core.component.BestFitRenderer;
import com.sun.jimi.core.component.CropRenderer;
import com.sun.jimi.core.component.FitWidthRenderer;
import com.sun.jimi.core.component.ImageCache;
import com.sun.jimi.core.component.JimiImageRenderer;
import com.sun.jimi.core.component.ScaleRenderer;
import com.sun.jimi.core.component.ScrollRenderer;
import com.sun.jimi.core.component.SmartScrollingRenderer;
import com.sun.jimi.core.raster.JimiRasterImage;
import com.sun.jimi.core.util.GraphicsUtils;
import com.sun.jimi.core.util.ProgressListener;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.ImageProducer;
import java.net.URL;

public class JimiCanvas
extends Container {
    public static final int NORTH = 2;
    public static final int SOUTH = 4;
    public static final int EAST = 8;
    public static final int WEST = 16;
    public static final int NORTHEAST = 10;
    public static final int NORTHWEST = 18;
    public static final int SOUTHEAST = 12;
    public static final int SOUTHWEST = 20;
    public static final int CENTER = 0;
    public static final int BEST_FIT = 0;
    public static final int CROP = 1;
    public static final int SCALE = 2;
    public static final int SCROLL = 3;
    public static final int FIT_WIDTH = 4;
    public static final int AREA = 5;
    public static final int MULTIPAGE = 6;
    public static final int PAGED = 7;
    public static final int CROP_AS_NECESSARY = 1;
    public static final int FIT_TO_WIDTH = 4;
    public static final int AREA_AVERAGING = 0;
    public static final int REPLICATE = 1;
    protected transient Image myImage;
    protected transient ImageProducer myImageProducer;
    protected transient URL myImageLocation;
    protected boolean willSizeToFit = true;
    protected int fitWidth = -1;
    protected JimiImageRenderer renderer;
    protected int justificationPolicy = 0;
    protected int resizePolicy = 7;
    protected int scalingPolicy = 1;
    protected ProgressListener progressListener;
    protected int loadingFlags;
    protected boolean aspectAdjust = false;
    protected ImageCache imageCache;

    public JimiCanvas() {
        this.setLayout(new BorderLayout());
        this.setResizePolicy(7);
    }

    public JimiCanvas(int n) {
        this.setLayout(new BorderLayout());
        this.setResizePolicy(n);
    }

    public JimiCanvas(Image image) {
        this();
        this.setImage(image);
    }

    public JimiCanvas(String string) {
        this();
        this.setImagePath(string);
    }

    public JimiCanvas(URL uRL) {
        this();
        this.myImageLocation = uRL;
        this.setImageLocation(uRL);
    }

    private synchronized void doResize() {
        if (this.myImage == null) {
            return;
        }
        this.resize(new Dimension(this.myImage.getWidth(this), this.myImage.getHeight(this)));
        Container container = this.getParent();
        if (container != null) {
            container.invalidate();
            container.layout();
        }
    }

    public void firstImage() {
        if (this.imageCache == null) {
            return;
        }
        JimiRasterImage jimiRasterImage = null;
        while (this.imageCache.hasPreviousImage()) {
            jimiRasterImage = this.imageCache.getPreviousImage();
        }
        if (jimiRasterImage != null) {
            this.setRasterImage(jimiRasterImage);
        }
    }

    public int getFitWidth() {
        return this.fitWidth;
    }

    public Image getImage() {
        if (this.myImage != null) {
            return this.myImage;
        }
        if (this.myImageProducer != null) {
            this.myImage = this.createImage(this.myImageProducer);
            GraphicsUtils.waitForImage(this.myImage);
            return this.myImage;
        }
        return null;
    }

    public URL getImageLocation() {
        return this.myImageLocation;
    }

    public int getJustificationPolicy() {
        return this.justificationPolicy;
    }

    public JimiImageRenderer getRenderer() {
        return this.renderer;
    }

    protected JimiImageRenderer getRenderer(int n) {
        if (n == 3) {
            this.renderer = new ScrollRenderer(this);
        } else if (n == 1) {
            this.renderer = new CropRenderer(this);
        } else if (n == 2) {
            this.renderer = new ScaleRenderer(this);
        } else if (n == 0) {
            this.renderer = new BestFitRenderer(this);
        } else if (n == 4) {
            this.renderer = new FitWidthRenderer(this);
        } else if (n == 5) {
            this.renderer = new AreaRenderer(this);
        } else if (n == 7) {
            this.renderer = new SmartScrollingRenderer(this);
        }
        return this.renderer;
    }

    public int getResizePolicy() {
        return this.resizePolicy;
    }

    public int getScalingPolicy() {
        return this.scalingPolicy;
    }

    public boolean getWillSizeToFit() {
        return this.willSizeToFit;
    }

    public boolean hasNextImage() {
        return this.imageCache == null ? false : this.imageCache.hasNextImage();
    }

    public boolean hasPreviousImage() {
        return this.imageCache == null ? false : this.imageCache.hasPreviousImage();
    }

    public void lastImage() {
        if (this.imageCache == null) {
            return;
        }
        JimiRasterImage jimiRasterImage = null;
        while (this.imageCache.hasNextImage()) {
            jimiRasterImage = this.imageCache.getNextImage();
        }
        if (jimiRasterImage != null) {
            this.setRasterImage(jimiRasterImage);
        }
    }

    protected ImageProducer loadImageProducer(JimiReader jimiReader) {
        if (this.progressListener != null) {
            jimiReader.setProgressListener(this.progressListener);
        }
        this.imageCache = new ImageCache(jimiReader, false);
        return this.imageCache.getNextImage().getImageProducer();
    }

    protected ImageProducer loadImageProducer(String string) {
        try {
            return this.loadImageProducer(Jimi.createJimiReader(string, this.loadingFlags));
        }
        catch (Exception exception) {
            this.showError(exception.toString());
            return null;
        }
    }

    protected ImageProducer loadImageProducer(URL uRL) {
        try {
            return this.loadImageProducer(Jimi.createJimiReader(uRL, this.loadingFlags));
        }
        catch (Exception exception) {
            this.showError(exception.toString());
            return null;
        }
    }

    public void nextImage() {
        try {
            this.setRasterImage(this.imageCache.getNextImage());
        }
        catch (Exception exception) {}
    }

    public void previousImage() {
        try {
            this.setRasterImage(this.imageCache.getPreviousImage());
        }
        catch (Exception exception) {}
    }

    public void setAspectAdjust(boolean bl) {
        this.aspectAdjust = bl;
    }

    public void setFitWidth(int n) {
        this.fitWidth = n;
    }

    public synchronized void setImage(Image image) {
        this.myImage = image;
        if (this.renderer != null) {
            this.renderer.setImage(image);
        }
        this.validate();
    }

    public synchronized void setImageLocation(URL uRL) {
        this.setImageProducer(this.loadImageProducer(uRL));
    }

    public synchronized void setImagePath(String string) {
        this.setImageProducer(this.loadImageProducer(string));
    }

    public void setImageProducer(ImageProducer imageProducer) {
        this.myImage = null;
        if (this.renderer != null) {
            if (imageProducer != null && this.aspectAdjust) {
                try {
                    imageProducer = JimiUtils.aspectAdjust(Jimi.createRasterImage(imageProducer));
                }
                catch (JimiException jimiException) {
                    imageProducer = null;
                }
            }
            this.myImageProducer = imageProducer;
            this.renderer.setImageProducer(imageProducer);
            this.invalidate();
            this.validate();
        }
    }

    public synchronized void setJustificationPolicy(int n) {
        this.justificationPolicy = n;
        if (this.renderer != null) {
            this.renderer.render();
        }
    }

    public void setLoadingFlags(int n) {
        this.loadingFlags = n;
        this.loadingFlags &= 0xFFFFFFFD;
    }

    public void setProgressListener(ProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public void setRasterImage(JimiRasterImage jimiRasterImage) {
        this.setImageProducer(jimiRasterImage == null ? null : jimiRasterImage.getImageProducer());
    }

    public void setRenderer(JimiImageRenderer jimiImageRenderer) {
        this.renderer = jimiImageRenderer;
        if (this.myImage != null) {
            jimiImageRenderer.setImage(this.myImage);
        } else if (this.myImageProducer != null) {
            jimiImageRenderer.setImageProducer(this.myImageProducer);
        }
        this.removeAll();
        this.add(jimiImageRenderer.getContentPane(), "Center");
        this.invalidate();
        this.validate();
    }

    public synchronized void setResizePolicy(int n) {
        this.resizePolicy = n;
        this.renderer = this.getRenderer(this.resizePolicy);
        this.renderer.getContentPane().setBackground(this.getBackground());
        this.renderer.getContentPane().setForeground(this.getForeground());
        this.setRenderer(this.renderer);
        if (this.myImage != null) {
            this.renderer.setImage(this.myImage);
        } else if (this.myImageProducer != null) {
            this.renderer.setImageProducer(this.myImageProducer);
        }
    }

    public synchronized void setScalingPolicy(int n) {
        this.scalingPolicy = n;
    }

    public synchronized void setWillSizeToFit(boolean bl) {
        this.willSizeToFit = bl;
    }

    protected void showError(String string) {
        if (this.progressListener != null) {
            this.progressListener.setAbort(string);
        }
    }
}

