/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.core.office;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.checkerframework.checker.nullness.qual.NonNull;

public class NamedThreadFactory
implements ThreadFactory {
    private static final AtomicInteger THREAD_INDEX = new AtomicInteger(0);
    private final String basename;
    private final boolean daemon;

    public NamedThreadFactory(@NonNull String basename) {
        this(basename, true);
    }

    public NamedThreadFactory(@NonNull String basename, boolean daemon) {
        this.basename = basename;
        this.daemon = daemon;
    }

    @Override
    public @NonNull Thread newThread(@NonNull Runnable runnable) {
        Thread thread = new Thread(runnable, this.basename + "-" + THREAD_INDEX.getAndIncrement());
        thread.setDaemon(this.daemon);
        return thread;
    }
}

