/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.contrib.exif;

public enum Orientation {
    Normal(1),
    FlipH(2),
    Rotate180(3),
    FlipV(4),
    FlipVRotate90(5),
    Rotate270(6),
    FlipHRotate90(7),
    Rotate90(8);

    private final int value;

    private Orientation(int n2) {
        this.value = n2;
    }

    public int value() {
        return this.value;
    }

    public static Orientation fromMetadataOrientation(String string) {
        if (string != null) {
            try {
                return Orientation.valueOf(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string2 = string.toLowerCase();
                for (Orientation orientation : Orientation.values()) {
                    if (!orientation.name().toLowerCase().equals(string2)) continue;
                    return orientation;
                }
            }
        }
        return Normal;
    }

    public static Orientation fromTIFFOrientation(int n) {
        for (Orientation orientation : Orientation.values()) {
            if (orientation.value() != n) continue;
            return orientation;
        }
        return Normal;
    }
}

