/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.local.office;

import com.sun.star.beans.XPropertySet;
import com.sun.star.bridge.XBridge;
import com.sun.star.bridge.XBridgeFactory;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.connection.XConnection;
import com.sun.star.connection.XConnector;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XDesktop;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XEventListener;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.uno.XComponentContext;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jodconverter.local.office.LocalOfficeContext;
import org.jodconverter.local.office.OfficeConnectionEvent;
import org.jodconverter.local.office.OfficeConnectionEventListener;
import org.jodconverter.local.office.OfficeConnectionException;
import org.jodconverter.local.office.OfficeUrl;
import org.jodconverter.local.office.utils.Lo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfficeConnection
implements LocalOfficeContext,
XEventListener {
    private static final AtomicInteger BRIDGE_INDEX = new AtomicInteger();
    private static final Logger LOGGER = LoggerFactory.getLogger(OfficeConnection.class);
    private final OfficeUrl officeUrl;
    private Object desktopService;
    private XComponent bridgeComponent;
    private XComponentContext componentContext;
    private XMultiComponentFactory serviceManager;
    private XComponentLoader componentLoader;
    private final List<OfficeConnectionEventListener> connectionEventListeners;
    private final AtomicBoolean connected = new AtomicBoolean();

    public OfficeConnection(@NonNull OfficeUrl officeUrl) {
        this.officeUrl = officeUrl;
        this.connectionEventListeners = new ArrayList<OfficeConnectionEventListener>();
    }

    public void addConnectionEventListener(@NonNull OfficeConnectionEventListener connectionEventListener) {
        this.connectionEventListeners.add(connectionEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() throws OfficeConnectionException {
        OfficeConnection officeConnection = this;
        synchronized (officeConnection) {
            String connectPart = this.officeUrl.getConnectString();
            LOGGER.debug("Connecting with connectString '{}'", (Object)connectPart);
            try {
                XComponentContext localContext = Bootstrap.createInitialComponentContext(null);
                XMultiComponentFactory localServiceManager = localContext.getServiceManager();
                XConnection connection = this.createConnection(connectPart, localContext, localServiceManager);
                LOGGER.trace("Connection done successfully, creating bridge...");
                XBridge bridge = this.createBridge(connection, localContext, localServiceManager);
                LOGGER.trace("Bridge created successfully, initializing...");
                this.initialize(connectPart, bridge);
                this.connected.set(true);
                LOGGER.info("Connected: '{}'", (Object)connectPart);
                OfficeConnectionEvent connectionEvent = new OfficeConnectionEvent(this);
                this.connectionEventListeners.forEach(listener -> listener.connected(connectionEvent));
            }
            catch (OfficeConnectionException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new OfficeConnectionException(String.format("Connection failed: '%s'; %s", connectPart, ex.getMessage()), connectPart, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        OfficeConnection officeConnection = this;
        synchronized (officeConnection) {
            if (this.bridgeComponent != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Disconnecting from '{}'", (Object)this.officeUrl.getConnectString());
                }
                this.bridgeComponent.dispose();
            }
        }
    }

    public void disposing(@NonNull EventObject eventObject) {
        if (this.connected.compareAndSet(true, false)) {
            this.componentContext = null;
            this.serviceManager = null;
            this.componentLoader = null;
            this.desktopService = null;
            this.bridgeComponent = null;
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Disconnected from '{}'", (Object)this.officeUrl.getConnectString());
            }
            OfficeConnectionEvent connectionEvent = new OfficeConnectionEvent(this);
            this.connectionEventListeners.forEach(listener -> listener.disconnected(connectionEvent));
        }
    }

    @Override
    public @Nullable XComponentContext getComponentContext() {
        return this.componentContext;
    }

    @Override
    public @Nullable XMultiComponentFactory getServiceManager() {
        return this.serviceManager;
    }

    @Override
    public @Nullable XComponentLoader getComponentLoader() {
        return this.componentLoader;
    }

    @Override
    public @Nullable XDesktop getDesktop() {
        if (this.desktopService == null) {
            return null;
        }
        return Lo.qiOptional(XDesktop.class, this.desktopService).orElse(null);
    }

    public boolean isConnected() {
        return this.connected.get();
    }

    private XConnection createConnection(String connectPart, XComponentContext context, XMultiComponentFactory factory) throws Exception {
        XConnector connector = Lo.qi(XConnector.class, factory.createInstanceWithContext("com.sun.star.connection.Connector", context));
        LOGGER.trace("Connector created successfully, trying to connect...");
        return connector.connect(connectPart);
    }

    private XBridge createBridge(XConnection connection, XComponentContext context, XMultiComponentFactory factory) throws Exception {
        XBridgeFactory bridgeFactory = Lo.qi(XBridgeFactory.class, factory.createInstanceWithContext("com.sun.star.bridge.BridgeFactory", context));
        return bridgeFactory.createBridge("jodconverter_" + BRIDGE_INDEX.getAndIncrement(), this.officeUrl.getUnoUrl().getProtocolAndParametersAsString(), connection, null);
    }

    private void initialize(String connectPart, XBridge bridge) throws Exception {
        this.bridgeComponent = Lo.qi(XComponent.class, bridge);
        this.bridgeComponent.addEventListener((XEventListener)this);
        String rootOid = this.officeUrl.getUnoUrl().getRootOid();
        Object bridgeInstance = bridge.getInstance(rootOid);
        if (bridgeInstance == null) {
            throw new OfficeConnectionException("Server didn't provide an instance for '" + rootOid + "'", connectPart);
        }
        XMultiComponentFactory officeMultiComponentFactory = Lo.qi(XMultiComponentFactory.class, bridgeInstance);
        XPropertySet properties = Lo.qi(XPropertySet.class, officeMultiComponentFactory);
        this.componentContext = Lo.qi(XComponentContext.class, properties.getPropertyValue("DefaultContext"));
        this.serviceManager = this.componentContext.getServiceManager();
        this.desktopService = officeMultiComponentFactory.createInstanceWithContext("com.sun.star.frame.Desktop", this.componentContext);
        this.componentLoader = Lo.qiOptional(XComponentLoader.class, this.desktopService).orElseThrow(() -> new OfficeConnectionException("Could not create a desktop service", connectPart));
    }
}

