/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.tools.out;

import ch.docuteam.tools.id.UniqueID;
import ch.docuteam.tools.out.Logger;
import ch.docuteam.tools.string.DateFormatter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;

public abstract class LogFile {
    public static final String CommentStartString = "#";
    private static final String FileNameExtension = ".txt";
    private static String fileName = null;

    public static void initializeAppend(String initFileName) {
        LogFile.initialize(initFileName, true);
    }

    public static void initializeEmpty(String initFileName) {
        LogFile.initialize(initFileName, false);
    }

    public static void initializeNewVersion(String initFileName) {
        String fileName;
        int suffixPos = initFileName.lastIndexOf(".");
        if (suffixPos == -1) {
            fileName = initFileName + "_" + UniqueID.getString();
        } else {
            String suffix = initFileName.substring(suffixPos + 1);
            String rest = initFileName.substring(0, suffixPos);
            fileName = rest + "_" + UniqueID.getString() + "." + suffix;
        }
        LogFile.initializeEmpty(fileName);
    }

    public static void writeln() throws IOException {
        LogFile.write("\n");
    }

    public static void writeln(Object o) throws IOException {
        LogFile.write("\n" + (o == null ? "null" : o.toString()));
    }

    public static void write() throws IOException {
        LogFile.write("");
    }

    public static void write(Object o) throws IOException {
        LogFile.write(o == null ? "null" : o.toString());
    }

    public static String getFileName() {
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initialize(String initFileName, Boolean append) {
        fileName = initFileName;
        if (!fileName.endsWith(FileNameExtension)) {
            fileName = fileName + FileNameExtension;
        }
        OutputStreamWriter fileWriter = null;
        try {
            new File(fileName).getParentFile().mkdirs();
            fileWriter = new FileWriter(fileName, (boolean)append);
            LogFile.writeSeparatorLine();
            LogFile.writeTimeStamp();
            LogFile.writeSeparatorLine();
        }
        catch (IOException e) {
            Logger.error(e.getMessage(), e);
            fileName = null;
        }
        finally {
            try {
                if (fileWriter != null) {
                    fileWriter.close();
                }
            }
            catch (IOException e1) {
                Logger.error(e1.getMessage(), e1);
            }
        }
    }

    private static void write(String string) throws IOException {
        if (fileName == null) {
            throw new IOException("Can't write to LogFile because the LogFile is not initialized.");
        }
        try (FileWriter fileWriter = new FileWriter(fileName, true);){
            fileWriter.append(string);
        }
    }

    private static void writeSeparatorLine() throws IOException {
        LogFile.writeln("#================================================================================");
    }

    private static void writeTimeStamp() throws IOException {
        LogFile.writeln("#==========\t\t" + DateFormatter.getCurrentDateTimeString("dd.MM.yyyy HH:mm:ss"));
    }
}

