/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.string;

import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.model.vocabulary.FN;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;
import org.eclipse.rdf4j.query.algebra.evaluation.util.QueryEvaluationUtility;

public class Concat
implements Function {
    @Override
    public String getURI() {
        return FN.CONCAT.toString();
    }

    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length == 0) {
            throw new ValueExprEvaluationException("CONCAT requires at least 1 argument, got " + args.length);
        }
        StringBuilder concatBuilder = new StringBuilder();
        String commonLanguageTag = null;
        boolean useLanguageTag = true;
        for (Value arg : args) {
            Literal lit;
            if (arg instanceof Literal) {
                lit = (Literal)arg;
                if (!QueryEvaluationUtility.isStringLiteral(lit)) {
                    throw new ValueExprEvaluationException("unexpected datatype for CONCAT operand: " + lit);
                }
                if (useLanguageTag && Literals.isLanguageLiteral((Literal)lit)) {
                    if (commonLanguageTag == null) {
                        commonLanguageTag = (String)lit.getLanguage().get();
                    } else if (!commonLanguageTag.equals(lit.getLanguage().orElse(null))) {
                        commonLanguageTag = null;
                        useLanguageTag = false;
                    }
                } else {
                    useLanguageTag = false;
                }
            } else {
                throw new ValueExprEvaluationException("unexpected argument type for CONCAT operator: " + arg);
            }
            concatBuilder.append(lit.getLabel());
        }
        Literal result = useLanguageTag ? valueFactory.createLiteral(concatBuilder.toString(), commonLanguageTag) : valueFactory.createLiteral(concatBuilder.toString());
        return result;
    }
}

