/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.matcher.bytes;

import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import net.byteseek.io.reader.WindowReader;
import net.byteseek.io.reader.windows.Window;
import net.byteseek.matcher.bytes.InvertibleMatcher;
import net.byteseek.utils.ArgUtils;
import net.byteseek.utils.ByteUtils;

public final class SetBinarySearchMatcher
extends InvertibleMatcher {
    private final byte[] bytesToMatch;

    public SetBinarySearchMatcher(Set<Byte> bytes, boolean inverted) {
        super(inverted);
        ArgUtils.checkNullOrEmptyCollection(bytes, "bytes");
        this.bytesToMatch = ByteUtils.toArray(bytes);
        Arrays.sort(this.bytesToMatch);
    }

    @Override
    public boolean matches(byte theByte) {
        return Arrays.binarySearch(this.bytesToMatch, theByte) >= 0 ^ this.inverted;
    }

    @Override
    public boolean matches(WindowReader reader, long matchPosition) throws IOException {
        Window window = reader.getWindow(matchPosition);
        return window == null ? false : Arrays.binarySearch(this.bytesToMatch, window.getByte(reader.getWindowOffset(matchPosition))) >= 0 ^ this.inverted;
    }

    @Override
    public boolean matches(byte[] bytes, int matchPosition) {
        if (matchPosition >= bytes.length || matchPosition < 0) {
            return false;
        }
        return Arrays.binarySearch(this.bytesToMatch, bytes[matchPosition]) >= 0 ^ this.inverted;
    }

    @Override
    public boolean matchesNoBoundsCheck(byte[] bytes, int matchPosition) {
        return Arrays.binarySearch(this.bytesToMatch, bytes[matchPosition]) >= 0 ^ this.inverted;
    }

    @Override
    public byte[] getMatchingBytes() {
        if (this.inverted) {
            byte[] invertedValues = new byte[this.getNumberOfMatchingBytes()];
            int byteIndex = 0;
            for (int value = 0; value < 256; ++value) {
                if (!this.matches((byte)value)) continue;
                invertedValues[byteIndex++] = (byte)value;
            }
            return invertedValues;
        }
        return (byte[])this.bytesToMatch.clone();
    }

    @Override
    public int getNumberOfMatchingBytes() {
        return this.inverted ? 256 - this.bytesToMatch.length : this.bytesToMatch.length;
    }

    @Override
    public String toRegularExpression(boolean prettyPrint) {
        StringBuilder regularExpression = new StringBuilder();
        if (this.inverted) {
            regularExpression.append('^');
        }
        regularExpression.append('[').append(ByteUtils.bytesToString(prettyPrint, this.bytesToMatch)).append(']');
        return regularExpression.toString();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[bytes:" + ByteUtils.toList(this.bytesToMatch) + " inverted: " + this.inverted + ']';
    }
}

