/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.signature;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import uk.gov.nationalarchives.droid.core.signature.xml.SimpleElement;

public class FileFormat
extends SimpleElement {
    private int identifier;
    private String name;
    private String version;
    private String puid;
    private final List<Integer> internalSigIDs = new ArrayList<Integer>();
    private final List<String> extensions = new ArrayList<String>();
    private final Set<String> extensionLookup = new HashSet<String>();
    private final List<Integer> hasPriorityOver = new ArrayList<Integer>();
    private String mimeType;

    public final void setInternalSignatureID(String theID) {
        this.internalSigIDs.add(Integer.parseInt(theID));
    }

    public final void removeInternalSignatureID(int id) {
        this.internalSigIDs.remove(id);
    }

    public final List<Integer> clearSignatures() {
        ArrayList<Integer> oldSignatureIDs = new ArrayList<Integer>(this.internalSigIDs);
        this.internalSigIDs.clear();
        return oldSignatureIDs;
    }

    public final void setExtension(String theExtension) {
        this.extensions.add(theExtension);
        this.extensionLookup.add(theExtension.toUpperCase(Locale.ENGLISH));
    }

    public final void setHasPriorityOverFileFormatID(String theID) {
        this.hasPriorityOver.add(Integer.parseInt(theID));
    }

    public final void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    @Override
    public final void setAttributeValue(String theName, String theValue) {
        if ("ID".equals(theName)) {
            this.identifier = Integer.parseInt(theValue);
        } else if ("Name".equals(theName)) {
            this.name = theValue;
        } else if ("Version".equals(theName)) {
            this.version = theValue;
        } else if ("PUID".equals(theName)) {
            this.puid = theValue;
        } else if ("MIMEType".equals(theName)) {
            this.mimeType = theValue;
        } else {
            this.unknownAttributeWarning(this.name, this.getElementName());
        }
    }

    public final int getNumInternalSignatures() {
        return this.internalSigIDs.size();
    }

    public final int getNumExtensions() {
        return this.extensions.size();
    }

    public final int getNumHasPriorityOver() {
        return this.hasPriorityOver.size();
    }

    public List<Integer> getFormatIdsHasPriorityOver() {
        return this.hasPriorityOver;
    }

    public final int getInternalSignatureID(int theIndex) {
        return this.internalSigIDs.get(theIndex);
    }

    public final String getMimeType() {
        return this.mimeType == null ? "" : this.mimeType;
    }

    public final String getExtension(int theIndex) {
        return this.extensions.get(theIndex);
    }

    public final List<String> getExtensions() {
        return this.extensions;
    }

    public final int getHasPriorityOver(int theIndex) {
        return this.hasPriorityOver.get(theIndex);
    }

    public final int getID() {
        return this.identifier;
    }

    public final String getName() {
        return this.name;
    }

    public final String getVersion() {
        return this.version;
    }

    public final String getPUID() {
        return this.puid;
    }

    public final boolean hasMatchingExtension(String theExtension) {
        return this.extensionLookup.contains(theExtension.toUpperCase(Locale.ENGLISH));
    }

    public final boolean hasExtensionMismatch(String theExtension) {
        return this.extensions.size() == 0 ? false : !this.hasMatchingExtension(theExtension);
    }
}

