/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove;

import edu.harvard.hul.ois.jhove.OutputHandler;
import java.util.Date;
import java.util.GregorianCalendar;
import org.openpreservation.jhove.ReleaseDetails;

public final class App {
    private static final String NAME = "JHOVE";
    private static final String USAGE = "java JHOVE [-c config] [-m module] [-h handler] [-e encoding] [-H handler] [-o output] [-x saxclass] [-t tempdir] [-b bufsize] [-l loglevel] [[-krs] dir-file-or-uri [...]]";
    private final Date _date;
    private final String _name;
    private String _release;
    private final String _rights;
    private final String _usage;

    public App(String name, String release, int[] date, String usage, String rights) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(date[0], date[1] - 1, date[2]);
        this._name = name;
        this._release = release;
        this._date = calendar.getTime();
        this._usage = usage;
        this._rights = rights;
    }

    private App(String name, ReleaseDetails details) {
        this._name = name;
        this._release = details.getVersion();
        this._date = details.getBuildDate();
        this._usage = USAGE;
        this._rights = details.getRights();
    }

    public static App newAppWithName(String name) {
        return new App(name, ReleaseDetails.getInstance());
    }

    public Date getDate() {
        return this._date;
    }

    public String getName() {
        return this._name;
    }

    public String getRelease() {
        return this._release;
    }

    public String getRights() {
        return this._rights;
    }

    public String getUsage() {
        return this._usage;
    }

    public void show(OutputHandler handler) {
        handler.show(this);
    }
}

