/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.conformance;

import gov.loc.repository.bagit.conformance.BagitWarning;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface EncodingChecker {
    public static final Logger logger = LoggerFactory.getLogger(EncodingChecker.class);
    public static final ResourceBundle messages = ResourceBundle.getBundle("MessageBundle");

    public static void checkEncoding(Charset encoding, Set<BagitWarning> warnings, Collection<BagitWarning> warningsToIgnore) {
        if (!warningsToIgnore.contains((Object)BagitWarning.TAG_FILES_ENCODING) && !StandardCharsets.UTF_8.equals(encoding)) {
            logger.warn(messages.getString("tag_files_not_encoded_with_utf8_warning"), (Object)encoding);
            warnings.add(BagitWarning.TAG_FILES_ENCODING);
        }
    }
}

