/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.automata;

import net.byteseek.automata.Automata;
import net.byteseek.automata.serializer.DotSerializer;
import net.byteseek.automata.walker.CountStateAction;
import net.byteseek.automata.walker.StateChildWalker;

public final class AutomataUtils {
    private AutomataUtils() {
    }

    public static <T> String toDot(Automata<T> automata, boolean includeAssociatedObjects, String title) {
        return new DotSerializer<T>().serialize(automata, includeAssociatedObjects, title);
    }

    public static <T> int countStates(Automata<T> automata) {
        StateChildWalker<T> stateWalker = new StateChildWalker<T>();
        CountStateAction stateCounter = new CountStateAction();
        stateWalker.walk(automata.getInitialState(), stateCounter);
        return stateCounter.getStateCount();
    }
}

