/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.searcher.sequence;

import java.io.IOException;
import java.util.List;
import net.byteseek.io.reader.WindowReader;
import net.byteseek.io.reader.windows.Window;
import net.byteseek.matcher.sequence.SequenceMatcher;
import net.byteseek.searcher.AbstractSearcher;
import net.byteseek.searcher.SearchResult;
import net.byteseek.searcher.SearchUtils;
import net.byteseek.utils.ArgUtils;

public abstract class AbstractSequenceSearcher
extends AbstractSearcher<SequenceMatcher> {
    protected final SequenceMatcher matcher;

    public AbstractSequenceSearcher(SequenceMatcher sequence) {
        ArgUtils.checkNullObject(sequence, "Null sequence passed in to searcher.");
        this.matcher = sequence;
    }

    public SequenceMatcher getMatcher() {
        return this.matcher;
    }

    @Override
    public List<SearchResult<SequenceMatcher>> searchForwards(WindowReader reader, long fromPosition, long toPosition) throws IOException {
        Window window;
        long searchPosition;
        int sequenceLength = this.matcher.length();
        int lastSequencePosition = sequenceLength - 1;
        long l = searchPosition = fromPosition > 0L ? fromPosition : 0L;
        while (searchPosition <= toPosition && (window = reader.getWindow(searchPosition)) != null) {
            long lastWindowPosition;
            long lastSearchPosition;
            List<SearchResult<SequenceMatcher>> readerResult;
            int arrayLastPosition;
            long windowStartPosition = window.getWindowPosition();
            int windowLength = window.length();
            int arrayStartPosition = reader.getWindowOffset(searchPosition);
            if (arrayStartPosition + lastSequencePosition <= (arrayLastPosition = windowLength - 1)) {
                long distanceToEnd = toPosition - windowStartPosition;
                int lastMatchingPosition = arrayLastPosition - lastSequencePosition;
                int arrayMaxPosition = distanceToEnd < (long)lastMatchingPosition ? (int)distanceToEnd : lastMatchingPosition;
                List arrayResult = this.searchForwards(window.getArray(), arrayStartPosition, arrayMaxPosition);
                if (!arrayResult.isEmpty()) {
                    long readerPositionOffset = searchPosition - (long)arrayStartPosition;
                    return SearchUtils.addPositionToResults(arrayResult, readerPositionOffset);
                }
                if ((searchPosition += (long)(arrayMaxPosition - arrayStartPosition + 1)) > toPosition) {
                    return SearchUtils.noResults();
                }
            }
            if (!(readerResult = this.doSearchForwards(reader, searchPosition, lastSearchPosition = toPosition < (lastWindowPosition = windowStartPosition + (long)arrayLastPosition) ? toPosition : lastWindowPosition)).isEmpty()) {
                return readerResult;
            }
            searchPosition = lastSearchPosition + 1L;
        }
        return SearchUtils.noResults();
    }

    protected abstract List<SearchResult<SequenceMatcher>> doSearchForwards(WindowReader var1, long var2, long var4) throws IOException;

    @Override
    public List<SearchResult<SequenceMatcher>> searchBackwards(WindowReader reader, long fromPosition, long toPosition) throws IOException {
        Window window;
        int lastSequencePosition = this.matcher.length() - 1;
        long finalSearchPosition = toPosition > 0L ? toPosition : 0L;
        long searchPosition = this.withinLength(reader, fromPosition);
        while (searchPosition >= finalSearchPosition && (window = reader.getWindow(searchPosition)) != null) {
            long firstPossibleFitPosition;
            long firstFitPosition;
            long searchToPosition;
            List<SearchResult<SequenceMatcher>> readerResult;
            int arrayLastPosition;
            long windowStartPosition = window.getWindowPosition();
            int arrayStartSearchPosition = reader.getWindowOffset(searchPosition);
            if (arrayStartSearchPosition + lastSequencePosition <= (arrayLastPosition = window.length() - 1)) {
                long endOfSearchRelativeToWindow = finalSearchPosition - windowStartPosition;
                int arrayEndSearchPosition = endOfSearchRelativeToWindow > 0L ? (int)endOfSearchRelativeToWindow : 0;
                List arrayResults = this.searchBackwards(window.getArray(), arrayStartSearchPosition, arrayEndSearchPosition);
                if (!arrayResults.isEmpty()) {
                    long readerOffset = searchPosition - (long)arrayStartSearchPosition;
                    return SearchUtils.addPositionToResults(arrayResults, readerOffset);
                }
                int arrayBytesSearched = arrayStartSearchPosition - arrayEndSearchPosition + 1;
                if ((searchPosition -= (long)arrayBytesSearched) < finalSearchPosition) {
                    return SearchUtils.noResults();
                }
            }
            if (!(readerResult = this.doSearchBackwards(reader, searchPosition, searchToPosition = (firstFitPosition = (firstPossibleFitPosition = windowStartPosition + (long)arrayLastPosition - (long)lastSequencePosition) < searchPosition ? firstPossibleFitPosition : searchPosition) > windowStartPosition ? firstFitPosition : windowStartPosition)).isEmpty()) {
                return readerResult;
            }
            searchPosition = searchToPosition - 1L;
        }
        return SearchUtils.noResults();
    }

    protected abstract List<SearchResult<SequenceMatcher>> doSearchBackwards(WindowReader var1, long var2, long var4) throws IOException;

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.matcher + ')';
    }
}

