/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.warc;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.jwat.archive.common.ReaderFactoryAbstract;
import org.jwat.common.ByteCountingPushBackInputStream;
import org.jwat.gzip.GzipReader;
import org.jwat.warc.WarcReader;
import org.jwat.warc.WarcReaderCompressed;
import org.jwat.warc.WarcReaderUncompressed;

public class WarcReaderFactory
extends ReaderFactoryAbstract {
    public static final int PUSHBACK_BUFFER_SIZE = 32;

    protected WarcReaderFactory() {
    }

    public static boolean isWarcFile(ByteCountingPushBackInputStream pbin) throws IOException {
        return WarcReaderFactory.isWarcRecord(pbin);
    }

    public static boolean isWarcRecord(ByteCountingPushBackInputStream pbin) throws IOException {
        byte[] streamBytes = new byte["WARC/".length()];
        byte[] warcBytes = "WARC/".getBytes();
        pbin.peek(streamBytes);
        return Arrays.equals(warcBytes, streamBytes);
    }

    public static WarcReader getReader(InputStream in, int buffer_size) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("The inputstream 'in' is null");
        }
        if (buffer_size <= 0) {
            throw new IllegalArgumentException("The 'buffer_size' is less than or equal to zero: " + buffer_size);
        }
        ByteCountingPushBackInputStream pbin = new ByteCountingPushBackInputStream(new BufferedInputStream(in, buffer_size), 32);
        if (GzipReader.isGzipped(pbin)) {
            return new WarcReaderCompressed(new GzipReader(pbin), buffer_size);
        }
        return new WarcReaderUncompressed(pbin);
    }

    public static WarcReader getReader(InputStream in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("The inputstream 'in' is null");
        }
        ByteCountingPushBackInputStream pbin = new ByteCountingPushBackInputStream(in, 32);
        if (GzipReader.isGzipped(pbin)) {
            return new WarcReaderCompressed(new GzipReader(pbin));
        }
        return new WarcReaderUncompressed(pbin);
    }

    public static WarcReaderUncompressed getReaderUncompressed() {
        return new WarcReaderUncompressed();
    }

    public static WarcReaderUncompressed getReaderUncompressed(InputStream in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("The inputstream 'in' is null");
        }
        ByteCountingPushBackInputStream pbin = new ByteCountingPushBackInputStream(in, 32);
        return new WarcReaderUncompressed(pbin);
    }

    public static WarcReaderUncompressed getReaderUncompressed(InputStream in, int buffer_size) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("The inputstream 'in' is null");
        }
        if (buffer_size <= 0) {
            throw new IllegalArgumentException("The 'buffer_size' is less than or equal to zero: " + buffer_size);
        }
        ByteCountingPushBackInputStream pbin = new ByteCountingPushBackInputStream(new BufferedInputStream(in, buffer_size), 32);
        return new WarcReaderUncompressed(pbin);
    }

    public static WarcReaderCompressed getReaderCompressed() {
        return new WarcReaderCompressed();
    }

    public static WarcReaderCompressed getReaderCompressed(InputStream in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("The inputstream 'in' is null");
        }
        return new WarcReaderCompressed(new GzipReader(in));
    }

    public static WarcReaderCompressed getReaderCompressed(InputStream in, int buffer_size) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("The inputstream 'in' is null");
        }
        if (buffer_size <= 0) {
            throw new IllegalArgumentException("The 'buffer_size' is less than or equal to zero: " + buffer_size);
        }
        return new WarcReaderCompressed(new GzipReader(new BufferedInputStream(in, buffer_size)));
    }
}

