/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.mapping.csv;

import ch.docuteam.darc.exceptions.FileAlreadyExistsException;
import ch.docuteam.darc.exceptions.FileOperationNotAllowedException;
import ch.docuteam.darc.exceptions.FolderNameIsEmptyException;
import ch.docuteam.darc.exceptions.LevelMetadataElementIsReadOnly;
import ch.docuteam.darc.exceptions.MetadataElementAllowedValuesException;
import ch.docuteam.darc.exceptions.MetadataElementIsNotAllowedException;
import ch.docuteam.darc.exceptions.MetadataElementIsNotDefinedException;
import ch.docuteam.darc.exceptions.MetadataElementSetterPostActionException;
import ch.docuteam.darc.exceptions.MetadataElementValidatorException;
import ch.docuteam.darc.mdconfig.LevelOfDescription;
import ch.docuteam.darc.mets.Document;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.darc.mets.structmap.NodeFolder;
import ch.docuteam.mapping.csv.CsvImportError;
import ch.docuteam.mapping.csv.CsvImportException;
import ch.docuteam.mapping.csv.CsvImportWarning;
import ch.docuteam.mapping.csv.CsvReader;
import ch.docuteam.mapping.csv.ImportResult;
import ch.docuteam.mapping.csv.ParamType;
import ch.docuteam.mapping.csv.SipCreationArgs;
import ch.docuteam.mapping.csv.SipImportColumn;
import ch.docuteam.mapping.csv.SipImportMetadataColumn;
import ch.docuteam.mapping.csv.SipImportTableConfig;
import ch.docuteam.mapping.util.XmlUtil;
import ch.docuteam.tools.file.exception.FileUtilExceptionListException;
import ch.docuteam.tools.out.Logger;
import com.google.common.collect.MoreCollectors;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringUtils;

public class CsvToSipImporter {
    private final List<CsvImportWarning> warningList = new ArrayList<CsvImportWarning>();
    private final Gson gson = new GsonBuilder().create();
    private final SipImportTableConfig importConfig;
    private final Path pathToCsv;
    private final Map<ParamType, String> headerMap;
    private final SipCreationArgs sipCreationArgs;

    private CsvToSipImporter(Path pathToConfig, Path pathToCsv, SipCreationArgs creationArgs) {
        this.importConfig = XmlUtil.unmarshalXml(pathToConfig, SipImportTableConfig.class);
        this.pathToCsv = pathToCsv;
        this.headerMap = CsvToSipImporter.createHeaderMap(this.importConfig);
        this.sipCreationArgs = creationArgs;
    }

    private static Map<ParamType, String> createHeaderMap(SipImportTableConfig importConfig) {
        List<SipImportColumn> columns = importConfig.getSipImportColumnMapping().getSipImportColumn();
        return columns.stream().collect(Collectors.toUnmodifiableMap(SipImportColumn::getParamID, SipImportColumn::getTableHeaderLabel));
    }

    public static ImportResult createSipFromCsv(SipCreationArgs creationArgs, Path pathToCsv, Path pathToConfig) {
        return new CsvToSipImporter(pathToConfig, pathToCsv, creationArgs).createSipFromCsvInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImportResult createSipFromCsvInternal() {
        Document document = null;
        try {
            List<CSVRecord> csvRecords = CsvReader.readCsv(this.pathToCsv, this.importConfig.getCsvFormat());
            CSVRecord rootRecord = this.getRootRecord(csvRecords);
            document = Document.createNewWithRootFolderName((String)this.sipCreationArgs.getSipFilePath().toAbsolutePath().toString(), (String)this.getFileName(rootRecord), (String)this.sipCreationArgs.getSaId(), (String)this.sipCreationArgs.getDssId(), (String)CsvToSipImporter.class.getName());
            NodeFolder rootNodeFolder = (NodeFolder)document.getStructureMap().getRoot();
            this.setNodeProperties((NodeAbstract)rootNodeFolder, rootRecord);
            this.importChildRecords(rootNodeFolder, rootRecord, csvRecords);
            document.saveWithoutBackup();
            ImportResult importResult = new ImportResult(true, this.warningList, CsvImportError.NONE, new Object[0]);
            return importResult;
        }
        catch (CsvImportException e) {
            ImportResult importResult = ImportResult.fromCSVImportException(e);
            return importResult;
        }
        catch (Exception e) {
            ImportResult importResult = ImportResult.fromCSVImportException(new CsvImportException(CsvImportError.GENERIC, (Throwable)e, new Object[0]));
            return importResult;
        }
        finally {
            if (document != null) {
                document.unlockIfNecessary();
                try {
                    document.cleanupWorkingCopy();
                }
                catch (FileUtilExceptionListException e) {
                    throw new RuntimeException("Error while trying to clean up working copy: " + e.getMessage(), e);
                }
            }
        }
    }

    private CSVRecord getRootRecord(List<CSVRecord> csvRecords) {
        return (CSVRecord)csvRecords.stream().filter(record -> StringUtils.isBlank((CharSequence)this.getValue((CSVRecord)record, ParamType.PARENT_ID))).collect(MoreCollectors.onlyElement());
    }

    private String getFileName(CSVRecord record) {
        String path = this.getValue(record, ParamType.PATH);
        if (".".equals(path) || path.isBlank()) {
            return this.getValue(record, ParamType.TITLE);
        }
        return new File(path.replace("\\", "/")).getName();
    }

    private void setNodeProperties(NodeAbstract node, CSVRecord record) {
        node.setUnitTitle(this.getValue(record, ParamType.TITLE));
        this.setMetadata(node, record);
    }

    private void importChildRecords(NodeFolder parentNodeFolder, CSVRecord parentRecord, List<CSVRecord> allRecords) throws FileAlreadyExistsException, FileUtilExceptionListException, FolderNameIsEmptyException, FileOperationNotAllowedException, IOException {
        List<CSVRecord> childRecords = this.getChildRecords(parentRecord, allRecords);
        for (CSVRecord childRecord : childRecords) {
            this.importChildrenRecursively(parentNodeFolder, childRecord, allRecords);
        }
    }

    private List<CSVRecord> getChildRecords(CSVRecord parentRecord, List<CSVRecord> allRecords) {
        String parentId = this.getValue(parentRecord, ParamType.ID);
        return allRecords.stream().filter(record -> parentId.equals(this.getValue((CSVRecord)record, ParamType.PARENT_ID))).collect(Collectors.toUnmodifiableList());
    }

    private void importChildrenRecursively(NodeFolder parentNodeFolder, CSVRecord childRecord, List<CSVRecord> allRecords) throws FileAlreadyExistsException, IOException, FileOperationNotAllowedException, FolderNameIsEmptyException, FileUtilExceptionListException {
        NodeAbstract node;
        Optional<String> path = Optional.ofNullable(this.getValue(childRecord, ParamType.PATH)).filter(StringUtils::isNotBlank).map(this::getAbsolutePath);
        File file = path.map(File::new).orElse(null);
        if (file != null && !file.exists()) {
            throw new CsvImportException(CsvImportError.FILE_DOES_NOT_EXIST, path, childRecord.getRecordNumber());
        }
        if (file == null || file.isDirectory()) {
            String nodeFolderName = file == null ? this.getValue(childRecord, ParamType.TITLE) : file.getName();
            node = parentNodeFolder.createNewFolder(nodeFolderName);
            this.importChildRecords((NodeFolder)node, childRecord, allRecords);
        } else {
            node = parentNodeFolder.insertFileOrFolder(path.orElseThrow());
            this.checkChecksum(childRecord, path.orElseThrow(), node);
        }
        this.setNodeProperties(node, childRecord);
    }

    private void checkChecksum(CSVRecord childRecord, String path, NodeAbstract node) {
        if (this.sipCreationArgs.isChecksum()) {
            String checksumInCsv = this.getValue(childRecord, ParamType.CHECKSUM);
            String calculatedChecksum = node.getChecksum();
            if (!calculatedChecksum.equals(checksumInCsv)) {
                throw new CsvImportException(CsvImportError.CHECKSUM_MISMATCH, calculatedChecksum, path, checksumInCsv, childRecord.getRecordNumber());
            }
        }
    }

    private void setLevelOfDescription(NodeAbstract node, CSVRecord record) {
        String recordLevel = this.getValue(record, ParamType.DESCRIPTION_LEVEL);
        try {
            Optional<LevelOfDescription> existingLevel = node.getDocument().getLevels().getAll().stream().filter(l -> l.getName().equals(recordLevel)).findFirst();
            if (!this.sipCreationArgs.isSkipLevelValidation() && existingLevel.isEmpty()) {
                throw new CsvImportException(CsvImportError.LEVEL_NOT_ALLOWED, recordLevel, record.getRecordNumber() + 1L);
            }
            node.setLevel(node.getDocument().getLevels().get(recordLevel));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            this.warningList.add(new CsvImportWarning(node.getAbsolutePathString(), this.headerMap.get((Object)ParamType.DESCRIPTION_LEVEL), recordLevel, CsvImportWarning.WarningType.PROPERTY_NOT_ALLOWED));
        }
    }

    private void setMetadata(NodeAbstract node, CSVRecord record) {
        this.setLevelOfDescription(node, record);
        if (this.importConfig.getSipImportMetadataColumnMapping() == null) {
            return;
        }
        List<SipImportMetadataColumn> metadataColumns = this.importConfig.getSipImportMetadataColumnMapping().getSipImportMetadataColumn();
        metadataColumns.forEach(column -> {
            String metadataValue = this.getCellValue(record, column.getTableHeaderLabel());
            String metsRefId = column.getMatterhornMetsAccessorID().value();
            Logger.debug((Object)String.format("Adding metadata %s with value '%s' to node %s", column.getTableHeaderLabel(), metadataValue, node.getLabel()));
            try {
                if (metadataValue.matches("^\\[.+\\]$")) {
                    List recordValues = (List)this.gson.fromJson(metadataValue, List.class);
                    int propertyIndex = 0;
                    for (String recordValueItem : recordValues) {
                        Logger.debug((Object)String.format("Adding value %s", recordValueItem));
                        if (this.sipCreationArgs.isSkipLevelValidation()) {
                            node.setDynamicMetadataValueForName_force(metsRefId, propertyIndex, recordValueItem);
                            ++propertyIndex;
                            continue;
                        }
                        if (node.getLevel().getDynamicMetadataElement(metsRefId).canAddOneInstanceToNode(node)) {
                            node.setDynamicMetadataValueForName(metsRefId, propertyIndex, recordValueItem);
                            ++propertyIndex;
                            continue;
                        }
                        this.warningList.add(new CsvImportWarning(node.getAbsolutePathString(), metsRefId, metadataValue, CsvImportWarning.WarningType.PROPERTY_NOT_ALLOWED));
                    }
                } else if (this.sipCreationArgs.isSkipLevelValidation()) {
                    node.setDynamicMetadataValueForName_force(metsRefId, metadataValue);
                } else {
                    node.setDynamicMetadataValueForName(metsRefId, metadataValue);
                }
            }
            catch (LevelMetadataElementIsReadOnly | MetadataElementAllowedValuesException | MetadataElementIsNotAllowedException | MetadataElementIsNotDefinedException | MetadataElementSetterPostActionException | MetadataElementValidatorException e) {
                this.warningList.add(new CsvImportWarning(node.getAbsolutePathString(), metsRefId, metadataValue, CsvImportWarning.WarningType.PROPERTY_NOT_ALLOWED));
            }
            catch (JsonSyntaxException | IllegalAccessException | InvocationTargetException e) {
                throw new CsvImportException(CsvImportError.VALUE_COULD_NOT_BE_SET, e, metadataValue, metsRefId);
            }
        });
    }

    private String getAbsolutePath(String pathString) {
        Path path = Path.of(pathString, new String[0]);
        return path.isAbsolute() ? path.toString() : Path.of(this.pathToCsv.getParent().toString(), path.toString()).toAbsolutePath().normalize().toString().replace("\\", "/");
    }

    private String getValue(CSVRecord record, ParamType columnType) {
        return this.getCellValue(record, this.headerMap.get((Object)columnType));
    }

    private String getCellValue(CSVRecord record, String columnName) {
        if (!record.isMapped(columnName)) {
            throw new CsvImportException(CsvImportError.REFERENCE_COLUMN_NOT_IN_CSV, columnName);
        }
        return record.get(columnName);
    }
}

