/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.mapping.dublincore;

import ch.docuteam.darc.ead.C;
import ch.docuteam.darc.exceptions.FileAlreadyExistsException;
import ch.docuteam.darc.exceptions.FileOperationNotAllowedException;
import ch.docuteam.darc.exceptions.FolderNameIsEmptyException;
import ch.docuteam.darc.mdconfig.LevelOfDescription;
import ch.docuteam.darc.mdconfig.MetadataElementValidator;
import ch.docuteam.darc.mdconfig.MetadataElementValidatorDateYYYYMMDD;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.darc.mets.structmap.NodeFolder;
import ch.docuteam.darc.premis.Object;
import ch.docuteam.mapping.dublincore.ExportException;
import ch.docuteam.mapping.dublincore.InvalidBagitException;
import ch.docuteam.mapping.dublincore.InvalidDublinCoreSIPException;
import ch.docuteam.mapping.dublincore.LevelsNotFoundException;
import ch.docuteam.mapping.dublincore.MessageDigestException;
import ch.docuteam.tools.file.FileChecksumCalculator;
import ch.docuteam.tools.file.FileUtil;
import ch.docuteam.tools.file.Zipper;
import ch.docuteam.tools.file.exception.FileUtilExceptionListException;
import ch.docuteam.tools.out.Logger;
import ch.docuteam.tools.string.DateFormatter;
import gov.loc.repository.bagit.domain.Bag;
import gov.loc.repository.bagit.domain.Manifest;
import gov.loc.repository.bagit.exceptions.CorruptChecksumException;
import gov.loc.repository.bagit.exceptions.FileNotInPayloadDirectoryException;
import gov.loc.repository.bagit.exceptions.InvalidBagMetadataException;
import gov.loc.repository.bagit.exceptions.InvalidBagitFileFormatException;
import gov.loc.repository.bagit.exceptions.MaliciousPathException;
import gov.loc.repository.bagit.exceptions.MissingBagitFileException;
import gov.loc.repository.bagit.exceptions.MissingPayloadDirectoryException;
import gov.loc.repository.bagit.exceptions.MissingPayloadManifestException;
import gov.loc.repository.bagit.exceptions.UnparsableVersionException;
import gov.loc.repository.bagit.exceptions.UnsupportedAlgorithmException;
import gov.loc.repository.bagit.exceptions.VerificationException;
import gov.loc.repository.bagit.hash.StandardSupportedAlgorithms;
import gov.loc.repository.bagit.reader.BagReader;
import gov.loc.repository.bagit.verify.BagVerifier;
import gov.loc.repository.bagit.verify.PayloadVerifier;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class Exporter {
    static final String LEVEL_NAME_FILE = "File";
    private static final StandardSupportedAlgorithms BAGIT_SUPPORTED_ALGORITHM = StandardSupportedAlgorithms.SHA256;
    private static final String TMP_DIR_PREFIX = "bagit";
    private static final String BAGIT_PAYLOAD_PATH = "data";
    private static final String SIP_ROOT_DIR = "sip";
    private static final String DC_XML = "dc.xml";
    private static final String NAME_GLUE = "-";
    private static final String DC_XPath_title = "dc:title";
    private static final String DC_XPath_format = "dc:format";
    private static final String DC_XPath_date = "dc:date";
    private static final String DC_XPath_identifier = "dc:identifier";
    private static final String DC_XPath_identifier_NAMESPACE = "namespace";
    private static final String DC_XPath_rights = "dc:rights";
    private static final String DC_XPath_source = "dc:source";
    private static final String DC_XPath_type = "dc:type";
    private static final String DC_XPath_coverage = "dc:coverage";
    private static final String DC_XPath_publisher = "dc:publisher";
    private static final String DC_XPath_contributor = "dc:contributor";
    private static final String DC_XPath_subject = "dc:subject";
    private static final String DC_XPath_language = "dc:language";
    private static final String DC_XPath_creator = "dc:creator";
    private static final String DC_XPath_relation = "dc:relation";
    private static final String DC_XPath_description = "dc:description";
    private final String operatorName;
    private String saId;
    private final String dssId;
    private Path bagitPath;
    private Bag dublinCoreBag;
    private String iSILCode;
    private Map<Path, String> fileToChecksumMap;
    private static final boolean ignoreHiddenFiles = true;
    private final MetadataElementValidator dateValidator = new MetadataElementValidatorDateYYYYMMDD();

    public Exporter(String dssId, Optional<String> levelsXmlPath, String operatorName, Path bagitZipPath) throws InvalidBagitException, LevelsNotFoundException {
        this.operatorName = operatorName;
        this.dssId = dssId;
        if (levelsXmlPath.isPresent()) {
            String levelsConfigPath = levelsXmlPath.get();
            if (LevelOfDescription.isInitializationFileFound((String)levelsConfigPath)) {
                LevelOfDescription.setInitializationFilePath((String)levelsConfigPath);
            } else {
                throw new LevelsNotFoundException(levelsConfigPath);
            }
        }
        try {
            this.bagitPath = this.unzipBagitZip(bagitZipPath);
            Path bagitSIPPath = this.bagitPath.resolve(SIP_ROOT_DIR);
            this.dublinCoreBag = Exporter.getDublinCoreSIPBag(bagitSIPPath);
            this.iSILCode = this.getISILCode(this.dublinCoreBag);
            this.fileToChecksumMap = this.getFileToChecksumMap(this.dublinCoreBag);
        }
        catch (Exception e) {
            throw new InvalidBagitException("invalid bagit - error at unzipping, validating or getting the isil code", e);
        }
    }

    public void cleanUp() {
        if (this.bagitPath != null) {
            try {
                FileUtils.deleteDirectory((File)this.bagitPath.toFile());
            }
            catch (IOException e) {
                Logger.error((java.lang.Object)("Could not delete bagitSIPPath folder: " + this.bagitPath.toString()), (Throwable)e);
            }
        }
    }

    private String getISILCode(Bag bag) throws DocumentException, InvalidBagitException {
        Logger.debug((java.lang.Object)"Parsing for the ISIL code in the BagIt...");
        String iSILCode = null;
        Path dublinCoreSIPPath = bag.getRootDir();
        Path sourceRootPath = dublinCoreSIPPath.resolve(BAGIT_PAYLOAD_PATH);
        Path dcFilePath = sourceRootPath.resolve(DC_XML);
        if (Files.exists(dcFilePath, new LinkOption[0])) {
            Document dcDocument = this.getDCdom4jDocument(dcFilePath);
            Element rootElement = dcDocument.getRootElement();
            List<String> identifierList = this.getValueList(rootElement, DC_XPath_identifier);
            if (!identifierList.isEmpty()) {
                iSILCode = identifierList.stream().filter(identifier -> identifier.startsWith(DC_XPath_identifier_NAMESPACE)).map(identifier -> identifier.substring(10)).findFirst().get();
            }
        } else {
            throw new InvalidBagitException("getISILCode - cannot find dc.xml");
        }
        if (iSILCode == null) {
            throw new InvalidBagitException("getISILCode - cannot find an iSILCode for this bag");
        }
        return iSILCode;
    }

    public String getISILCode() {
        return this.iSILCode;
    }

    public void exportDublinCoreToMETS(String saID, Path metsSIPPath) throws ExportException {
        Logger.info((java.lang.Object)"Starting export towards a Matterhorn METS SIP...");
        this.saId = saID;
        Object.setDefaultMessageDigestAlgorithm((FileChecksumCalculator.Algorithm)FileChecksumCalculator.Algorithm.SHA256);
        Path dublinCoreSIPPath = this.dublinCoreBag.getRootDir();
        this.generateMetsSIP(dublinCoreSIPPath, metsSIPPath);
    }

    static Bag getDublinCoreSIPBag(Path bagitSIPPath) throws IOException, UnparsableVersionException, MaliciousPathException, InvalidBagMetadataException, UnsupportedAlgorithmException, InvalidBagitFileFormatException, MissingPayloadManifestException, MissingBagitFileException, MissingPayloadDirectoryException, FileNotInPayloadDirectoryException, InterruptedException, CorruptChecksumException, VerificationException {
        Logger.debug((java.lang.Object)("Parsing BagIt: " + bagitSIPPath));
        BagReader reader = new BagReader();
        Bag bag = reader.read(bagitSIPPath);
        Exporter.validateBag(bag);
        return bag;
    }

    private static void validateBag(Bag bag) throws IOException, MissingPayloadManifestException, MissingBagitFileException, MissingPayloadDirectoryException, FileNotInPayloadDirectoryException, InterruptedException, MaliciousPathException, UnsupportedAlgorithmException, InvalidBagitFileFormatException, CorruptChecksumException, VerificationException {
        Logger.debug((java.lang.Object)"Validate BagIt, ignoring hidden files: true");
        try (BagVerifier bagVerifier = new BagVerifier();){
            bagVerifier.isComplete(bag, true);
            bagVerifier.isValid(bag, true);
        }
        try (PayloadVerifier payloadVerifier = new PayloadVerifier();){
            payloadVerifier.verifyPayload(bag, true);
        }
    }

    Bag getDublinCoreSIPBag() {
        return this.dublinCoreBag;
    }

    Map<Path, String> getFileToChecksumMap(Bag bag) {
        Set payLoadManifests = bag.getPayLoadManifests();
        Map<Path, String> fileToChecksumMap = new HashMap<Path, String>();
        Optional<Manifest> manifestSHA256 = payLoadManifests.stream().filter(manifest -> manifest.getAlgorithm().equals(BAGIT_SUPPORTED_ALGORITHM)).findFirst();
        if (manifestSHA256.isPresent()) {
            fileToChecksumMap = manifestSHA256.get().getFileToChecksumMap();
        }
        return fileToChecksumMap;
    }

    private void generateMetsSIP(Path dublinCoreSIPPath, Path metsSIPPath) throws ExportException {
        ch.docuteam.darc.mets.Document metsDocument = null;
        try {
            Path sourceRootPath = dublinCoreSIPPath.resolve(BAGIT_PAYLOAD_PATH);
            FolderContentType rootContentType = Exporter.getFolderContentType(sourceRootPath);
            Path rootDCFilePath = sourceRootPath.resolve(DC_XML);
            Logger.debug((java.lang.Object)("root dcFilePath: " + rootDCFilePath));
            if (rootContentType == FolderContentType.OneOrMoreSubFolders) {
                metsDocument = ch.docuteam.darc.mets.Document.createNewWithRootFolderName((String)metsSIPPath.toString(), (String)SIP_ROOT_DIR, (String)this.saId, (String)this.dssId, (String)this.operatorName);
                NodeAbstract targetRootNode = metsDocument.getStructureMap().getRoot();
                this.export(sourceRootPath, targetRootNode);
            } else if (rootContentType == FolderContentType.OneFile) {
                try (Stream<Path> pathStream = Files.list(sourceRootPath);){
                    Path singleFile = (Path)pathStream.filter(path -> !Files.isDirectory(path, new LinkOption[0]) && !path.getFileName().toString().equals(DC_XML)).collect(Collectors.toList()).get(0);
                    metsDocument = ch.docuteam.darc.mets.Document.createNewWithRoot((String)metsSIPPath.toString(), (String)singleFile.toString(), (String)this.saId, (String)this.dssId, (String)this.operatorName);
                    NodeAbstract targetRootNode = metsDocument.getStructureMap().getRoot();
                    LevelOfDescription fileLevel = targetRootNode.getDocument().getLevels().get(LEVEL_NAME_FILE);
                    targetRootNode.setLevel(fileLevel);
                    String singleFileName = singleFile.getFileName().toString();
                    targetRootNode.rename("sip-" + singleFileName);
                    this.validateMETSMessageDigest(this.fileToChecksumMap, singleFile, targetRootNode);
                    this.setMetadataFromDC(rootDCFilePath, targetRootNode);
                }
            } else {
                metsDocument = ch.docuteam.darc.mets.Document.createNewWithRootFolderName((String)metsSIPPath.toString(), (String)SIP_ROOT_DIR, (String)this.saId, (String)this.dssId, (String)this.operatorName);
                NodeAbstract targetRootNode = metsDocument.getStructureMap().getRoot();
                this.setMetadataFromDC(rootDCFilePath, targetRootNode);
            }
            metsDocument.saveWithoutBackup();
            metsDocument.cleanupWorkingCopy();
            metsDocument.unlockIfNecessary();
        }
        catch (Exception e) {
            if (metsDocument != null) {
                try {
                    metsDocument.cleanupWorkingCopy();
                }
                catch (FileUtilExceptionListException e1) {
                    Logger.warn((java.lang.Object)((java.lang.Object)e1));
                }
                try {
                    FileUtils.deleteDirectory((File)new File(metsDocument.getFilePath()).getParentFile());
                }
                catch (IOException e2) {
                    Logger.warn((java.lang.Object)e2);
                }
            }
            throw new ExportException("generateMetsSIP failed", e);
        }
        Logger.info((java.lang.Object)("Mets SIP was created at: " + metsDocument.getFilePath()));
    }

    private void export(Path sourcePath, NodeAbstract nodeAbstract) throws IOException, InvalidBagitException, FileAlreadyExistsException, FileOperationNotAllowedException, FolderNameIsEmptyException, FileUtilExceptionListException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, MessageDigestException, InvalidDublinCoreSIPException {
        FolderContentType t = Exporter.getFolderContentType(sourcePath);
        if (t == FolderContentType.OneOrMoreSubFolders) {
            this.setMetadataFromDC(sourcePath.resolve(DC_XML), nodeAbstract);
            try (Stream<Path> pathStream = Files.list(sourcePath);){
                List subfolders = pathStream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).sorted(Comparator.comparing(path -> path.getFileName().toString())).collect(Collectors.toList());
                for (Path subfolder : subfolders) {
                    NodeFolder childNode = ((NodeFolder)nodeAbstract).createNewFolder(subfolder.getFileName().toString());
                    this.export(subfolder, (NodeAbstract)childNode);
                }
            }
        } else if (t == FolderContentType.OneFile) {
            try (Stream<Path> pathStream = Files.list(sourcePath);){
                Path singleFileChild = (Path)pathStream.filter(path -> !Files.isDirectory(path, new LinkOption[0]) && !path.getFileName().toString().equals(DC_XML)).collect(Collectors.toList()).get(0);
                NodeAbstract parent = (NodeAbstract)nodeAbstract.getParent();
                String parentName = sourcePath.getFileName().toString();
                String childName = singleFileChild.getFileName().toString();
                nodeAbstract.delete();
                NodeAbstract newChildNode = ((NodeFolder)parent).insertFileOrFolder(singleFileChild.toString());
                this.validateMETSMessageDigest(this.fileToChecksumMap, singleFileChild, newChildNode);
                newChildNode.rename(parentName + NAME_GLUE + childName);
                LevelOfDescription fileLevel = nodeAbstract.getDocument().getLevels().get(LEVEL_NAME_FILE);
                newChildNode.setLevel(fileLevel);
                this.setMetadataFromDC(sourcePath.resolve(DC_XML), newChildNode);
            }
        } else {
            this.setMetadataFromDC(sourcePath.resolve(DC_XML), nodeAbstract);
        }
    }

    Predicate<Path> filterOutHiddenFiles() {
        return new Predicate<Path>(){

            @Override
            public boolean test(Path path) {
                boolean isHidden = path.toFile().isHidden();
                return !isHidden;
            }
        };
    }

    static FolderContentType getFolderContentType(Path folderPath) throws IOException, InvalidBagitException, InvalidDublinCoreSIPException {
        List normalFiles;
        List subfolders;
        if (!(Files.exists(folderPath, new LinkOption[0]) && Files.isDirectory(folderPath, new LinkOption[0]) && Files.isReadable(folderPath))) {
            throw new IOException("Invalid folder path : " + folderPath.toString());
        }
        Path dcPath = folderPath.resolve(DC_XML);
        if (!Files.exists(dcPath, new LinkOption[0])) {
            throw new InvalidDublinCoreSIPException("Missing : " + dcPath.toString());
        }
        if (Files.isDirectory(dcPath, new LinkOption[0])) {
            throw new InvalidBagitException("Should be file instead of folder : " + dcPath.toString());
        }
        if (!Files.isReadable(dcPath)) {
            throw new InvalidBagitException("Invalid access to: " + dcPath.toString());
        }
        try (Stream<Path> pathStream = Files.list(folderPath);){
            subfolders = pathStream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).collect(Collectors.toList());
        }
        try (Stream<Path> pathStream = Files.list(folderPath);){
            normalFiles = pathStream.filter(path -> !Files.isDirectory(path, new LinkOption[0]) && !path.getFileName().toString().equals(DC_XML)).collect(Collectors.toList());
        }
        if (subfolders.isEmpty() && normalFiles.isEmpty()) {
            return FolderContentType.DCOnly;
        }
        if (!subfolders.isEmpty() && !normalFiles.isEmpty()) {
            throw new InvalidBagitException("dc.xml should have either one file sibling either one or more folder sibblings");
        }
        if (!subfolders.isEmpty()) {
            return FolderContentType.OneOrMoreSubFolders;
        }
        if (normalFiles.size() > 1) {
            throw new InvalidBagitException("dc.xml should have at most one file sibling");
        }
        return FolderContentType.OneFile;
    }

    private void validateMETSMessageDigest(Map<Path, String> fileToChecksumMap, Path filePath, NodeAbstract fileNode) throws MessageDigestException {
        boolean checked = false;
        Object premisObject = fileNode.getDocument().getAMDSection().getDigiprov(fileNode.getAdmId()).getLastObject();
        Optional<Path> pathKey = fileToChecksumMap.keySet().stream().filter(path -> path.equals(filePath)).findFirst();
        if (pathKey.isPresent()) {
            String expectedDigest = fileToChecksumMap.get(pathKey.get());
            String actualDigest = premisObject.getMessageDigest();
            if (!actualDigest.equals(expectedDigest)) {
                String s = "messageDigest not ok for filePath: '" + filePath + "', expected: " + expectedDigest + " , actual: " + actualDigest;
                MessageDigestException e = new MessageDigestException(s);
                Logger.error((java.lang.Object)e);
                throw e;
            }
            checked = true;
        }
        if (!checked) {
            String s = "messageDigest not found for filePath: " + filePath;
            MessageDigestException e = new MessageDigestException(s);
            Logger.error((java.lang.Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private void setMetadataFromDC(Path dcPath, NodeAbstract metsNode) {
        try {
            List<String> descriptionList;
            List<String> relationList;
            List<String> creatorList;
            List<String> languageList;
            List<String> subjectList;
            List<String> contributorList;
            List<String> publisherList;
            List<String> coverageList;
            List<String> typeList;
            List<String> accessNrList;
            List<String> accessPolicyList;
            List<String> identifierList;
            Logger.debug((java.lang.Object)("setMetadataFromDC - dcPath: " + dcPath + " - metsNode.getLabel(): " + metsNode.getLabel()));
            Document dcDocument = this.getDCdom4jDocument(dcPath);
            Element rootElement = dcDocument.getRootElement();
            if (rootElement.selectNodes(DC_XPath_title).size() > 1) {
                throw new InvalidBagitException("dc:title must only appear once!");
            }
            Node titleNode = rootElement.selectSingleNode(DC_XPath_title);
            if (titleNode == null) {
                throw new InvalidBagitException("dc:title not found");
            }
            String title = titleNode.getText();
            metsNode.setUnitTitle(title);
            C cNode = metsNode.getMyDMDSectionWithEAD().getC();
            List<String> formatList = this.getValueList(rootElement, DC_XPath_format);
            if (!formatList.isEmpty()) {
                cNode.setFormat(formatList);
            }
            List<String> dateList = this.getValueList(rootElement, DC_XPath_date);
            ArrayList<String> validatedDateList = new ArrayList<String>();
            for (String date : dateList) {
                try {
                    this.dateValidator.check(date, null, null);
                    validatedDateList.add(date);
                }
                catch (Exception e) {
                    String convertedDate = Exporter.convertDateFormat(date, "yyyy-MM-dd", "yyyyMMdd");
                    validatedDateList.add(convertedDate);
                }
            }
            if (!validatedDateList.isEmpty()) {
                cNode.setDate(validatedDateList);
            }
            if (!(identifierList = this.getValueList(rootElement, DC_XPath_identifier)).isEmpty()) {
                cNode.setRefCode(identifierList);
            }
            if (!(accessPolicyList = this.getValueList(rootElement, DC_XPath_rights)).isEmpty()) {
                cNode.setAccessPolicy(accessPolicyList);
            }
            if (!(accessNrList = this.getValueList(rootElement, DC_XPath_source)).isEmpty()) {
                cNode.setAccessNr(accessNrList);
            }
            if (!(typeList = this.getValueList(rootElement, DC_XPath_type)).isEmpty()) {
                cNode.setObjectType(typeList);
            }
            if (!(coverageList = this.getValueList(rootElement, DC_XPath_coverage)).isEmpty()) {
                cNode.setGeogName(coverageList);
            }
            if (!(publisherList = this.getValueList(rootElement, DC_XPath_publisher)).isEmpty()) {
                cNode.setPublisher(publisherList);
            }
            if (!(contributorList = this.getValueList(rootElement, DC_XPath_contributor)).isEmpty()) {
                cNode.setInvolved(contributorList);
            }
            if (!(subjectList = this.getValueList(rootElement, DC_XPath_subject)).isEmpty()) {
                cNode.setSubjectGeneral(subjectList);
            }
            if (!(languageList = this.getValueList(rootElement, DC_XPath_language)).isEmpty()) {
                cNode.setLanguage(languageList);
            }
            if (!(creatorList = this.getValueList(rootElement, DC_XPath_creator)).isEmpty()) {
                cNode.setOrigination(creatorList);
            }
            if (!(relationList = this.getValueList(rootElement, DC_XPath_relation)).isEmpty()) {
                cNode.setRelatedMaterial(relationList);
            }
            if (!(descriptionList = this.getValueList(rootElement, DC_XPath_description)).isEmpty()) {
                cNode.setScopeContent(descriptionList);
            }
        }
        catch (Exception e) {
            Logger.error((java.lang.Object)"setMetadataFromDC failed: ", (Throwable)e);
        }
    }

    static String convertDateFormat(String dateString, String sourceFormat, String targetFormat) {
        try {
            Date date = DateFormatter.parse((String)dateString, (String)sourceFormat);
            SimpleDateFormat defaultDateFormat = new SimpleDateFormat(targetFormat);
            return defaultDateFormat.format(date);
        }
        catch (Exception e) {
            Logger.warn((java.lang.Object)("convertDateFormat failed: " + dateString + " sourceFormat: " + sourceFormat + " targetFormat: " + targetFormat));
            return dateString;
        }
    }

    private List<String> getValueList(Element rootElement, String dc_xpath) {
        List nodeList = rootElement.selectNodes(dc_xpath);
        ArrayList<String> valueList = new ArrayList<String>();
        for (Node domNode : nodeList) {
            valueList.add(domNode.getText());
        }
        return valueList;
    }

    Document getDCdom4jDocument(Path dcPath) throws DocumentException {
        return new SAXReader().read(dcPath.toFile());
    }

    private Path unzipBagitZip(Path zipPath) throws IOException {
        Logger.debug((java.lang.Object)("Unzipping '" + zipPath));
        Path tempFolderPath = Files.createTempDirectory(Paths.get(FileUtil.getTempFolder(), new String[0]), TMP_DIR_PREFIX, new FileAttribute[0]);
        Zipper.unzip((String)zipPath.toAbsolutePath().toString(), (String)tempFolderPath.toString());
        return tempFolderPath;
    }

    static enum FolderContentType {
        OneOrMoreSubFolders,
        OneFile,
        DCOnly;

    }
}

