/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.archive;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.java.truevfs.comp.zip.ZipEntry;
import net.java.truevfs.comp.zip.ZipFile;
import org.apache.commons.io.FilenameUtils;
import uk.gov.nationalarchives.droid.core.interfaces.AsynchDroid;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResultImpl;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.ResourceId;
import uk.gov.nationalarchives.droid.core.interfaces.ResultHandler;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveFileUtils;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveFileWalker;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveHandler;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ByteseekWindowWrapper;
import uk.gov.nationalarchives.droid.core.interfaces.archive.IdentificationRequestFactory;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;

public class TrueVfsArchiveHandler
implements ArchiveHandler {
    private AsynchDroid droidCore;
    private IdentificationRequestFactory<InputStream> factory;
    private ResultHandler resultHandler;

    public TrueVfsArchiveHandler() {
    }

    public TrueVfsArchiveHandler(AsynchDroid droidCore, IdentificationRequestFactory<InputStream> factory, ResultHandler resultHandler) {
        this.droidCore = droidCore;
        this.factory = factory;
        this.resultHandler = resultHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(IdentificationRequest request) throws IOException {
        try (final ZipFile zipFile = new ZipFile((SeekableByteChannel)new ByteseekWindowWrapper(request.getWindowReader()), ZipFile.DEFAULT_CHARSET, true, false);){
            Iterable<ZipEntry> iterable = new Iterable<ZipEntry>(){

                @Override
                public Iterator<ZipEntry> iterator() {
                    return new ZipFileIterator(zipFile);
                }
            };
            ZipArchiveWalker walker = new ZipArchiveWalker(request.getIdentifier(), zipFile);
            walker.walk(iterable);
        }
    }

    private ResourceId submitDirectory(URI parentName, ZipEntry entry, String entryName, ResourceId correlationId) {
        IdentificationResultImpl result = new IdentificationResultImpl();
        long size = entry.getSize();
        long time = entry.getTime();
        RequestMetaData metaData = new RequestMetaData(size != -1L ? Long.valueOf(size) : null, time != -1L ? Long.valueOf(time) : null, entryName);
        RequestIdentifier identifier = new RequestIdentifier(ArchiveFileUtils.toZipUri(parentName, entry.getName()));
        result.setRequestMetaData(metaData);
        result.setIdentifier(identifier);
        return this.resultHandler.handleDirectory(result, correlationId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void submit(ZipEntry entry, String entryName, URI parentName, ZipFile file, ResourceId correlationId, long originatorNodeId) throws IOException {
        long size = entry.getSize();
        long time = entry.getTime();
        RequestMetaData metaData = new RequestMetaData(size != -1L ? Long.valueOf(size) : null, time != -1L ? Long.valueOf(time) : null, entryName);
        RequestIdentifier identifier = new RequestIdentifier(ArchiveFileUtils.toZipUri(parentName, entry.getName()));
        identifier.setAncestorId(originatorNodeId);
        identifier.setParentResourceId(correlationId);
        IdentificationRequest<InputStream> request = this.factory.newRequest(metaData, identifier);
        if (this.droidCore.passesIdentificationFilter(request)) {
            try (InputStream in = null;){
                in = file.getInputStream(entry.getName());
                request.open(in);
            }
            this.droidCore.submit(request);
        }
    }

    public final void setFactory(IdentificationRequestFactory factory) {
        this.factory = factory;
    }

    public final void setDroidCore(AsynchDroid droidCore) {
        this.droidCore = droidCore;
    }

    public final void setResultHandler(ResultHandler resultHandler) {
        this.resultHandler = resultHandler;
    }

    private final class ZipArchiveWalker
    extends ArchiveFileWalker<ZipEntry> {
        private final ZipFile zipFile;
        private final ResourceId parentId;
        private final long originatorNodeId;
        private final URI parentName;
        private final Map<String, ResourceId> directories = new HashMap<String, ResourceId>();

        ZipArchiveWalker(RequestIdentifier identifier, ZipFile zipFile) {
            this.zipFile = zipFile;
            this.parentId = identifier.getResourceId();
            this.parentName = identifier.getUri();
            this.originatorNodeId = identifier.getAncestorId();
        }

        private ResourceId processAncestorFolders(String path) {
            int pathIndex;
            List<String> paths = ArchiveFileUtils.getAncestorPaths(path);
            ResourceId longestParentId = this.parentId;
            int longestSeenBefore = paths.size();
            ResourceId correlationId = null;
            for (pathIndex = 0; pathIndex < paths.size(); ++pathIndex) {
                correlationId = this.directories.get(paths.get(pathIndex));
                if (correlationId == null) continue;
                longestSeenBefore = pathIndex;
                longestParentId = correlationId;
                break;
            }
            for (pathIndex = longestSeenBefore - 1; pathIndex >= 0; --pathIndex) {
                String pathName = paths.get(pathIndex);
                ZipEntry entry = new ZipEntry(pathName);
                String dirName = FilenameUtils.getName((String)pathName.substring(0, pathName.length() - 1));
                longestParentId = TrueVfsArchiveHandler.this.submitDirectory(this.parentName, entry, dirName, longestParentId);
                this.directories.put(pathName, longestParentId);
            }
            return longestParentId;
        }

        @Override
        protected void handleEntry(ZipEntry entry) throws IOException {
            String entryName = entry.getName();
            String prefixPath = FilenameUtils.getPath((String)entryName);
            ResourceId correlationId = this.parentId;
            if (!prefixPath.isEmpty() && (correlationId = this.directories.get(prefixPath)) == null) {
                correlationId = this.processAncestorFolders(prefixPath);
            }
            entryName = entryName == null ? null : entryName.trim();
            if (!(entryName = FilenameUtils.getName((String)entryName)).isEmpty()) {
                TrueVfsArchiveHandler.this.submit(entry, entryName, this.parentName, this.zipFile, correlationId, this.originatorNodeId);
            }
        }
    }

    private static final class ZipFileIterator
    implements Iterator<ZipEntry> {
        private final Enumeration entries;

        public ZipFileIterator(ZipFile fileToIterate) {
            this.entries = fileToIterate.entries();
        }

        @Override
        public boolean hasNext() {
            return this.entries.hasMoreElements();
        }

        @Override
        public ZipEntry next() {
            return (ZipEntry)this.entries.nextElement();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

