/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.io.reader.cache;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.byteseek.io.reader.cache.WindowCache;
import net.byteseek.io.reader.windows.Window;

public abstract class AbstractFreeNotificationCache
implements WindowCache {
    private List<WindowCache.WindowObserver> windowObservers = Collections.emptyList();

    @Override
    public void subscribe(WindowCache.WindowObserver observer) {
        if (this.windowObservers.isEmpty()) {
            this.windowObservers = new ArrayList<WindowCache.WindowObserver>(1);
        }
        this.windowObservers.add(observer);
    }

    @Override
    public boolean unsubscribe(WindowCache.WindowObserver observer) {
        boolean removed = this.windowObservers.remove(observer);
        if (this.windowObservers.isEmpty()) {
            this.windowObservers = Collections.emptyList();
        }
        return removed;
    }

    protected final void notifyWindowFree(Window window, WindowCache fromCache) throws IOException {
        IOException cacheException = null;
        for (int i = 0; i < this.windowObservers.size(); ++i) {
            try {
                this.windowObservers.get(i).windowFree(window, fromCache);
                continue;
            }
            catch (IOException ex) {
                cacheException = ex;
            }
        }
        if (cacheException != null) {
            throw cacheException;
        }
    }
}

